/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dromara.autotable.annotation.AutoColumn;
import org.dromara.autotable.annotation.AutoIncrement;
import org.dromara.autotable.annotation.AutoTable;
import org.dromara.autotable.annotation.ColumnComment;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.annotation.ColumnName;
import org.dromara.autotable.annotation.ColumnNotNull;
import org.dromara.autotable.annotation.ColumnType;
import org.dromara.autotable.annotation.Ignore;
import org.dromara.autotable.annotation.Index;
import org.dromara.autotable.annotation.PrimaryKey;
import org.dromara.autotable.annotation.TableIndex;
import org.dromara.autotable.annotation.TableIndexes;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;

public class TableMetadataHandler {
    public static List<TableIndex> getTableIndexes(Class<?> clazz) {
        TableIndex tableIndex;
        ArrayList<TableIndex> tableIndices = new ArrayList<TableIndex>();
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.getAutoTableAnnotationFinder();
        TableIndexes tableIndexes = autoTableAnnotationFinder.find(clazz, TableIndexes.class);
        if (tableIndexes != null) {
            Collections.addAll(tableIndices, tableIndexes.value());
        }
        if ((tableIndex = autoTableAnnotationFinder.find(clazz, TableIndex.class)) != null) {
            tableIndices.add(tableIndex);
        }
        return tableIndices;
    }

    public static String getTableSchema(Class<?> clazz) {
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.getAutoTableAnnotationFinder();
        AutoTable autoTable = autoTableAnnotationFinder.find(clazz, AutoTable.class);
        if (autoTable != null) {
            return autoTable.schema();
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().getTableSchema(clazz);
    }

    public static String getTableName(Class<?> clazz) {
        String tableName = null;
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.getAutoTableAnnotationFinder();
        AutoTable autoTable = autoTableAnnotationFinder.find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.value())) {
            tableName = autoTable.value();
        }
        if (tableName == null) {
            tableName = AutoTableGlobalConfig.getAutoTableMetadataAdapter().getTableName(clazz);
        }
        if (tableName == null) {
            tableName = StringUtils.camelToUnderline(clazz.getSimpleName());
        }
        return tableName;
    }

    public static String getTableComment(Class<?> clazz) {
        AutoTable autoTable = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.comment())) {
            return TableMetadataHandler.replaceSingleQuote(autoTable.comment());
        }
        String adapterTableComment = AutoTableGlobalConfig.getAutoTableMetadataAdapter().getTableComment(clazz);
        if (adapterTableComment != null) {
            return TableMetadataHandler.replaceSingleQuote(adapterTableComment);
        }
        return null;
    }

    public static boolean isIncludeField(Field field, Class<?> clazz) {
        Ignore ignore = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, Ignore.class);
        if (ignore != null) {
            return false;
        }
        boolean isIgnoreField = AutoTableGlobalConfig.getAutoTableMetadataAdapter().isIgnoreField(field, clazz);
        return !isIgnoreField;
    }

    public static boolean isPrimary(Field field, Class<?> clazz) {
        PrimaryKey isPrimary = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, PrimaryKey.class);
        if (isPrimary != null) {
            return true;
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().isPrimary(field, clazz);
    }

    public static boolean isAutoIncrement(Field field, Class<?> clazz) {
        AutoIncrement autoIncrement = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoIncrement.class);
        if (autoIncrement != null) {
            return autoIncrement.value();
        }
        PrimaryKey isPrimary = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, PrimaryKey.class);
        if (isPrimary != null) {
            return isPrimary.autoIncrement();
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().isAutoIncrement(field, clazz);
    }

    public static Boolean isNotNull(Field field, Class<?> clazz) {
        if (TableMetadataHandler.isPrimary(field, clazz)) {
            return true;
        }
        if (TableMetadataHandler.isAutoIncrement(field, clazz)) {
            return true;
        }
        ColumnNotNull column = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, ColumnNotNull.class);
        if (column != null) {
            return column.value();
        }
        AutoColumn autoColumn = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        if (autoColumn != null) {
            return autoColumn.notNull();
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().isNotNull(field, clazz);
    }

    public static ColumnType getColumnType(Field field, Class<?> clazz) {
        ColumnType columnType = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, ColumnType.class);
        if (columnType != null) {
            return columnType;
        }
        final AutoColumn autoColumn = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        if (autoColumn != null) {
            return new ColumnType(){

                public String value() {
                    return autoColumn.type();
                }

                public int length() {
                    return autoColumn.length();
                }

                public int decimalLength() {
                    return autoColumn.decimalLength();
                }

                public String[] values() {
                    return new String[0];
                }

                public Class<? extends Annotation> annotationType() {
                    return ColumnType.class;
                }
            };
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().getColumnType(field, clazz);
    }

    public static String getColumnComment(Field field, Class<?> clazz) {
        ColumnComment column = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, ColumnComment.class);
        if (column != null) {
            return TableMetadataHandler.replaceSingleQuote(column.value());
        }
        AutoColumn autoColumn = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        if (autoColumn != null) {
            return TableMetadataHandler.replaceSingleQuote(autoColumn.comment());
        }
        String adapterColumnComment = AutoTableGlobalConfig.getAutoTableMetadataAdapter().getColumnComment(field, clazz);
        if (adapterColumnComment != null) {
            return TableMetadataHandler.replaceSingleQuote(adapterColumnComment);
        }
        return "";
    }

    public static String replaceSingleQuote(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replace("'", "''");
    }

    public static ColumnDefault getColumnDefaultValue(Field field, Class<?> clazz) {
        ColumnDefault columnDefault = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, ColumnDefault.class);
        if (columnDefault != null) {
            return columnDefault;
        }
        final AutoColumn autoColumn = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        if (autoColumn != null) {
            return new ColumnDefault(){

                public Class<? extends Annotation> annotationType() {
                    return ColumnDefault.class;
                }

                public DefaultValueEnum type() {
                    return autoColumn.defaultValueType();
                }

                public String value() {
                    return autoColumn.defaultValue();
                }
            };
        }
        return AutoTableGlobalConfig.getAutoTableMetadataAdapter().getColumnDefaultValue(field, clazz);
    }

    public static Index getIndex(Field field) {
        return AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, Index.class);
    }

    public static String getColumnName(Class<?> clazz, Field field) {
        String columnName;
        String columnName2;
        ColumnName columnNameAnno = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, ColumnName.class);
        if (columnNameAnno != null && StringUtils.hasText(columnName2 = columnNameAnno.value())) {
            return columnName2;
        }
        AutoColumn autoColumn = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        if (autoColumn != null && StringUtils.hasText(columnName = autoColumn.value())) {
            return columnName;
        }
        String realColumnName = AutoTableGlobalConfig.getAutoTableMetadataAdapter().getColumnName(clazz, field);
        if (StringUtils.hasText(realColumnName)) {
            return realColumnName;
        }
        return StringUtils.camelToUnderline(field.getName());
    }

    public static String getColumnName(Class<?> beanClazz, String fieldName) {
        Field field = BeanClassUtil.getField(beanClazz, fieldName);
        return TableMetadataHandler.getColumnName(beanClazz, field);
    }
}

