package org.dromara.autotable.core.converter;

import org.dromara.autotable.core.constants.DatabaseDialect;
import org.dromara.autotable.core.strategy.mysql.data.MySqlDefaultTypeEnum;

import java.lang.reflect.Field;

public class Test implements JavaTypeToDatabaseTypeConverter {

    @Override
    public DefaultTypeEnumInterface getSqlType(String databaseDialect, Class<?> clazz, Field field) {
        // 根据 类、字段 进行判断，返回对应数据库类型
        if (databaseDialect.equals(DatabaseDialect.MySQL) &&
                clazz.getName().equals("com.example.entity.User") &&
                field.getName().equals("createTime")) {
            return MySqlDefaultTypeEnum.TIMESTAMP;
        }
        // 其他情况执行默认逻辑
        return JavaTypeToDatabaseTypeConverter.super.getSqlType(databaseDialect, clazz, field);
    }
}
