/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.ibatis.session.Configuration;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.Utils;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.dynamicds.SqlSessionFactoryManager;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.pgsql.builder.CreateTableSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.builder.ModifyTableSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.builder.PgsqlTableMetadataBuilder;
import org.dromara.autotable.core.strategy.pgsql.data.PgsqlCompareTableInfo;
import org.dromara.autotable.core.strategy.pgsql.data.PgsqlDefaultTypeEnum;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbColumn;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbIndex;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbPrimary;
import org.dromara.autotable.core.strategy.pgsql.mapper.PgsqlTablesMapper;
import org.dromara.autotable.core.utils.StringUtils;

public class PgsqlStrategy
implements IStrategy<DefaultTableMetadata, PgsqlCompareTableInfo, PgsqlTablesMapper> {
    @Override
    public String databaseDialect() {
        return "PostgreSQL";
    }

    @Override
    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, PgsqlDefaultTypeEnum.VARCHAR);
                this.put(Character.class, PgsqlDefaultTypeEnum.CHAR);
                this.put(Character.TYPE, PgsqlDefaultTypeEnum.CHAR);
                this.put(Short.class, PgsqlDefaultTypeEnum.INT2);
                this.put(Short.TYPE, PgsqlDefaultTypeEnum.INT2);
                this.put(Integer.TYPE, PgsqlDefaultTypeEnum.INT4);
                this.put(Integer.class, PgsqlDefaultTypeEnum.INT4);
                this.put(Long.class, PgsqlDefaultTypeEnum.INT8);
                this.put(Long.TYPE, PgsqlDefaultTypeEnum.INT8);
                this.put(BigInteger.class, PgsqlDefaultTypeEnum.INT8);
                this.put(Boolean.class, PgsqlDefaultTypeEnum.BOOL);
                this.put(Boolean.TYPE, PgsqlDefaultTypeEnum.BOOL);
                this.put(Float.class, PgsqlDefaultTypeEnum.FLOAT4);
                this.put(Float.TYPE, PgsqlDefaultTypeEnum.FLOAT4);
                this.put(Double.class, PgsqlDefaultTypeEnum.FLOAT8);
                this.put(Double.TYPE, PgsqlDefaultTypeEnum.FLOAT8);
                this.put(BigDecimal.class, PgsqlDefaultTypeEnum.NUMERIC);
                this.put(java.util.Date.class, PgsqlDefaultTypeEnum.TIMESTAMP);
                this.put(Date.class, PgsqlDefaultTypeEnum.TIMESTAMP);
                this.put(Timestamp.class, PgsqlDefaultTypeEnum.TIMESTAMP);
                this.put(LocalDateTime.class, PgsqlDefaultTypeEnum.TIMESTAMP);
                this.put(LocalDate.class, PgsqlDefaultTypeEnum.DATE);
                this.put(LocalTime.class, PgsqlDefaultTypeEnum.TIME);
                this.put(Time.class, PgsqlDefaultTypeEnum.TIME);
                this.put(OffsetTime.class, PgsqlDefaultTypeEnum.TIMETZ);
            }
        };
    }

    @Override
    public String dropTable(String schema, String tableName) {
        return String.format("DROP TABLE IF EXISTS %s", PgsqlStrategy.withSchemaName(schema, tableName));
    }

    @Override
    @NonNull
    public DefaultTableMetadata analyseClass(Class<?> beanClass) {
        return new PgsqlTableMetadataBuilder().build(beanClass);
    }

    @Override
    public List<String> createTable(DefaultTableMetadata tableMetadata) {
        String sql = CreateTableSqlBuilder.buildSql(tableMetadata);
        return Collections.singletonList(sql);
    }

    @Override
    @NonNull
    public PgsqlCompareTableInfo compareTable(DefaultTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        PgsqlCompareTableInfo pgsqlCompareTableInfo = new PgsqlCompareTableInfo(tableName, schema);
        this.compareTableInfo(tableMetadata, pgsqlCompareTableInfo);
        this.compareColumnInfo(tableMetadata, pgsqlCompareTableInfo);
        this.compareIndexInfo(tableMetadata, pgsqlCompareTableInfo);
        return pgsqlCompareTableInfo;
    }

    @Override
    public boolean checkTableNotExist(String schema, String tableName) {
        boolean bl;
        block9: {
            Configuration configuration = SqlSessionFactoryManager.getSqlSessionFactory().getConfiguration();
            Connection connection = configuration.getEnvironment().getDataSource().getConnection();
            try {
                boolean exist;
                if (!StringUtils.hasText(schema)) {
                    schema = connection.getSchema();
                }
                boolean bl2 = bl = !(exist = Utils.tableIsExists(connection, schema, tableName, new String[]{"TABLE", "PARTITIONED TABLE"}, true));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\u51fa\u9519", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    private void compareIndexInfo(DefaultTableMetadata tableMetadata, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        List pgsqlDbIndices = this.executeReturn(pgsqlTablesMapper -> pgsqlTablesMapper.selectTableIndexesDetail(schema, tableName));
        Map pgsqlDbIndexMap = pgsqlDbIndices.stream().collect(Collectors.toMap(PgsqlDbIndex::getIndexName, Function.identity()));
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        for (IndexMetadata indexMetadata : indexMetadataList) {
            boolean anyOneIsValid;
            boolean isNewIndex;
            String indexName2 = indexMetadata.getName();
            String comment = indexMetadata.getComment();
            PgsqlDbIndex dbIndex = (PgsqlDbIndex)pgsqlDbIndexMap.remove(indexName2);
            boolean bl = isNewIndex = dbIndex == null;
            if (isNewIndex) {
                if (StringUtils.hasText(comment)) {
                    pgsqlCompareTableInfo.addIndexComment(indexMetadata.getName(), comment);
                }
                pgsqlCompareTableInfo.addNewIndex(indexMetadata);
                continue;
            }
            boolean bl2 = anyOneIsValid = StringUtils.hasText(dbIndex.getDescription()) || StringUtils.hasText(comment);
            if (anyOneIsValid && !Objects.equals(dbIndex.getDescription(), comment)) {
                pgsqlCompareTableInfo.addIndexComment(indexName2, comment);
            }
            String dbIndexdef = dbIndex.getIndexdef().replace("\"", "") + ";";
            String newIndexdef = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, indexMetadata).replace("\"", "");
            if (newIndexdef.equals(dbIndexdef)) continue;
            pgsqlCompareTableInfo.addModifyIndex(indexMetadata);
        }
        Set<String> needDropIndexes = pgsqlDbIndexMap.keySet();
        if (!needDropIndexes.isEmpty()) {
            PropertyConfig autoTableProperties = AutoTableGlobalConfig.getAutoTableProperties();
            if (autoTableProperties.getAutoDropIndex().booleanValue()) {
                List autoTableCreateIndexes = needDropIndexes.stream().filter(indexName -> indexName.startsWith(autoTableProperties.getIndexPrefix())).collect(Collectors.toList());
                pgsqlCompareTableInfo.getDropIndexList().addAll(autoTableCreateIndexes);
            }
            if (autoTableProperties.getAutoDropCustomIndex().booleanValue()) {
                List customCreateIndexes = needDropIndexes.stream().filter(indexName -> !indexName.startsWith(autoTableProperties.getIndexPrefix())).collect(Collectors.toList());
                pgsqlCompareTableInfo.getDropIndexList().addAll(customCreateIndexes);
            }
        }
    }

    private void compareColumnInfo(DefaultTableMetadata tableMetadata, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        boolean newPrimary;
        boolean primaryChange;
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        List pgsqlDbColumns = this.executeReturn(pgsqlTablesMapper -> pgsqlTablesMapper.selectTableFieldDetail(schema, tableName));
        Map pgsqlFieldDetailMap = pgsqlDbColumns.stream().collect(Collectors.toMap(PgsqlDbColumn::getColumnName, Function.identity()));
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        for (ColumnMetadata columnMetadata : columnMetadataList) {
            String columnName = columnMetadata.getName();
            PgsqlDbColumn pgsqlDbColumn = (PgsqlDbColumn)pgsqlFieldDetailMap.remove(columnName);
            String fieldComment = columnMetadata.getComment();
            if (pgsqlDbColumn == null) {
                pgsqlCompareTableInfo.addColumnComment(columnMetadata.getName(), fieldComment);
                pgsqlCompareTableInfo.addNewColumn(columnMetadata);
                continue;
            }
            String dbColumnComment = pgsqlDbColumn.getDescription();
            if ((StringUtils.hasText(dbColumnComment) || StringUtils.hasText(fieldComment)) && !Objects.equals(dbColumnComment, fieldComment)) {
                pgsqlCompareTableInfo.addColumnComment(columnName, fieldComment);
            }
            if (columnMetadata.isPrimary()) continue;
            boolean isTypeDiff = this.isTypeDiff(columnMetadata, pgsqlDbColumn);
            boolean isNotnullDiff = columnMetadata.isNotNull() != Objects.equals(pgsqlDbColumn.getIsNullable(), "NO");
            boolean isDefaultDiff = this.isDefaultDiff(columnMetadata, pgsqlDbColumn);
            if (!isTypeDiff && !isNotnullDiff && !isDefaultDiff) continue;
            pgsqlCompareTableInfo.addModifyColumn(columnMetadata);
        }
        Set<String> needRemoveColumns = pgsqlFieldDetailMap.keySet();
        if (!needRemoveColumns.isEmpty() && AutoTableGlobalConfig.getAutoTableProperties().getAutoDropColumn().booleanValue()) {
            pgsqlCompareTableInfo.addDropColumns(needRemoveColumns);
        }
        List<ColumnMetadata> primaryColumnList = columnMetadataList.stream().filter(ColumnMetadata::isPrimary).collect(Collectors.toList());
        Set newPrimaryColumns = primaryColumnList.stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        PgsqlDbPrimary pgsqlDbPrimary = this.executeReturn(pgsqlTablesMapper -> pgsqlTablesMapper.selectPrimaryKeyName(schema, tableName));
        HashSet dbPrimaryColumns = pgsqlDbPrimary == null ? new HashSet() : new HashSet<String>(Arrays.asList(pgsqlDbPrimary.getColumns().split(",")));
        boolean bl = primaryChange = !dbPrimaryColumns.equals(newPrimaryColumns);
        if (primaryChange) {
            pgsqlCompareTableInfo.setDropPrimaryKeyName(pgsqlDbPrimary.getPrimaryName());
        }
        boolean bl2 = newPrimary = !primaryColumnList.isEmpty() && pgsqlDbPrimary == null;
        if (newPrimary || primaryChange) {
            pgsqlCompareTableInfo.addNewPrimary(primaryColumnList);
        }
    }

    private boolean isTypeDiff(ColumnMetadata columnMetadata, PgsqlDbColumn pgsqlDbColumn) {
        String dataTypeFormat = pgsqlDbColumn.getDataTypeFormat();
        String fullType = columnMetadata.getType().getDefaultFullType().toLowerCase();
        if (dataTypeFormat.startsWith("int")) {
            return !dataTypeFormat.startsWith(fullType);
        }
        return !Objects.equals(fullType, dataTypeFormat);
    }

    private boolean isDefaultDiff(ColumnMetadata columnMetadata, PgsqlDbColumn pgsqlDbColumn) {
        DefaultValueEnum defaultValueType;
        int castChart;
        String columnDefault = pgsqlDbColumn.getColumnDefault();
        if (columnDefault != null && (castChart = columnDefault.indexOf("::")) > 0) {
            columnDefault = columnDefault.substring(0, castChart);
        }
        if (DefaultValueEnum.isValid((DefaultValueEnum)(defaultValueType = columnMetadata.getDefaultValueType()))) {
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return !"''".equals(columnDefault);
            }
            if (defaultValueType == DefaultValueEnum.NULL) {
                return columnDefault != null && !"NULL".equalsIgnoreCase(columnDefault);
            }
        } else {
            String defaultValue = columnMetadata.getDefaultValue();
            return !Objects.equals(defaultValue, columnDefault);
        }
        return false;
    }

    private void compareTableInfo(DefaultTableMetadata tableMetadata, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        String tableDescription = this.executeReturn(pgsqlTablesMapper -> pgsqlTablesMapper.selectTableDescription(schema, tableName));
        if (!Objects.equals(tableDescription, tableMetadata.getComment())) {
            pgsqlCompareTableInfo.setComment(tableMetadata.getComment());
        }
    }

    @Override
    public List<String> modifyTable(PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String sql = ModifyTableSqlBuilder.buildSql(pgsqlCompareTableInfo);
        return Collections.singletonList(sql);
    }

    public static String withSchemaName(String schema, String ... names) {
        String name = String.join((CharSequence)".", names);
        if (StringUtils.hasText(schema)) {
            return schema + "." + name;
        }
        return name;
    }
}

