/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.dynamicds;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDataSourceHandler {
    public static final Logger log = LoggerFactory.getLogger(IDataSourceHandler.class);

    default public void handleAnalysis(Set<Class<?>> classList, BiConsumer<String, Set<Class<?>>> consumer) {
        Map needHandleTableMap = classList.stream().collect(Collectors.groupingBy(this::getDataSourceName, Collectors.toSet()));
        needHandleTableMap.forEach((dataSource, entityClasses) -> {
            if (StringUtils.hasText(dataSource)) {
                log.info("\u4f7f\u7528\u6570\u636e\u6e90\uff1a{}", dataSource);
            }
            this.useDataSource((String)dataSource);
            DataSourceManager.setDatasourceName(dataSource);
            Map groupByDialect = entityClasses.stream().collect(Collectors.groupingBy(entityClass -> this.getDatabaseDialect((String)dataSource, (Class<?>)entityClass), Collectors.toSet()));
            try {
                groupByDialect.forEach(consumer);
            }
            finally {
                log.info("\u6e05\u7406\u6570\u636e\u6e90\uff1a{}", dataSource);
                this.clearDataSource((String)dataSource);
                DataSourceManager.cleanDatasourceName();
            }
        });
    }

    default public String getDatabaseDialect(String dataSource, Class<?> entityClass) {
        String tableDialect;
        if (entityClass != null && StringUtils.hasText(tableDialect = TableMetadataHandler.getTableDialect(entityClass))) {
            log.info("\u4f7f\u7528\u6ce8\u89e3\u4e0a\u7684\u65b9\u8a00\uff1a{}", (Object)tableDialect);
            return tableDialect;
        }
        return this.getDatabaseDialect(dataSource);
    }

    default public String getDatabaseDialect(String dataSource) {
        return DataSourceManager.useConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                log.debug("\u6570\u636e\u5e93\u94fe\u63a5 => {}, \u65b9\u8a00 => {}", (Object)metaData.getURL(), (Object)databaseProductName);
                return databaseProductName;
            }
            catch (SQLException e) {
                throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u65b9\u8a00\u5931\u8d25", e);
            }
        });
    }

    public void useDataSource(String var1);

    public void clearDataSource(String var1);

    @NonNull
    public String getDataSourceName(Class<?> var1);
}

