/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.builder;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnMetadataBuilder.class);
    protected final String databaseDialect;

    public ColumnMetadataBuilder(String databaseDialect) {
        this.databaseDialect = databaseDialect;
    }

    public <T extends ColumnMetadata> List<T> buildList(Class<?> clazz, List<Field> fields) {
        AtomicInteger index = new AtomicInteger(1);
        List columnMetadata = fields.stream().filter(field -> TableMetadataHandler.isIncludeField(field, clazz)).map(field -> this.build(clazz, (Field)field, index.getAndIncrement())).collect(Collectors.toList());
        if (columnMetadata.isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u6ce8\u610f\uff01", (Object)clazz.getName());
        }
        return columnMetadata;
    }

    public ColumnMetadata build(Class<?> clazz, Field field, int position) {
        ColumnMetadata columnMetadata = this.newColumnMetadata();
        DatabaseTypeAndLength typeAndLength = this.getTypeAndLength(this.databaseDialect, clazz, field);
        columnMetadata.setName(TableMetadataHandler.getColumnName(clazz, field)).setComment(TableMetadataHandler.getColumnComment(field, clazz)).setType(typeAndLength).setNotNull(TableMetadataHandler.isNotNull(field, clazz)).setPrimary(TableMetadataHandler.isPrimary(field, clazz)).setAutoIncrement(TableMetadataHandler.isAutoIncrement(field, clazz));
        ColumnDefault columnDefault = TableMetadataHandler.getColumnDefaultValue(field, clazz);
        if (columnDefault != null) {
            DefaultValueEnum defaultValueType = columnDefault.type();
            columnMetadata.setDefaultValueType(defaultValueType);
            String defaultValue = this.getDefaultValue(typeAndLength, columnDefault);
            columnMetadata.setDefaultValue(defaultValue);
        }
        this.customBuild(columnMetadata, clazz, field, position);
        return columnMetadata;
    }

    protected void customBuild(ColumnMetadata columnMetadata, Class<?> clazz, Field field, int position) {
    }

    protected DatabaseTypeAndLength getTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        return AutoTableGlobalConfig.getJavaTypeToDatabaseTypeConverter().convert(databaseDialect, clazz, field);
    }

    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        String defaultValue = columnDefault.value();
        if (defaultValue != null && defaultValue.isEmpty()) {
            defaultValue = null;
        }
        return defaultValue;
    }

    protected ColumnMetadata newColumnMetadata() {
        return new ColumnMetadata();
    }
}

