/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.recordsql;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.Utils;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlDbHandler
implements RecordSqlHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordSqlDbHandler.class);

    @Override
    public void record(List<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs) {
        PropertyConfig.RecordSqlProperties recordSqlConfig = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql();
        String tableName = recordSqlConfig.getTableName();
        if (StringUtils.noText(tableName)) {
            tableName = TableMetadataHandler.getTableName(AutoTableExecuteSqlLog.class);
        }
        String finalTableName = tableName;
        DataSourceManager.useConnection(connection -> {
            log.debug("\u5f00\u542fsql\u8bb0\u5f55\u4e8b\u52a1");
            try {
                connection.setAutoCommit(false);
                for (AutoTableExecuteSqlLog autoTableExecuteSqlLog : autoTableExecuteSqlLogs) {
                    String schema = autoTableExecuteSqlLog.getTableSchema();
                    boolean exists = Utils.tableIsExists(connection, schema, finalTableName, new String[]{"TABLE"}, true);
                    if (!exists) {
                        RecordSqlDbHandler.initTable(connection, finalTableName);
                        log.info("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\uff1a{}", (Object)finalTableName);
                    }
                    RecordSqlDbHandler.insertLog(finalTableName, autoTableExecuteSqlLog, connection);
                }
                log.debug("\u63d0\u4ea4sql\u8bb0\u5f55\u4e8b\u52a1");
                connection.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bb0\u5f55sql\u5230\u6570\u636e\u5e93\u51fa\u9519", e);
            }
        });
    }

    private static void insertLog(String tableName, AutoTableExecuteSqlLog autoTableExecuteSqlLog, Connection connection) throws SQLException {
        Class<AutoTableExecuteSqlLog> sqlLogClass = AutoTableExecuteSqlLog.class;
        List columnFields = Arrays.stream(sqlLogClass.getDeclaredFields()).filter(field -> TableMetadataHandler.isIncludeField(field, sqlLogClass)).collect(Collectors.toList());
        List columns = columnFields.stream().map(field -> TableMetadataHandler.getColumnName(sqlLogClass, field)).collect(Collectors.toList());
        List values = columnFields.stream().map(field -> {
            try {
                field.setAccessible(true);
                return field.get(autoTableExecuteSqlLog);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        String insertSql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, String.join((CharSequence)", ", columns), IntStream.range(0, values.size()).mapToObj(i -> "?").collect(Collectors.joining(", ")));
        log.info("\u63d2\u5165SQL\u8bb0\u5f55\uff1a{}", (Object)insertSql);
        PreparedStatement preparedStatement = connection.prepareStatement(insertSql);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            preparedStatement.setObject(i2 + 1, values.get(i2));
        }
        preparedStatement.executeUpdate();
    }

    private static void initTable(Connection connection, String customTableName) throws SQLException {
        IDataSourceHandler datasourceHandler = AutoTableGlobalConfig.getDatasourceHandler();
        String datasourceName = DataSourceManager.getDatasourceName();
        String databaseDialect = datasourceHandler.getDatabaseDialect(datasourceName);
        IStrategy<AutoTableExecuteSqlLog, AutoTableExecuteSqlLog> createTableStrategy = AutoTableGlobalConfig.getStrategy(databaseDialect);
        List<String> initTableSql = createTableStrategy.createTable(AutoTableExecuteSqlLog.class, tableMetadata -> {
            if (!Objects.equals(customTableName, tableMetadata.getTableName())) {
                try {
                    Field tableNameField = BeanClassUtil.getField(tableMetadata.getClass(), TableMetadata.tableNameFieldName);
                    tableNameField.setAccessible(true);
                    tableNameField.set(tableMetadata, customTableName);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return tableMetadata;
        });
        try (Statement statement = connection.createStatement();){
            for (String sql : initTableSql) {
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\u5931\u8d25", e);
        }
    }
}

