/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.RunMode;
import org.dromara.autotable.core.Utils;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlService;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IStrategy<TABLE_META extends TableMetadata, COMPARE_TABLE_INFO extends CompareTableInfo> {
    public static final Logger log = LoggerFactory.getLogger(IStrategy.class);

    default public void start(Class<?> entityClass) {
        AutoTableGlobalConfig.getRunBeforeCallbacks().forEach(fn -> fn.before(entityClass));
        TABLE_META tableMetadata = this.analyseClass(entityClass);
        this.start(tableMetadata);
        AutoTableGlobalConfig.getRunAfterCallbacks().forEach(fn -> fn.after(entityClass));
    }

    default public void start(TABLE_META tableMetadata) {
        AutoTableGlobalConfig.getBuildTableMetadataInterceptors().forEach(fn -> fn.intercept(this.databaseDialect(), (TableMetadata)tableMetadata));
        RunMode runMode = AutoTableGlobalConfig.getAutoTableProperties().getMode();
        switch (runMode) {
            case validate: {
                this.validateMode(tableMetadata);
                break;
            }
            case create: {
                this.createMode(tableMetadata);
                break;
            }
            case update: {
                this.updateMode(tableMetadata);
                break;
            }
            default: {
                throw new RuntimeException(String.format("\u4e0d\u652f\u6301\u7684\u8fd0\u884c\u6a21\u5f0f\uff1a%s", new Object[]{runMode}));
            }
        }
    }

    default public void validateMode(TABLE_META tableMetadata) {
        String tableName;
        String schema = ((TableMetadata)tableMetadata).getSchema();
        boolean tableNotExist = this.checkTableNotExist(schema, tableName = ((TableMetadata)tableMetadata).getTableName());
        if (tableNotExist) {
            AutoTableGlobalConfig.getValidateFinishCallbacks().forEach(fn -> fn.validateFinish(false, this.databaseDialect(), null));
            throw new RuntimeException(String.format("\u542f\u52a8\u5931\u8d25\uff0c%s\u4e2d\u4e0d\u5b58\u5728\u8868%s", this.databaseDialect(), ((TableMetadata)tableMetadata).getTableName()));
        }
        COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
        if (((CompareTableInfo)compareTableInfo).needModify()) {
            log.warn("{}\u8868\u7ed3\u6784\u4e0d\u4e00\u81f4\uff1a\n{}", (Object)((TableMetadata)tableMetadata).getTableName(), (Object)((CompareTableInfo)compareTableInfo).validateFailedMessage());
            AutoTableGlobalConfig.getValidateFinishCallbacks().forEach(fn -> fn.validateFinish(false, this.databaseDialect(), (CompareTableInfo)compareTableInfo));
            throw new RuntimeException(String.format("\u542f\u52a8\u5931\u8d25\uff0c%s\u6570\u636e\u8868%s\u4e0e\u5b9e\u4f53\u4e0d\u5339\u914d", this.databaseDialect(), ((TableMetadata)tableMetadata).getTableName()));
        }
        AutoTableGlobalConfig.getValidateFinishCallbacks().forEach(fn -> fn.validateFinish(true, this.databaseDialect(), (CompareTableInfo)compareTableInfo));
    }

    default public void createMode(TABLE_META tableMetadata) {
        String schema = ((TableMetadata)tableMetadata).getSchema();
        String tableName = ((TableMetadata)tableMetadata).getTableName();
        log.info("create\u6a21\u5f0f\uff0c\u5220\u9664\u8868\uff1a{}", (Object)tableName);
        String sql = this.dropTable(schema, tableName);
        this.executeSql(tableMetadata, Collections.singletonList(sql));
        this.executeCreateTable(tableMetadata);
    }

    default public void updateMode(TABLE_META tableMetadata) {
        String tableName;
        String schema = ((TableMetadata)tableMetadata).getSchema();
        boolean tableNotExist = this.checkTableNotExist(schema, tableName = ((TableMetadata)tableMetadata).getTableName());
        if (tableNotExist) {
            this.executeCreateTable(tableMetadata);
            return;
        }
        COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
        if (((CompareTableInfo)compareTableInfo).needModify()) {
            log.info("\u4fee\u6539\u8868\uff1a{}", (Object)((StringUtils.hasText(schema) ? schema + "." : "") + tableName));
            AutoTableGlobalConfig.getModifyTableInterceptors().forEach(fn -> fn.beforeModifyTable(this.databaseDialect(), (TableMetadata)tableMetadata, (CompareTableInfo)compareTableInfo));
            List<String> sqlList = this.modifyTable(compareTableInfo);
            this.executeSql(tableMetadata, sqlList);
            AutoTableGlobalConfig.getModifyTableFinishCallbacks().forEach(fn -> fn.afterModifyTable(this.databaseDialect(), (TableMetadata)tableMetadata, (CompareTableInfo)compareTableInfo));
        }
    }

    default public void executeCreateTable(TABLE_META tableMetadata) {
        String schema = ((TableMetadata)tableMetadata).getSchema();
        String tableName = ((TableMetadata)tableMetadata).getTableName();
        log.info("\u521b\u5efa\u8868\uff1a{}", (Object)((StringUtils.hasText(schema) ? schema + "." : "") + tableName));
        AutoTableGlobalConfig.getCreateTableInterceptors().forEach(fn -> fn.beforeCreateTable(this.databaseDialect(), (TableMetadata)tableMetadata));
        List<String> sqlList = this.createTable(tableMetadata);
        this.executeSql(tableMetadata, sqlList);
        AutoTableGlobalConfig.getCreateTableFinishCallbacks().forEach(fn -> fn.afterCreateTable(this.databaseDialect(), (TableMetadata)tableMetadata));
    }

    default public void executeSql(TABLE_META tableMetadata, List<String> sqlList) {
        ArrayList autoTableExecuteSqlLogs = new ArrayList();
        DataSourceManager.useConnection(connection -> {
            try {
                connection.setAutoCommit(false);
                try (Statement statement = connection.createStatement();){
                    boolean recordSql = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql().isEnable();
                    for (String sql : sqlList) {
                        if (!sql.endsWith(";")) {
                            sql = sql + ";";
                        }
                        long executionTime = System.currentTimeMillis();
                        statement.execute(sql);
                        long executionEndTime = System.currentTimeMillis();
                        if (recordSql) {
                            AutoTableExecuteSqlLog autoTableExecuteSqlLog = AutoTableExecuteSqlLog.of(tableMetadata.getEntityClass(), tableMetadata.getSchema(), tableMetadata.getTableName(), sql, executionTime, executionEndTime);
                            autoTableExecuteSqlLogs.add(autoTableExecuteSqlLog);
                        }
                        log.info("\u6267\u884csql({}ms)\uff1a{}", (Object)(executionEndTime - executionTime), (Object)sql);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("\u6267\u884cSQL\u671f\u95f4\u51fa\u9519: \n%s\n", String.join((CharSequence)"\n", sqlList)), e);
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (!autoTableExecuteSqlLogs.isEmpty()) {
                RecordSqlService.record(autoTableExecuteSqlLogs);
            }
        });
    }

    default public boolean checkTableNotExist(String schema, String tableName) {
        return DataSourceManager.useConnection(connection -> {
            try {
                boolean exist = Utils.tableIsExists(connection, schema, tableName, new String[]{"TABLE"}, true);
                return !exist;
            }
            catch (SQLException e) {
                throw new RuntimeException("\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\u51fa\u9519", e);
            }
        });
    }

    default public List<String> createTable(Class<?> clazz, Function<TABLE_META, TABLE_META> function) {
        Object tableMeta = this.analyseClass(clazz);
        if (function != null) {
            tableMeta = (TableMetadata)function.apply(tableMeta);
        }
        return this.createTable(tableMeta);
    }

    public String databaseDialect();

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping();

    public String dropTable(String var1, String var2);

    @NonNull
    public TABLE_META analyseClass(Class<?> var1);

    public List<String> createTable(TABLE_META var1);

    @NonNull
    public COMPARE_TABLE_INFO compareTable(TABLE_META var1);

    public List<String> modifyTable(COMPARE_TABLE_INFO var1);
}

