/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DBHelper.class);
    private static QueryRunner queryRunner = new QueryRunner();
    private static BasicRowProcessor beanConvert = new BasicRowProcessor((BeanProcessor)new AnnotationBasedBeanProcessor());

    public static <T> T queryValue(Connection connection, String sql, Map<String, Object> params) {
        sql = DBHelper.setParameters(sql, params);
        try {
            return (T)queryRunner.query(connection, sql, (ResultSetHandler)new ScalarHandler());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T queryObject(Connection connection, String sql, Map<String, Object> params, Class<T> resultClass) {
        sql = DBHelper.setParameters(sql, params);
        try {
            return (T)queryRunner.query(connection, sql, (ResultSetHandler)new BeanHandler(resultClass, (RowProcessor)beanConvert));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> queryObjectList(Connection connection, String sql, Map<String, Object> params, Class<T> resultClass) {
        sql = DBHelper.setParameters(sql, params);
        try {
            return (List)queryRunner.query(connection, sql, (ResultSetHandler)new BeanListHandler(resultClass, (RowProcessor)beanConvert));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String setParameters(String sql, Map<String, Object> params) {
        for (Map.Entry<String, Object> param : params.entrySet()) {
            sql = sql.replaceAll(":" + param.getKey(), param.getValue().toString());
        }
        log.info("SQL: {}", (Object)sql);
        return sql;
    }

    static class AnnotationBasedBeanProcessor
    extends BeanProcessor {
        AnnotationBasedBeanProcessor() {
        }

        protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
            int cols = rsmd.getColumnCount();
            int[] columnToProperty = new int[cols + 1];
            HashMap<String, Integer> propertyIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < props.length; ++i) {
                String propName = props[i].getName();
                try {
                    Field field = props[i].getReadMethod().getDeclaringClass().getDeclaredField(propName);
                    ColumnName column = field.getAnnotation(ColumnName.class);
                    if (column != null) {
                        propertyIndexMap.put(column.value().toLowerCase(), i);
                        continue;
                    }
                }
                catch (NoSuchFieldException field) {
                    // empty catch block
                }
                propertyIndexMap.put(propName.toLowerCase(), i);
            }
            for (int col = 1; col <= cols; ++col) {
                Integer propIndex;
                String columnName = rsmd.getColumnLabel(col);
                if (columnName == null || columnName.isEmpty()) {
                    columnName = rsmd.getColumnName(col);
                }
                columnToProperty[col] = (propIndex = (Integer)propertyIndexMap.get(columnName.toLowerCase())) != null ? propIndex : -1;
            }
            return columnToProperty;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ColumnName {
        public String value();
    }
}

