/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableClassScanner;
import org.dromara.autotable.core.AutoTableMetadataAdapter;
import org.dromara.autotable.core.callback.AutoTableFinishCallback;
import org.dromara.autotable.core.callback.AutoTableReadyCallback;
import org.dromara.autotable.core.callback.CompareTableFinishCallback;
import org.dromara.autotable.core.callback.CreateDatabaseFinishCallback;
import org.dromara.autotable.core.callback.CreateTableFinishCallback;
import org.dromara.autotable.core.callback.DeleteTableFinishCallback;
import org.dromara.autotable.core.callback.ModifyTableFinishCallback;
import org.dromara.autotable.core.callback.RunAfterCallback;
import org.dromara.autotable.core.callback.RunBeforeCallback;
import org.dromara.autotable.core.callback.ValidateFinishCallback;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.JavaTypeToDatabaseTypeConverter;
import org.dromara.autotable.core.dynamicds.DataSourceInfoExtractor;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.dynamicds.impl.DefaultDataSourceHandler;
import org.dromara.autotable.core.interceptor.AutoTableAnnotationInterceptor;
import org.dromara.autotable.core.interceptor.BuildTableMetadataInterceptor;
import org.dromara.autotable.core.interceptor.CreateTableInterceptor;
import org.dromara.autotable.core.interceptor.ModifyTableInterceptor;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;

public class AutoTableGlobalConfig {
    private static final ThreadLocal<AutoTableGlobalConfig> instance = ThreadLocal.withInitial(AutoTableGlobalConfig::new);
    private PropertyConfig autoTableProperties = new PropertyConfig();
    private AutoTableClassScanner autoTableClassScanner = new AutoTableClassScanner(){};
    private IDataSourceHandler datasourceHandler = new DefaultDataSourceHandler();
    private DataSourceInfoExtractor dataSourceInfoExtractor = new DataSourceInfoExtractor(){};
    private AutoTableAnnotationFinder autoTableAnnotationFinder = new AutoTableAnnotationFinder(){};
    private AutoTableMetadataAdapter autoTableMetadataAdapter = new AutoTableMetadataAdapter(){};
    private JavaTypeToDatabaseTypeConverter javaTypeToDatabaseTypeConverter = new JavaTypeToDatabaseTypeConverter(){};
    private RecordSqlHandler customRecordSqlHandler = sqlLog -> {};
    private List<AutoTableAnnotationInterceptor> autoTableAnnotationInterceptors = new ArrayList<AutoTableAnnotationInterceptor>();
    private List<BuildTableMetadataInterceptor> buildTableMetadataInterceptors = new ArrayList<BuildTableMetadataInterceptor>();
    private List<CreateTableInterceptor> createTableInterceptors = new ArrayList<CreateTableInterceptor>();
    private List<CompareTableFinishCallback> CompareTableFinishCallbacks = new ArrayList<CompareTableFinishCallback>();
    private List<ModifyTableInterceptor> modifyTableInterceptors = new ArrayList<ModifyTableInterceptor>();
    private List<ValidateFinishCallback> validateFinishCallbacks = new ArrayList<ValidateFinishCallback>();
    private List<CreateDatabaseFinishCallback> createDatabaseFinishCallbacks = new ArrayList<CreateDatabaseFinishCallback>();
    private List<CreateTableFinishCallback> createTableFinishCallbacks = new ArrayList<CreateTableFinishCallback>();
    private List<ModifyTableFinishCallback> modifyTableFinishCallbacks = new ArrayList<ModifyTableFinishCallback>();
    private List<DeleteTableFinishCallback> deleteTableFinishCallbacks = new ArrayList<DeleteTableFinishCallback>();
    private List<RunBeforeCallback> runBeforeCallbacks = new ArrayList<RunBeforeCallback>();
    private List<RunAfterCallback> runAfterCallbacks = new ArrayList<RunAfterCallback>();
    private List<AutoTableReadyCallback> autoTableReadyCallbacks = new ArrayList<AutoTableReadyCallback>();
    private List<AutoTableFinishCallback> autoTableFinishCallbacks = new ArrayList<AutoTableFinishCallback>();
    private final Map<String, IStrategy<? extends TableMetadata, ? extends CompareTableInfo>> STRATEGY_MAP = new HashMap<String, IStrategy<? extends TableMetadata, ? extends CompareTableInfo>>();
    private final List<DatabaseBuilder> DATABASE_BUILDER_LIST = new ArrayList<DatabaseBuilder>();

    public static AutoTableGlobalConfig instance() {
        return instance.get();
    }

    public static void clear() {
        instance.remove();
    }

    public void addStrategy(IStrategy<? extends TableMetadata, ? extends CompareTableInfo> strategy) {
        this.STRATEGY_MAP.put(strategy.databaseDialect(), strategy);
        JavaTypeToDatabaseTypeConverter.addTypeMapping(strategy.databaseDialect(), strategy.typeMapping());
    }

    public IStrategy<?, ?> getStrategy(String databaseDialect) {
        return this.STRATEGY_MAP.get(databaseDialect);
    }

    public Collection<IStrategy<?, ?>> getAllStrategy() {
        return this.STRATEGY_MAP.values();
    }

    public void addDatabaseBuilder(DatabaseBuilder databaseBuilder) {
        this.DATABASE_BUILDER_LIST.add(databaseBuilder);
    }

    public DatabaseBuilder getDatabaseBuilder(String jdbcUrl, String dialectOnEntity) {
        for (DatabaseBuilder databaseBuilder : this.DATABASE_BUILDER_LIST) {
            if (!databaseBuilder.support(jdbcUrl, dialectOnEntity)) continue;
            return databaseBuilder;
        }
        return null;
    }

    public Collection<DatabaseBuilder> getAllDatabaseBuilder() {
        return this.DATABASE_BUILDER_LIST;
    }

    @Generated
    public void setAutoTableProperties(PropertyConfig autoTableProperties) {
        this.autoTableProperties = autoTableProperties;
    }

    @Generated
    public PropertyConfig getAutoTableProperties() {
        return this.autoTableProperties;
    }

    @Generated
    public void setAutoTableClassScanner(AutoTableClassScanner autoTableClassScanner) {
        this.autoTableClassScanner = autoTableClassScanner;
    }

    @Generated
    public AutoTableClassScanner getAutoTableClassScanner() {
        return this.autoTableClassScanner;
    }

    @Generated
    public void setDatasourceHandler(IDataSourceHandler datasourceHandler) {
        this.datasourceHandler = datasourceHandler;
    }

    @Generated
    public IDataSourceHandler getDatasourceHandler() {
        return this.datasourceHandler;
    }

    @Generated
    public void setDataSourceInfoExtractor(DataSourceInfoExtractor dataSourceInfoExtractor) {
        this.dataSourceInfoExtractor = dataSourceInfoExtractor;
    }

    @Generated
    public DataSourceInfoExtractor getDataSourceInfoExtractor() {
        return this.dataSourceInfoExtractor;
    }

    @Generated
    public void setAutoTableAnnotationFinder(AutoTableAnnotationFinder autoTableAnnotationFinder) {
        this.autoTableAnnotationFinder = autoTableAnnotationFinder;
    }

    @Generated
    public AutoTableAnnotationFinder getAutoTableAnnotationFinder() {
        return this.autoTableAnnotationFinder;
    }

    @Generated
    public void setAutoTableMetadataAdapter(AutoTableMetadataAdapter autoTableMetadataAdapter) {
        this.autoTableMetadataAdapter = autoTableMetadataAdapter;
    }

    @Generated
    public AutoTableMetadataAdapter getAutoTableMetadataAdapter() {
        return this.autoTableMetadataAdapter;
    }

    @Generated
    public void setJavaTypeToDatabaseTypeConverter(JavaTypeToDatabaseTypeConverter javaTypeToDatabaseTypeConverter) {
        this.javaTypeToDatabaseTypeConverter = javaTypeToDatabaseTypeConverter;
    }

    @Generated
    public JavaTypeToDatabaseTypeConverter getJavaTypeToDatabaseTypeConverter() {
        return this.javaTypeToDatabaseTypeConverter;
    }

    @Generated
    public void setCustomRecordSqlHandler(RecordSqlHandler customRecordSqlHandler) {
        this.customRecordSqlHandler = customRecordSqlHandler;
    }

    @Generated
    public RecordSqlHandler getCustomRecordSqlHandler() {
        return this.customRecordSqlHandler;
    }

    @Generated
    public void setAutoTableAnnotationInterceptors(List<AutoTableAnnotationInterceptor> autoTableAnnotationInterceptors) {
        this.autoTableAnnotationInterceptors = autoTableAnnotationInterceptors;
    }

    @Generated
    public List<AutoTableAnnotationInterceptor> getAutoTableAnnotationInterceptors() {
        return this.autoTableAnnotationInterceptors;
    }

    @Generated
    public void setBuildTableMetadataInterceptors(List<BuildTableMetadataInterceptor> buildTableMetadataInterceptors) {
        this.buildTableMetadataInterceptors = buildTableMetadataInterceptors;
    }

    @Generated
    public List<BuildTableMetadataInterceptor> getBuildTableMetadataInterceptors() {
        return this.buildTableMetadataInterceptors;
    }

    @Generated
    public void setCreateTableInterceptors(List<CreateTableInterceptor> createTableInterceptors) {
        this.createTableInterceptors = createTableInterceptors;
    }

    @Generated
    public List<CreateTableInterceptor> getCreateTableInterceptors() {
        return this.createTableInterceptors;
    }

    @Generated
    public void setCompareTableFinishCallbacks(List<CompareTableFinishCallback> CompareTableFinishCallbacks) {
        this.CompareTableFinishCallbacks = CompareTableFinishCallbacks;
    }

    @Generated
    public List<CompareTableFinishCallback> getCompareTableFinishCallbacks() {
        return this.CompareTableFinishCallbacks;
    }

    @Generated
    public void setModifyTableInterceptors(List<ModifyTableInterceptor> modifyTableInterceptors) {
        this.modifyTableInterceptors = modifyTableInterceptors;
    }

    @Generated
    public List<ModifyTableInterceptor> getModifyTableInterceptors() {
        return this.modifyTableInterceptors;
    }

    @Generated
    public void setValidateFinishCallbacks(List<ValidateFinishCallback> validateFinishCallbacks) {
        this.validateFinishCallbacks = validateFinishCallbacks;
    }

    @Generated
    public List<ValidateFinishCallback> getValidateFinishCallbacks() {
        return this.validateFinishCallbacks;
    }

    @Generated
    public void setCreateDatabaseFinishCallbacks(List<CreateDatabaseFinishCallback> createDatabaseFinishCallbacks) {
        this.createDatabaseFinishCallbacks = createDatabaseFinishCallbacks;
    }

    @Generated
    public List<CreateDatabaseFinishCallback> getCreateDatabaseFinishCallbacks() {
        return this.createDatabaseFinishCallbacks;
    }

    @Generated
    public void setCreateTableFinishCallbacks(List<CreateTableFinishCallback> createTableFinishCallbacks) {
        this.createTableFinishCallbacks = createTableFinishCallbacks;
    }

    @Generated
    public List<CreateTableFinishCallback> getCreateTableFinishCallbacks() {
        return this.createTableFinishCallbacks;
    }

    @Generated
    public void setModifyTableFinishCallbacks(List<ModifyTableFinishCallback> modifyTableFinishCallbacks) {
        this.modifyTableFinishCallbacks = modifyTableFinishCallbacks;
    }

    @Generated
    public List<ModifyTableFinishCallback> getModifyTableFinishCallbacks() {
        return this.modifyTableFinishCallbacks;
    }

    @Generated
    public void setDeleteTableFinishCallbacks(List<DeleteTableFinishCallback> deleteTableFinishCallbacks) {
        this.deleteTableFinishCallbacks = deleteTableFinishCallbacks;
    }

    @Generated
    public List<DeleteTableFinishCallback> getDeleteTableFinishCallbacks() {
        return this.deleteTableFinishCallbacks;
    }

    @Generated
    public void setRunBeforeCallbacks(List<RunBeforeCallback> runBeforeCallbacks) {
        this.runBeforeCallbacks = runBeforeCallbacks;
    }

    @Generated
    public List<RunBeforeCallback> getRunBeforeCallbacks() {
        return this.runBeforeCallbacks;
    }

    @Generated
    public void setRunAfterCallbacks(List<RunAfterCallback> runAfterCallbacks) {
        this.runAfterCallbacks = runAfterCallbacks;
    }

    @Generated
    public List<RunAfterCallback> getRunAfterCallbacks() {
        return this.runAfterCallbacks;
    }

    @Generated
    public void setAutoTableReadyCallbacks(List<AutoTableReadyCallback> autoTableReadyCallbacks) {
        this.autoTableReadyCallbacks = autoTableReadyCallbacks;
    }

    @Generated
    public List<AutoTableReadyCallback> getAutoTableReadyCallbacks() {
        return this.autoTableReadyCallbacks;
    }

    @Generated
    public void setAutoTableFinishCallbacks(List<AutoTableFinishCallback> autoTableFinishCallbacks) {
        this.autoTableFinishCallbacks = autoTableFinishCallbacks;
    }

    @Generated
    public List<AutoTableFinishCallback> getAutoTableFinishCallbacks() {
        return this.autoTableFinishCallbacks;
    }
}

