/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.dynamicds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    private static final ThreadLocal<String> DATASOURCE_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<DataSource> DATA_SOURCE_THREAD_LOCAL = new ThreadLocal();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R useConnection(Function<Connection, R> function) {
        DataSource dataSource = DataSourceManager.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            R r = function.apply(connection);
            return r;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void useConnection(Consumer<Connection> consumer) {
        DataSource dataSource = DataSourceManager.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            consumer.accept(connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDataSource(@NonNull DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DATA_SOURCE_THREAD_LOCAL.set(dataSource);
    }

    public static DataSource getDataSource() {
        DataSource dataSource = DATA_SOURCE_THREAD_LOCAL.get();
        if (dataSource == null) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u6e90\u4e0b\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684SqlSessionFactory");
        }
        return dataSource;
    }

    public static void cleanDataSource() {
        DATA_SOURCE_THREAD_LOCAL.remove();
    }

    public static void setDatasourceName(@NonNull String datasourceName) {
        if (datasourceName == null) {
            throw new NullPointerException("datasourceName is marked non-null but is null");
        }
        DATASOURCE_NAME_THREAD_LOCAL.set(datasourceName);
    }

    public static String getDatasourceName() {
        String datasourceName = DATASOURCE_NAME_THREAD_LOCAL.get();
        if (datasourceName == null) {
            log.error("\u5f53\u524d\u6570\u636e\u6e90\u4e0b\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684DatasourceName");
        }
        return datasourceName;
    }

    public static void cleanDatasourceName() {
        DATASOURCE_NAME_THREAD_LOCAL.remove();
    }
}

