/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpiLoader.class);

    public static <T> List<T> loadAll(Class<T> spiClass) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            ServiceLoader<T> loader = ServiceLoader.load(spiClass);
            for (T impl : loader) {
                result.add(impl);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error("SPI \u52a0\u8f7d\u5931\u8d25: {}", (Object)spiClass.getName(), (Object)e);
        }
        return result;
    }

    public static <T> T loadFirst(Class<T> spiClass, Supplier<T> defaultSupplier) {
        try {
            ServiceLoader<T> loader = ServiceLoader.load(spiClass);
            Iterator<T> iterator = loader.iterator();
            if (iterator.hasNext()) {
                T impl = iterator.next();
                log.info("\u52a0\u8f7d\u5230 SPI \u5b9e\u73b0: {}", (Object)impl.getClass().getName());
                return impl;
            }
            log.warn("\u672a\u627e\u5230 SPI \u5b9e\u73b0\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0: {}", (Object)spiClass.getName());
            return defaultSupplier.get();
        }
        catch (ServiceConfigurationError e) {
            log.error("SPI \u52a0\u8f7d\u5931\u8d25: {}", (Object)spiClass.getName(), (Object)e);
            return defaultSupplier.get();
        }
    }

    public static <T> T loadFirstOrNull(Class<T> spiClass) {
        try {
            ServiceLoader<T> loader = ServiceLoader.load(spiClass);
            Iterator<T> iterator = loader.iterator();
            if (iterator.hasNext()) {
                T impl = iterator.next();
                log.info("\u52a0\u8f7d\u5230 SPI \u5b9e\u73b0: {}", (Object)impl.getClass().getName());
                return impl;
            }
            log.warn("\u672a\u627e\u5230 SPI \u5b9e\u73b0: {}", (Object)spiClass.getName());
            return null;
        }
        catch (ServiceConfigurationError e) {
            log.error("SPI \u52a0\u8f7d\u5931\u8d25: {}", (Object)spiClass.getName(), (Object)e);
            return null;
        }
    }
}

