/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.Banner;
import org.dromara.autotable.core.RunMode;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.initdata.InitDataHandler;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.DataSourceInfoExtractor;
import org.dromara.autotable.core.utils.SpiLoader;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTableBootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoTableBootstrap.class);

    public static void start() {
        PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
        if (autoTableProperties.getMode() == RunMode.none || !autoTableProperties.getEnable().booleanValue()) {
            return;
        }
        if (autoTableProperties.getShowBanner().booleanValue()) {
            Banner.print();
        }
        long start = System.currentTimeMillis();
        AutoTableBootstrap.registerAllDbStrategy();
        AutoTableBootstrap.registerAllDatabaseBuilder();
        Set<Class<?>> classes = AutoTableBootstrap.findAllEntityClass(autoTableProperties);
        AutoTableGlobalConfig.instance().getAutoTableReadyCallbacks().forEach(fn -> fn.ready(classes));
        AutoTableBootstrap.handleAnalysis(classes);
        AutoTableGlobalConfig.instance().getAutoTableFinishCallbacks().forEach(fn -> fn.finish(classes));
        AutoTableGlobalConfig.instance();
        AutoTableGlobalConfig.clear();
        log.info("AutoTable\u6267\u884c\u7ed3\u675f\u3002\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private static void handleAnalysis(Set<Class<?>> classList) {
        IDataSourceHandler datasourceHandler = AutoTableGlobalConfig.instance().getDatasourceHandler();
        Map needHandleTableMap = classList.stream().collect(Collectors.groupingBy(datasourceHandler::getDataSourceName, Collectors.toSet()));
        needHandleTableMap.forEach((dataSource, entityClasses) -> {
            if (StringUtils.hasText(dataSource)) {
                log.info("\u4f7f\u7528\u6570\u636e\u6e90\uff1a{}", dataSource);
            }
            AutoTableBootstrap.checkRepeatTableName(entityClasses);
            datasourceHandler.useDataSource((String)dataSource);
            DataSourceManager.setDatasourceName(dataSource);
            String dialectOnEntity = AutoTableBootstrap.findDialectOnEntity(dataSource, entityClasses);
            DatabaseBuilder.BuildResult buildResult = AutoTableBootstrap.buildDatabaseIfAbsent(dataSource, entityClasses, dialectOnEntity);
            boolean buildNewDb = buildResult != null && buildResult.isSuccess();
            try {
                String dialect = StringUtils.hasText(dialectOnEntity) ? dialectOnEntity : AutoTableBootstrap.getDatabaseDialectFromConnection(dataSource);
                IStrategy<?, ?> databaseStrategy = AutoTableGlobalConfig.instance().getStrategy(dialect);
                if (databaseStrategy == null) {
                    log.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\uff08{}\uff09\u65b9\u8a00\u7b56\u7565\uff0c\u65e0\u6cd5\u81ea\u52a8\u7ef4\u62a4\u8868\u7ed3\u6784", (Object)dialect);
                    return;
                }
                IStrategy.setCurrentStrategy(databaseStrategy);
                AutoTableBootstrap.executeStrategy(databaseStrategy, entityClasses);
                if (buildNewDb) {
                    InitDataHandler.initDbData();
                }
            }
            finally {
                if (StringUtils.hasText(dataSource)) {
                    log.info("\u6e05\u7406\u6570\u636e\u6e90\uff1a{}", dataSource);
                }
                datasourceHandler.clearDataSource((String)dataSource);
                DataSourceManager.cleanDatasourceName();
                IStrategy.clean();
            }
        });
    }

    private static String findDialectOnEntity(String dataSource, Set<Class<?>> entityClasses) {
        List dialectInAnnotation = entityClasses.stream().map(TableMetadataHandler::getTableDialect).distinct().collect(Collectors.toList());
        if (dialectInAnnotation.size() > 1) {
            throw new RuntimeException("\u540c\u4e00\u4e2a\u6570\u636e\u6e90(" + dataSource + ")\u4e0b\uff0c\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u591a\u4e2a\u6570\u636e\u5e93\u65b9\u8a00[" + String.join((CharSequence)",", dialectInAnnotation) + "]");
        }
        String dialectOnEntity = (String)dialectInAnnotation.get(0);
        return dialectOnEntity;
    }

    private static DatabaseBuilder.BuildResult buildDatabaseIfAbsent(String dataSource, Set<Class<?>> entityClasses, String dialectOnEntity) {
        PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
        boolean autoBuildDatabase = autoTableProperties.getAutoBuildDatabase();
        if (autoBuildDatabase) {
            DatabaseBuilder.BuildResult buildResult;
            DataSourceInfoExtractor.DbInfo dbInfo = DataSourceInfoExtractor.extract(DataSourceManager.getDataSource());
            DatabaseBuilder databaseBuilder = AutoTableGlobalConfig.instance().getDatabaseBuilder(dbInfo.jdbcUrl, dialectOnEntity);
            if (databaseBuilder != null && (buildResult = databaseBuilder.build(dbInfo.jdbcUrl, dbInfo.username, dbInfo.password, dbExists -> {
                if (!dbExists.booleanValue()) {
                    boolean isValidateMode;
                    boolean bl = isValidateMode = autoTableProperties.getMode() == RunMode.validate;
                    if (isValidateMode) {
                        throw new RuntimeException("\u3010validate\u6a21\u5f0f\u3011\u3002\u6570\u636e\u6e90\uff1a" + dataSource + "\u6570\u636e\u5e93\u94fe\u63a5" + dbInfo.jdbcUrl + "\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\uff01");
                    }
                }
            })).isSuccess()) {
                AutoTableGlobalConfig.instance().getCreateDatabaseFinishCallbacks().forEach(callback -> callback.afterCreateDatabase(dataSource, entityClasses, dbInfo));
                return buildResult;
            }
        }
        return null;
    }

    private static String getDatabaseDialectFromConnection(String dataSource) {
        return DataSourceManager.useConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                log.debug("\u6570\u636e\u5e93\u94fe\u63a5 => {}, \u65b9\u8a00 => {}", (Object)metaData.getURL(), (Object)databaseProductName);
                return databaseProductName;
            }
            catch (SQLException e) {
                throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u65b9\u8a00\u5931\u8d25", e);
            }
        });
    }

    private static void executeStrategy(IStrategy<?, ?> databaseStrategy, Set<Class<?>> entityClasses) {
        HashMap<String, Set<String>> registerTableNameMap = new HashMap<String, Set<String>>();
        for (Class<?> entityClass : entityClasses) {
            log.info("{}\u6267\u884c{}\u65b9\u8a00\u7b56\u7565", (Object)entityClass.getName(), (Object)databaseStrategy.databaseDialect());
            Object tableMetadata = databaseStrategy.start(entityClass);
            registerTableNameMap.computeIfAbsent(((TableMetadata)tableMetadata).getSchema(), k -> new HashSet()).add(((TableMetadata)tableMetadata).getTableName());
        }
        Boolean autoDropTable = AutoTableGlobalConfig.instance().getAutoTableProperties().getAutoDropTable();
        if (autoDropTable.booleanValue()) {
            AutoTableBootstrap.deleteUnregisterTables(registerTableNameMap, databaseStrategy);
        }
    }

    private static void deleteUnregisterTables(Map<String, Set<String>> registerTableNameMap, IStrategy<?, ?> databaseStrategy) {
        registerTableNameMap.forEach((schema, tableNames) -> {
            List<String> allTableNames = databaseStrategy.listAllTables((String)schema);
            String[] autoDropTableIgnores = AutoTableGlobalConfig.instance().getAutoTableProperties().getAutoDropTableIgnores();
            if (autoDropTableIgnores != null) {
                allTableNames.removeAll(Arrays.asList(autoDropTableIgnores));
            }
            allTableNames.removeAll((Collection<?>)tableNames);
            allTableNames.forEach(tableName -> {
                log.info("\u8868{}{}\u6ca1\u6709\u58f0\u660e\uff0c\u6267\u884c\u5220\u9664\uff01", (Object)(StringUtils.hasText(schema) ? schema + "." : ""), tableName);
                DataSourceManager.useConnection(connection -> {
                    String sql = databaseStrategy.dropTable((String)schema, (String)tableName);
                    try (Statement statement = connection.createStatement();){
                        statement.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                AutoTableGlobalConfig.instance().getDeleteTableFinishCallbacks().forEach(fn -> fn.afterDeleteTables((String)schema, (String)tableName));
            });
        });
    }

    private static void checkRepeatTableName(Set<Class<?>> entityClasses) {
        Map<String, List<Class>> repeatCheckMap = entityClasses.stream().collect(Collectors.groupingBy(entity -> TableMetadataHandler.getTableSchema(entity) + "." + TableMetadataHandler.getTableName(entity)));
        for (Map.Entry<String, List<Class>> repeatCheckItem : repeatCheckMap.entrySet()) {
            int sameTableNameCount = repeatCheckItem.getValue().size();
            if (sameTableNameCount <= 1) continue;
            String tableName = repeatCheckItem.getKey();
            throw new RuntimeException(String.format("\u5b58\u5728\u91cd\u540d\u7684\u8868\uff1a%s(%s)\uff0c\u8bf7\u68c0\u67e5\uff01", tableName, String.join((CharSequence)",", repeatCheckItem.getValue().stream().map(Class::getName).collect(Collectors.toSet()))));
        }
    }

    private static Set<Class<?>> findAllEntityClass(PropertyConfig autoTableProperties) {
        Class<?>[] modelClass = autoTableProperties.getModelClass();
        HashSet classes = new HashSet(Arrays.asList(modelClass));
        String[] packs = AutoTableBootstrap.getModelPackage(autoTableProperties);
        Set<Class<?>> packClasses = AutoTableGlobalConfig.instance().getAutoTableClassScanner().scan(packs);
        classes.addAll(packClasses);
        return classes;
    }

    private static void registerAllDbStrategy() {
        List<IStrategy> strategies = SpiLoader.loadAll(IStrategy.class);
        if (strategies.isEmpty()) {
            log.warn("\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u6570\u636e\u5e93\u7b56\u7565\uff01");
        } else {
            for (IStrategy provider : strategies) {
                log.info("\u6ce8\u518c\u6570\u636e\u5e93\u7b56\u7565\uff1a{}", (Object)provider.databaseDialect());
                AutoTableGlobalConfig.instance().addStrategy(provider);
            }
        }
    }

    private static void registerAllDatabaseBuilder() {
        List<DatabaseBuilder> databaseBuilders = SpiLoader.loadAll(DatabaseBuilder.class);
        if (!databaseBuilders.isEmpty()) {
            for (DatabaseBuilder databaseBuilder : databaseBuilders) {
                AutoTableGlobalConfig.instance().addDatabaseBuilder(databaseBuilder);
            }
        }
    }

    private static String[] getModelPackage(PropertyConfig autoTableProperties) {
        String[] packs = autoTableProperties.getModelPackage();
        Class<?>[] modelClass = autoTableProperties.getModelClass();
        if (packs.length == 0 && modelClass.length == 0) {
            packs = new String[]{AutoTableBootstrap.getBootPackage()};
        }
        return packs;
    }

    private static String getBootPackage() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            String mainClassName = stackTraceElement.getClassName();
            int lastDotIndex = mainClassName.lastIndexOf(".");
            return lastDotIndex != -1 ? mainClassName.substring(0, lastDotIndex) : "";
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }
}

