/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.dromara.autotable.core.utils.StringUtils;

public class DataSourceInfoExtractor {
    public static DbInfo extract(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource\u4e0d\u80fd\u4e3anull");
        }
        String url = DataSourceInfoExtractor.tryGet(dataSource, "getJdbcUrl", "getUrl");
        String username = DataSourceInfoExtractor.tryGet(dataSource, "getUsername", "getUser");
        String password = DataSourceInfoExtractor.tryGet(dataSource, "getPassword");
        if (url == null) {
            throw new RuntimeException("\u672a\u80fd\u901a\u8fc7\u53cd\u5c04\u4ece DataSource \u83b7\u53d6\u5230 JDBC URL");
        }
        return new DbInfo(url, username, password);
    }

    private static String tryGet(DataSource obj, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method method = obj.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                Object value = method.invoke((Object)obj, new Object[0]);
                if (!(value instanceof String) || !StringUtils.hasText((String)value)) continue;
                return (String)value;
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                System.out.println("\u8c03\u7528\u65b9\u6cd5 " + name + " \u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (String name : methodNames) {
            String fieldName = name.replaceFirst("^get", "");
            if (fieldName.isEmpty()) continue;
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Field field = obj.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(obj);
                if (!(value instanceof String) || !StringUtils.hasText((String)value)) continue;
                return (String)value;
            }
            catch (NoSuchFieldException field) {
            }
            catch (Exception e) {
                System.out.println("\u8bfb\u53d6\u5b57\u6bb5 " + fieldName + " \u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    public static class DbInfo {
        public final String jdbcUrl;
        public final String username;
        public final String password;

        public DbInfo(String jdbcUrl, String username, String password) {
            this.jdbcUrl = jdbcUrl;
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return "JDBC\u5730\u5740\uff1a" + this.jdbcUrl + ", \u7528\u6237\u540d\uff1a" + this.username + ", \u5bc6\u7801\uff1a" + (this.password == null ? "null" : "******");
        }
    }
}

