/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dromara.autotable.annotation.AutoColumn;
import org.dromara.autotable.annotation.AutoColumns;
import org.dromara.autotable.annotation.AutoIncrement;
import org.dromara.autotable.annotation.AutoTable;
import org.dromara.autotable.annotation.ColumnComment;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.annotation.ColumnName;
import org.dromara.autotable.annotation.ColumnNotNull;
import org.dromara.autotable.annotation.ColumnType;
import org.dromara.autotable.annotation.Ignore;
import org.dromara.autotable.annotation.Index;
import org.dromara.autotable.annotation.PrimaryKey;
import org.dromara.autotable.annotation.TableIndex;
import org.dromara.autotable.annotation.TableIndexes;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;

public class TableMetadataHandler {
    public static List<TableIndex> getTableIndexes(Class<?> clazz) {
        TableIndex tableIndex;
        ArrayList<TableIndex> tableIndices = new ArrayList<TableIndex>();
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        TableIndexes tableIndexes = autoTableAnnotationFinder.find(clazz, TableIndexes.class);
        if (tableIndexes != null) {
            Collections.addAll(tableIndices, tableIndexes.value());
        }
        if ((tableIndex = autoTableAnnotationFinder.find(clazz, TableIndex.class)) != null) {
            tableIndices.add(tableIndex);
        }
        return tableIndices;
    }

    public static String getTableDialect(Class<?> clazz) {
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        AutoTable autoTable = autoTableAnnotationFinder.find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.dialect())) {
            return autoTable.dialect();
        }
        return AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getTableDialect(clazz);
    }

    public static String getTableSchema(Class<?> clazz) {
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        AutoTable autoTable = autoTableAnnotationFinder.find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.schema())) {
            return autoTable.schema();
        }
        return AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getTableSchema(clazz);
    }

    public static String getTableName(Class<?> clazz) {
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        AutoTable autoTable = autoTableAnnotationFinder.find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.value())) {
            return autoTable.value();
        }
        String tableName = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getTableName(clazz);
        if (StringUtils.hasText(tableName)) {
            return tableName;
        }
        return StringUtils.camelToUnderline(clazz.getSimpleName());
    }

    public static String getTableComment(Class<?> clazz) {
        AutoTable autoTable = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(clazz, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.comment())) {
            return TableMetadataHandler.replaceSingleQuote(autoTable.comment());
        }
        String adapterTableComment = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getTableComment(clazz);
        if (StringUtils.hasText(adapterTableComment)) {
            return TableMetadataHandler.replaceSingleQuote(adapterTableComment);
        }
        return null;
    }

    public static String getTableInitSql(Class<?> entityClass) {
        AutoTable autoTable = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(entityClass, AutoTable.class);
        if (autoTable != null && StringUtils.hasText(autoTable.initSql())) {
            return autoTable.initSql();
        }
        return null;
    }

    public static boolean isIncludeField(Field field, Class<?> clazz) {
        Ignore ignore = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, Ignore.class);
        if (ignore != null) {
            return false;
        }
        Boolean isIgnoreField = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().isIgnoreField(field, clazz);
        if (isIgnoreField != null) {
            return isIgnoreField == false;
        }
        return true;
    }

    public static boolean isPrimary(Field field, Class<?> clazz) {
        PrimaryKey isPrimary = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, PrimaryKey.class);
        if (isPrimary != null) {
            return true;
        }
        Boolean primary = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().isPrimary(field, clazz);
        if (primary != null) {
            return primary;
        }
        return false;
    }

    public static boolean isAutoIncrement(Field field, Class<?> clazz) {
        AutoIncrement autoIncrement = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, AutoIncrement.class);
        if (autoIncrement != null) {
            return autoIncrement.value();
        }
        Boolean isAutoIncrement = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().isAutoIncrement(field, clazz);
        if (isAutoIncrement != null) {
            return isAutoIncrement;
        }
        PrimaryKey isPrimary = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, PrimaryKey.class);
        if (isPrimary != null) {
            return isPrimary.autoIncrement();
        }
        return false;
    }

    public static Boolean isNotNull(Field field, Class<?> clazz) {
        if (TableMetadataHandler.isPrimary(field, clazz)) {
            return true;
        }
        if (TableMetadataHandler.isAutoIncrement(field, clazz)) {
            return true;
        }
        ColumnNotNull column = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, ColumnNotNull.class);
        if (column != null) {
            return column.value();
        }
        Boolean notNull = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().isNotNull(field, clazz);
        if (notNull != null) {
            return notNull;
        }
        AutoColumn autoColumn = TableMetadataHandler.findAutoColumn(field);
        if (autoColumn != null) {
            return autoColumn.notNull();
        }
        return false;
    }

    public static ColumnType getColumnType(Field field, Class<?> clazz) {
        ColumnType columnType = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, ColumnType.class);
        if (columnType != null) {
            return columnType;
        }
        final AutoColumn autoColumn = TableMetadataHandler.findAutoColumn(field);
        if (autoColumn != null && (StringUtils.hasText(autoColumn.type()) || autoColumn.length() > 0 || autoColumn.decimalLength() > 0)) {
            return new ColumnType(){

                public String value() {
                    return autoColumn.type();
                }

                public int length() {
                    return autoColumn.length();
                }

                public int decimalLength() {
                    return autoColumn.decimalLength();
                }

                public String[] values() {
                    return new String[0];
                }

                public Class<? extends Annotation> annotationType() {
                    return ColumnType.class;
                }
            };
        }
        return AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getColumnType(field, clazz);
    }

    public static String getColumnComment(Field field, Class<?> clazz) {
        ColumnComment column = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, ColumnComment.class);
        if (column != null) {
            return TableMetadataHandler.replaceSingleQuote(column.value());
        }
        AutoColumn autoColumn = TableMetadataHandler.findAutoColumn(field);
        if (autoColumn != null && StringUtils.hasText(autoColumn.comment())) {
            return TableMetadataHandler.replaceSingleQuote(autoColumn.comment());
        }
        String adapterColumnComment = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getColumnComment(field, clazz);
        if (StringUtils.hasText(adapterColumnComment)) {
            return TableMetadataHandler.replaceSingleQuote(adapterColumnComment);
        }
        return "";
    }

    public static ColumnDefault getColumnDefaultValue(Field field, Class<?> clazz) {
        ColumnDefault columnDefault = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, ColumnDefault.class);
        if (columnDefault != null) {
            return columnDefault;
        }
        final AutoColumn autoColumn = TableMetadataHandler.findAutoColumn(field);
        if (autoColumn != null && (autoColumn.defaultValueType() != DefaultValueEnum.UNDEFINED || StringUtils.hasText(autoColumn.defaultValue()))) {
            return new ColumnDefault(){

                public Class<? extends Annotation> annotationType() {
                    return ColumnDefault.class;
                }

                public DefaultValueEnum type() {
                    return autoColumn.defaultValueType();
                }

                public String value() {
                    return autoColumn.defaultValue();
                }
            };
        }
        return AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getColumnDefaultValue(field, clazz);
    }

    public static String getColumnName(Class<?> clazz, Field field) {
        ColumnName columnNameAnno = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, ColumnName.class);
        if (columnNameAnno != null) {
            return columnNameAnno.value();
        }
        AutoColumn autoColumn = TableMetadataHandler.findAutoColumn(field);
        if (autoColumn != null && StringUtils.hasText(autoColumn.value())) {
            return autoColumn.value();
        }
        String realColumnName = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getColumnName(clazz, field);
        if (StringUtils.hasText(realColumnName)) {
            return realColumnName;
        }
        return StringUtils.camelToUnderline(field.getName());
    }

    public static String getColumnName(Class<?> beanClazz, String fieldName) {
        Field field = BeanClassUtil.getField(beanClazz, fieldName);
        return TableMetadataHandler.getColumnName(beanClazz, field);
    }

    private static AutoColumn findAutoColumn(Field field) {
        AutoColumns autoColumns;
        AutoColumn autoColumn = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, AutoColumn.class);
        String databaseDialect = IStrategy.getCurrentStrategy().databaseDialect();
        if (autoColumn != null) {
            String dialect = autoColumn.dialect();
            if (StringUtils.noText(dialect) || dialect.equals(databaseDialect)) {
                return autoColumn;
            }
            autoColumn = null;
        }
        if ((autoColumns = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, AutoColumns.class)) != null && (autoColumn = (AutoColumn)Arrays.stream(autoColumns.value()).filter(ac -> databaseDialect.equals(ac.dialect())).findFirst().orElse(null)) == null) {
            autoColumn = Arrays.stream(autoColumns.value()).filter(ac -> StringUtils.noText(ac.dialect())).findFirst().orElse(null);
        }
        return autoColumn;
    }

    private static String replaceSingleQuote(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replace("'", "''");
    }

    public static Index getIndex(Field field) {
        return AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, Index.class);
    }
}

