/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.recordsql;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.recordsql.SimpleDataSource;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlDbHandler
implements RecordSqlHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordSqlDbHandler.class);

    @Override
    public void record(List<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs) {
        block14: {
            String tableName = RecordSqlDbHandler.getRecordSqlTableName();
            PropertyConfig.RecordSqlProperties recordSqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getRecordSql();
            PropertyConfig.Datasource datasource = recordSqlConfig.getDatasource();
            if (datasource != null && StringUtils.hasText(datasource.getUrl())) {
                try {
                    SimpleDataSource simpleDataSource = new SimpleDataSource(datasource.getUrl(), datasource.getUsername(), datasource.getPassword(), datasource.getDriverClassName());
                    DataSourceManager.setDataSource(simpleDataSource);
                    try (Connection connection2 = simpleDataSource.getConnection();){
                        String databaseProductName = connection2.getMetaData().getDatabaseProductName();
                        log.debug("\u8bb0\u5f55SQL\uff0c\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\uff0c\u6570\u636e\u5e93\u94fe\u63a5 => {}, \u65b9\u8a00 => {}", (Object)datasource.getUrl(), (Object)databaseProductName);
                        IStrategy<?, ?> createTableStrategy = AutoTableGlobalConfig.instance().getStrategy(databaseProductName);
                        RecordSqlDbHandler.executeInsertSql(createTableStrategy, autoTableExecuteSqlLogs, connection2, tableName);
                        break block14;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        DataSourceManager.cleanDataSource();
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            IStrategy<?, ?> createTableStrategy = IStrategy.getCurrentStrategy();
            DataSourceManager.useConnection(connection -> RecordSqlDbHandler.executeInsertSql(createTableStrategy, autoTableExecuteSqlLogs, connection, tableName));
        }
    }

    public static String getRecordSqlTableName() {
        PropertyConfig.RecordSqlProperties recordSqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getRecordSql();
        String tableName = StringUtils.hasText(recordSqlConfig.getTableName()) ? recordSqlConfig.getTableName() : TableMetadataHandler.getTableName(AutoTableExecuteSqlLog.class);
        return tableName;
    }

    private static void executeInsertSql(IStrategy<?, ?> createTableStrategy, List<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs, Connection connection, String finalTableName) {
        log.debug("\u5f00\u542fsql\u8bb0\u5f55\u4e8b\u52a1");
        try {
            connection.setAutoCommit(false);
            for (AutoTableExecuteSqlLog autoTableExecuteSqlLog : autoTableExecuteSqlLogs) {
                String schema = autoTableExecuteSqlLog.getTableSchema();
                String schemaTableName = createTableStrategy.concatWrapName(schema, finalTableName);
                if (createTableStrategy.checkTableNotExist(schema, finalTableName)) {
                    RecordSqlDbHandler.initTable(createTableStrategy, connection, schema, finalTableName);
                    log.info("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\uff1a{}", (Object)schemaTableName);
                }
                RecordSqlDbHandler.insertLog(schemaTableName, autoTableExecuteSqlLog, connection);
            }
            log.debug("\u63d0\u4ea4sql\u8bb0\u5f55\u4e8b\u52a1");
            connection.commit();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bb0\u5f55sql\u5230\u6570\u636e\u5e93\u51fa\u9519", e);
        }
    }

    private static void insertLog(String tableName, AutoTableExecuteSqlLog autoTableExecuteSqlLog, Connection connection) throws SQLException {
        Class<AutoTableExecuteSqlLog> sqlLogClass = AutoTableExecuteSqlLog.class;
        List columnFields = Arrays.stream(sqlLogClass.getDeclaredFields()).filter(field -> TableMetadataHandler.isIncludeField(field, sqlLogClass)).collect(Collectors.toList());
        List columns = columnFields.stream().map(field -> TableMetadataHandler.getColumnName(sqlLogClass, field)).map(IStrategy::wrapIdentifiers).collect(Collectors.toList());
        List values = columnFields.stream().map(field -> {
            try {
                field.setAccessible(true);
                return field.get(autoTableExecuteSqlLog);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        String insertSql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, String.join((CharSequence)", ", columns), IntStream.range(0, values.size()).mapToObj(i -> "?").collect(Collectors.joining(", ")));
        log.info("\u63d2\u5165SQL\u8bb0\u5f55\uff1a{}", (Object)insertSql);
        PreparedStatement preparedStatement = connection.prepareStatement(insertSql);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            preparedStatement.setObject(i2 + 1, values.get(i2));
        }
        preparedStatement.executeUpdate();
    }

    private static void initTable(IStrategy<?, ?> createTableStrategy, Connection connection, String schema, String customTableName) throws SQLException {
        List<String> initTableSql = createTableStrategy.createTable(AutoTableExecuteSqlLog.class, tableMetadata -> {
            if (!Objects.equals(customTableName, tableMetadata.getTableName())) {
                try {
                    Field tableNameField = BeanClassUtil.getField(tableMetadata.getClass(), TableMetadata.tableNameFieldName);
                    tableNameField.setAccessible(true);
                    tableNameField.set(tableMetadata, customTableName);
                    Field schemaField = BeanClassUtil.getField(tableMetadata.getClass(), TableMetadata.schemaFieldName);
                    schemaField.setAccessible(true);
                    schemaField.set(tableMetadata, schema);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return tableMetadata;
        });
        try (Statement statement = connection.createStatement();){
            for (String sql : initTableSql) {
                log.debug("\u6267\u884csql\uff1a{}", (Object)sql);
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\u5931\u8d25", e);
        }
    }
}

