/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class AnnotationDefaultValueHelper {
    public static <A extends Annotation> A getAnnotationWithDefaultValues(Class<A> annotationType) {
        Map<String, Object> defaultValues = AnnotationDefaultValueHelper.getDefaultValues(annotationType);
        return AnnotationDefaultValueHelper.createAnnotationInstance(annotationType, defaultValues);
    }

    public static <A extends Annotation> Map<String, Object> getDefaultValues(Class<A> annotationType) {
        Method[] declaredMethods;
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        for (Method method : declaredMethods = annotationType.getDeclaredMethods()) {
            if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE) continue;
            Object defaultValue = method.getDefaultValue();
            defaultValues.put(method.getName(), defaultValue);
        }
        return defaultValues;
    }

    public static <A extends Annotation> A createAnnotationInstance(Class<A> annotationType, final Map<String, Object> values) {
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (values.containsKey(methodName)) {
                    return values.get(methodName);
                }
                return method.invoke((Object)this, args);
            }
        }));
    }
}

