/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.dynamicds;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataSourceInfoExtractor {
    public static final Logger log = LoggerFactory.getLogger(DataSourceInfoExtractor.class);

    default public DbInfo extract(DataSource dataSource) {
        if (dataSource == null) {
            log.warn("\u5f53\u524d\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u53d6\u6570\u636e\u94fe\u63a5\u4fe1\u606f");
            return null;
        }
        String url = this.tryGet(dataSource, "getJdbcUrl", "getUrl");
        String username = this.tryGet(dataSource, "getUsername", "getUser");
        String password = this.tryGet(dataSource, "getPassword");
        if (url == null) {
            log.warn("\u672a\u80fd\u901a\u8fc7\u53cd\u5c04\u4ece {} \u83b7\u53d6\u5230 JDBC URL, \u82e5\u6709\u5efa\u5e93\u9700\u8981\u53ef\u81ea\u884c\u5b9e\u73b0\u63d0\u53d6\u903b\u8f91", (Object)dataSource.getClass().getName());
            return null;
        }
        return new DbInfo(url, username, password);
    }

    default public String tryGet(DataSource obj, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method method = obj.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                Object value = method.invoke((Object)obj, new Object[0]);
                if (!(value instanceof String) || !StringUtils.hasText((String)value)) continue;
                return (String)value;
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                System.out.println("\u8c03\u7528\u65b9\u6cd5 " + name + " \u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (String name : methodNames) {
            String fieldName = name.replaceFirst("^get", "");
            if (fieldName.isEmpty()) continue;
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Field field = obj.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(obj);
                if (!(value instanceof String) || !StringUtils.hasText((String)value)) continue;
                return (String)value;
            }
            catch (NoSuchFieldException field) {
            }
            catch (Exception e) {
                System.out.println("\u8bfb\u53d6\u5b57\u6bb5 " + fieldName + " \u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    public static class DbInfo {
        public final String jdbcUrl;
        public final String username;
        public final String password;

        public DbInfo(String jdbcUrl, String username, String password) {
            this.jdbcUrl = jdbcUrl;
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return "JDBC\u5730\u5740\uff1a" + this.jdbcUrl + ", \u7528\u6237\u540d\uff1a" + this.username + ", \u5bc6\u7801\uff1a" + (this.password == null ? "null" : "******");
        }
    }
}

