/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.AutoColumn;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;

public class BeanClassUtil {
    public static Field getField(Class<?> clazz, String fieldName) {
        Class<?> superclass;
        Field field;
        while ((field = (Field)Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst().orElse(null)) == null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            clazz = superclass;
        }
        if (field == null) {
            throw new RuntimeException(String.format("%s\u4e0a\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\uff1a%s\uff08\u53cb\u60c5\u63d0\u793a\uff1a\u8bf7\u914d\u7f6ejava\u5b57\u6bb5\u540d\uff0c\u800c\u4e0d\u662f\u6570\u636e\u5e93\u5217\u540d\uff09", clazz.getName(), fieldName));
        }
        return field;
    }

    public static List<Field> sortAllFieldForColumn(Class<?> beanClass) {
        PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
        PropertyConfig.SuperInsertPosition superInsertPosition = autoTableProperties.getSuperInsertPosition();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BeanClassUtil.getColumnFieldList(fieldList, beanClass, false, superInsertPosition == PropertyConfig.SuperInsertPosition.after, autoTableProperties.getStrictExtends());
        ArrayList<Object> sortFieldList = new ArrayList<Object>(Collections.nCopies(fieldList.size(), null));
        ArrayList<Field> unSortFieldList = new ArrayList<Field>();
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        for (Field field : fieldList) {
            AutoColumn autoColumn = autoTableAnnotationFinder.find(field, AutoColumn.class);
            if (autoColumn != null) {
                int sort = autoColumn.sort();
                Integer index = null;
                if (sort > 0) {
                    index = sort - 1;
                }
                if (sort < 0) {
                    index = fieldList.size() + sort;
                }
                if (index != null) {
                    if (index < 0 || index >= fieldList.size()) {
                        throw new RuntimeException(String.format("%s\u4e0b\u7684\u5b57\u6bb5%s\u7684\u6392\u5e8f\u914d\u7f6e\u9519\u8bef\uff0c\u8303\u56f4\u5728[-%s~%s]\u4e4b\u95f4", beanClass.getName(), field.getName(), fieldList.size(), fieldList.size()));
                    }
                    Field eleField = (Field)sortFieldList.get(index);
                    if (eleField != null) {
                        int existEleSort = autoTableAnnotationFinder.find(eleField, AutoColumn.class).sort();
                        throw new RuntimeException(String.format("%s\u4e0b\u7684\u5b57\u6bb5%s(sort:%s)\u7684\u6392\u5e8f\u914d\u7f6e\u9519\u8bef\uff0c\u6392\u5e8f\u4f4d\u7f6e\u5df2\u7ecf\u88ab%s(sort:%s)\u5360\u7528\u4e86", beanClass.getName(), field.getName(), sort, eleField.getName(), existEleSort));
                    }
                    sortFieldList.set(index, field);
                    continue;
                }
            }
            unSortFieldList.add(field);
        }
        int j = 0;
        for (int i = 0; i < sortFieldList.size(); ++i) {
            if (sortFieldList.get(i) != null) continue;
            sortFieldList.set(i, ((Field)unSortFieldList.get(j++)));
        }
        return sortFieldList;
    }

    private static void getColumnFieldList(List<Field> fields, Class<?> beanClass, boolean isParent, boolean parentInsertBack, boolean strictExtends) {
        Field[] declaredFields = beanClass.getDeclaredFields();
        Set fieldNames = fields.stream().map(Field::getName).collect(Collectors.toSet());
        List newFields = Arrays.stream(declaredFields).filter(field -> !fieldNames.contains(field.getName())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !isParent || !strictExtends || Modifier.isProtected(field.getModifiers()) || Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
        if (parentInsertBack) {
            fields.addAll(newFields);
        } else {
            fields.addAll(0, newFields);
        }
        Class<?> superclass = beanClass.getSuperclass();
        if (superclass != null) {
            BeanClassUtil.getColumnFieldList(fields, superclass, true, parentInsertBack, strictExtends);
        }
    }
}

