/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.builder;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dromara.autotable.annotation.Index;
import org.dromara.autotable.annotation.IndexField;
import org.dromara.autotable.annotation.TableIndex;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.IndexRepeatChecker;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;

public class IndexMetadataBuilder {
    public <T extends IndexMetadata> List<T> buildList(Class<?> clazz, List<Field> fields) {
        IndexRepeatChecker indexRepeatChecker = IndexRepeatChecker.of();
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>(16);
        List<IndexMetadata> onClassIndexMetadata = this.buildFromClass(clazz, indexRepeatChecker);
        indexMetadataList.addAll(onClassIndexMetadata);
        List<IndexMetadata> onFieldIndexMetadata = this.buildFromField(clazz, fields, indexRepeatChecker);
        indexMetadataList.addAll(onFieldIndexMetadata);
        return indexMetadataList;
    }

    protected List<IndexMetadata> buildFromField(Class<?> clazz, List<Field> fields, IndexRepeatChecker indexRepeatChecker) {
        return fields.stream().filter(field -> TableMetadataHandler.isIncludeField(field, clazz)).map(field -> this.buildIndexMetadata(clazz, (Field)field)).filter(Objects::nonNull).peek(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
    }

    protected List<IndexMetadata> buildFromClass(Class<?> clazz, IndexRepeatChecker indexRepeatChecker) {
        List<TableIndex> tableIndexes = TableMetadataHandler.getTableIndexes(clazz);
        return tableIndexes.stream().map(tableIndex -> this.buildIndexMetadata(clazz, (TableIndex)tableIndex)).filter(Objects::nonNull).peek(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
    }

    protected IndexMetadata buildIndexMetadata(Class<?> clazz, Field field) {
        Index index = TableMetadataHandler.getIndex(field);
        if (null != index) {
            String realColumnName = TableMetadataHandler.getColumnName(clazz, field);
            IndexMetadata indexMetadata = this.newIndexMetadata();
            String indexName = this.getIndexName(clazz, field, index);
            indexMetadata.setName(indexName);
            indexMetadata.setType(index.type());
            indexMetadata.setMethod(index.method());
            indexMetadata.setComment(index.comment());
            indexMetadata.getColumns().add(IndexMetadata.IndexColumnParam.newInstance(realColumnName, null));
            return indexMetadata;
        }
        return null;
    }

    protected String getIndexName(Class<?> clazz, TableIndex tableIndex) {
        String indexName = tableIndex.name();
        if (StringUtils.hasText(indexName)) {
            return IndexMetadataBuilder.getIndexNameWithPrefix(indexName);
        }
        String filedNames = Stream.concat(Arrays.stream(tableIndex.indexFields()).map(IndexField::field), Arrays.stream(tableIndex.fields())).map(fieldName -> TableMetadataHandler.getColumnName(clazz, fieldName)).collect(Collectors.joining("_"));
        String tableName = TableMetadataHandler.getTableName(clazz);
        return this.getEncryptIndexName(tableName, filedNames);
    }

    protected String getIndexName(Class<?> clazz, Field field, Index index) {
        String indexName = index.name();
        if (StringUtils.hasText(indexName)) {
            return IndexMetadataBuilder.getIndexNameWithPrefix(indexName);
        }
        String realColumnName = TableMetadataHandler.getColumnName(clazz, field);
        String tableName = TableMetadataHandler.getTableName(clazz);
        return this.getEncryptIndexName(tableName, realColumnName);
    }

    private static String getIndexNameWithPrefix(String indexName) {
        String indexPrefix = AutoTableGlobalConfig.instance().getAutoTableProperties().getIndexPrefix();
        String fullIndexName = indexPrefix + indexName;
        return IndexMetadataBuilder.replaceDoubleQuote(fullIndexName);
    }

    protected String getEncryptIndexName(String tableNamePart, String filedNamePart) {
        String prefix = AutoTableGlobalConfig.instance().getAutoTableProperties().getIndexPrefix();
        int maxLength = IStrategy.getCurrentStrategy().indexNameMaxLength();
        if (prefix.length() > maxLength) {
            throw new RuntimeException("\u7d22\u5f15\u540d\u524d\u7f00[" + prefix + "]\u8d85\u51fa\u7d22\u5f15\u540d\u6700\u5927\u957f\u5ea6\uff08" + maxLength + "\uff09\uff0c\u8bf7\u624b\u52a8\u6307\u5b9a\u7d22\u5f15\u540d\u79f0");
        }
        String main = tableNamePart + "_" + filedNamePart;
        String fullIndexName = IndexMetadataBuilder.replaceDoubleQuote(prefix + main);
        if (fullIndexName.length() > maxLength) {
            String md5 = this.generateShortMD5(main);
            if (prefix.length() + md5.length() > maxLength) {
                return prefix + md5.substring(0, maxLength - prefix.length());
            }
            String prePart = fullIndexName.substring(0, maxLength - md5.length() - 1);
            return prePart + "_" + md5;
        }
        return fullIndexName;
    }

    public static String replaceDoubleQuote(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replace("\"", "\"\"");
    }

    private String generateMD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(text.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    private String generateShortMD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(text.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected IndexMetadata buildIndexMetadata(Class<?> clazz, TableIndex tableIndex) {
        if (null != tableIndex && (tableIndex.fields().length > 0 || tableIndex.indexFields().length > 0)) {
            List<IndexMetadata.IndexColumnParam> columnParams = this.getColumnParams(clazz, tableIndex);
            IndexMetadata indexMetadata = this.newIndexMetadata();
            indexMetadata.setName(this.getIndexName(clazz, tableIndex));
            indexMetadata.setType(tableIndex.type());
            indexMetadata.setComment(tableIndex.comment());
            indexMetadata.setColumns(columnParams);
            return indexMetadata;
        }
        return null;
    }

    protected IndexMetadata newIndexMetadata() {
        return new IndexMetadata();
    }

    protected List<IndexMetadata.IndexColumnParam> getColumnParams(Class<?> clazz, TableIndex tableIndex) {
        String[] fields;
        ArrayList<IndexMetadata.IndexColumnParam> columnParams = new ArrayList<IndexMetadata.IndexColumnParam>();
        HashSet exitsColumns = new HashSet();
        IndexField[] sortFields = tableIndex.indexFields();
        if (sortFields.length > 0) {
            columnParams.addAll(Arrays.stream(sortFields).map(sortField -> {
                String realColumnName = TableMetadataHandler.getColumnName(clazz, sortField.field());
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexMetadata.IndexColumnParam.newInstance(realColumnName, sortField.sort());
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if ((fields = tableIndex.fields()).length > 0) {
            columnParams.addAll(Arrays.stream(fields).map(field -> {
                String realColumnName = TableMetadataHandler.getColumnName(clazz, field);
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexMetadata.IndexColumnParam.newInstance(realColumnName, null);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return columnParams;
    }
}

