/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.initdata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import org.apache.commons.dbutils.QueryRunner;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.initdata.InitDataList;
import org.dromara.autotable.core.initdata.InitDataValue;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDataHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitDataHandler.class);

    public static void initDbData() {
        PropertyConfig.InitDataProperties initDataProperties = AutoTableGlobalConfig.instance().getAutoTableProperties().getInitData();
        if (!initDataProperties.isEnable()) {
            return;
        }
        String basePath = InitDataHandler.getBasePath(initDataProperties);
        String defaultInitSqlFile = basePath + "/" + initDataProperties.getDefaultInitFileName() + ".sql";
        InitDataHandler.tryExecuteSqlFile(defaultInitSqlFile);
        String datasourceName = DataSourceManager.getDatasourceName();
        if (StringUtils.hasText(datasourceName)) {
            String datasourceInitSqlFile = basePath + "/" + datasourceName + ".sql";
            InitDataHandler.tryExecuteSqlFile(datasourceInitSqlFile);
            String defaultDatasourceInitSqlFile = basePath + "/" + datasourceName + "/" + initDataProperties.getDefaultInitFileName() + ".sql";
            InitDataHandler.tryExecuteSqlFile(defaultDatasourceInitSqlFile);
        }
    }

    public static void initTableData(TableMetadata tableMetadata) {
        PropertyConfig.InitDataProperties initDataProperties = AutoTableGlobalConfig.instance().getAutoTableProperties().getInitData();
        if (!initDataProperties.isEnable()) {
            return;
        }
        InitDataHandler.initDefaultTableSql(tableMetadata, initDataProperties);
        InitDataHandler.initCustomizeTableSql(tableMetadata);
        InitDataHandler.initEntityTableSql(tableMetadata);
    }

    private static void initEntityTableSql(TableMetadata tableMetadata) {
        Class<?> entityClass = tableMetadata.getEntityClass();
        Method[] declaredMethods = entityClass.getDeclaredMethods();
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder();
        List insertDataList = Arrays.stream(declaredMethods).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getParameterCount() == 0).filter(method -> autoTableAnnotationFinder.exist((Method)method, InitDataList.class)).filter(method -> {
            boolean assignableFromList = method.getReturnType().isAssignableFrom(List.class);
            if (!assignableFromList) {
                return false;
            }
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                return actualTypeArguments.length == 1 && actualTypeArguments[0] == entityClass;
            }
            return false;
        }).map(method -> {
            try {
                method.setAccessible(true);
                return (List)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (!insertDataList.isEmpty()) {
            List<Field> fields = BeanClassUtil.sortAllFieldForColumn(entityClass);
            List rows = insertDataList.stream().map(data -> {
                HashMap map = new HashMap();
                fields.stream().filter(field -> TableMetadataHandler.isIncludeField(field, entityClass)).filter(field -> !TableMetadataHandler.isAutoIncrement(field, entityClass)).forEach(field -> {
                    field.setAccessible(true);
                    String columnName = TableMetadataHandler.getColumnName(entityClass, field);
                    try {
                        Object value = field.get(data);
                        InitDataValue initDataValue = autoTableAnnotationFinder.find((Field)field, InitDataValue.class);
                        if (initDataValue != null) {
                            value = initDataValue.value().newInstance().convert(entityClass, (Field)field, value);
                        }
                        map.put(columnName, value);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                });
                return map;
            }).collect(Collectors.toList());
            ArrayList columns = new ArrayList(((Map)rows.get(0)).keySet());
            StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableMetadata.getTableName()).append(" (").append(String.join((CharSequence)", ", columns)).append(") VALUES (").append(String.join((CharSequence)", ", Collections.nCopies(columns.size(), "?"))).append(")");
            Object[][] params = new Object[rows.size()][columns.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Map row = (Map)rows.get(i);
                for (int j = 0; j < columns.size(); ++j) {
                    params[i][j] = row.get(columns.get(j));
                }
            }
            DataSourceManager.useConnection(conn -> {
                QueryRunner runner = new QueryRunner();
                try {
                    conn.setAutoCommit(false);
                    String sqlStr = sql.toString();
                    int[] results = runner.batch(conn, sqlStr, params);
                    conn.commit();
                    log.info("\u6267\u884c {} \u6210\u529f\u63d2\u5165\u4e86 {} \u884c\u6570\u636e\u3002", (Object)sqlStr, (Object)results.length);
                }
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static void initCustomizeTableSql(TableMetadata tableMetadata) {
        String initSqlFile = TableMetadataHandler.getTableInitSql(tableMetadata.getEntityClass());
        if (StringUtils.hasText(initSqlFile)) {
            String dialect = IStrategy.getCurrentStrategy().databaseDialect();
            initSqlFile = initSqlFile.replace("{dialect}", dialect);
            try {
                String sqlContent = InitDataHandler.loadSqlContent(initSqlFile);
                log.info(">>> \u6267\u884c SQL \u6587\u4ef6\uff1a{}", (Object)initSqlFile);
                InitDataHandler.executeSql(sqlContent);
            }
            catch (IOException e) {
                log.error("\u52a0\u8f7d\u521d\u59cb\u5316SQL\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                log.error("\u6267\u884c SQL \u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)initSqlFile, (Object)e);
            }
        }
    }

    private static void initDefaultTableSql(TableMetadata tableMetadata, PropertyConfig.InitDataProperties initDataProperties) {
        String basePath = InitDataHandler.getBasePath(initDataProperties);
        String datasourceName = DataSourceManager.getDatasourceName();
        String tableNameSqlFile = StringUtils.noText(datasourceName) ? basePath + "/" + tableMetadata.getTableName() + ".sql" : basePath + "/" + datasourceName + "/" + tableMetadata.getTableName() + ".sql";
        InitDataHandler.tryExecuteSqlFile(tableNameSqlFile);
    }

    private static void tryExecuteSqlFile(String sqlFile) {
        try {
            String sqlContent = InitDataHandler.loadSqlContent(sqlFile);
            log.info(">>> \u6267\u884c SQL \u6587\u4ef6\uff1a{}", (Object)sqlFile);
            InitDataHandler.executeSql(sqlContent);
        }
        catch (FileNotFoundException sqlContent) {
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d\u521d\u59cb\u5316SQL\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u6267\u884c SQL \u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)sqlFile, (Object)e);
        }
    }

    private static String loadSqlContent(String path) throws IOException {
        InputStream inputStream;
        if (path.startsWith("classpath:")) {
            String classpathPath = path.substring("classpath:".length());
            inputStream = InitDataHandler.class.getClassLoader().getResourceAsStream(classpathPath);
            if (inputStream == null) {
                throw new FileNotFoundException("\u672a\u627e\u5230 classpath \u4e0b\u7684\u6587\u4ef6\uff1a" + classpathPath);
            }
        } else {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("\u672a\u627e\u5230\u6587\u4ef6\u8def\u5f84\uff1a" + file.getAbsolutePath());
            }
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static void executeSql(String sqlContent) {
        try {
            Statements statements = CCJSqlParserUtil.parseStatements((String)sqlContent);
            QueryRunner runner = new QueryRunner();
            DataSourceManager.useConnection(conn -> {
                try {
                    conn.setAutoCommit(false);
                    int count = 0;
                    for (Statement stmt : statements.getStatements()) {
                        String sql = stmt.toString().trim();
                        if (sql.isEmpty()) continue;
                        log.info(">>> \u6267\u884c\u7b2c {} \u6761 SQL\uff1a\n{}\n", (Object)(++count), (Object)sql);
                        runner.update(conn, sql);
                    }
                    conn.commit();
                    log.info(">>> \u5171\u6267\u884c {} \u6761 SQL\uff0c\u5168\u90e8\u63d0\u4ea4\u6210\u529f\uff01", (Object)count);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBasePath(PropertyConfig.InitDataProperties initDataProperties) {
        String basePath = initDataProperties.getBasePath();
        if (StringUtils.noText(basePath)) {
            throw new RuntimeException("auto-table.init-data.base-path \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (basePath.endsWith("/")) {
            return basePath.substring(0, basePath.length() - 1);
        }
        String dialect = IStrategy.getCurrentStrategy().databaseDialect();
        return basePath.replace("{dialect}", dialect);
    }
}

