/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.solon.integration;

import cn.hutool.core.util.ObjUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableBootstrap;
import org.dromara.autotable.core.AutoTableClassScanner;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.AutoTableMetadataAdapter;
import org.dromara.autotable.core.callback.AutoTableFinishCallback;
import org.dromara.autotable.core.callback.AutoTableReadyCallback;
import org.dromara.autotable.core.callback.CreateTableFinishCallback;
import org.dromara.autotable.core.callback.ModifyTableFinishCallback;
import org.dromara.autotable.core.callback.RunAfterCallback;
import org.dromara.autotable.core.callback.RunBeforeCallback;
import org.dromara.autotable.core.callback.ValidateFinishCallback;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.JavaTypeToDatabaseTypeConverter;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.interceptor.AutoTableAnnotationInterceptor;
import org.dromara.autotable.core.interceptor.BuildTableMetadataInterceptor;
import org.dromara.autotable.core.interceptor.CreateTableInterceptor;
import org.dromara.autotable.core.interceptor.ModifyTableInterceptor;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.solon.adapter.CustomAnnotationFinder;
import org.dromara.autotable.solon.adapter.SolonDataSourceHandler;
import org.dromara.autotable.solon.annotation.EnableAutoTable;
import org.dromara.autotable.solon.properties.AutoTableProperties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;

public class AutoTablePlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        if (context.app().source().getAnnotation(EnableAutoTable.class) == null) {
            return;
        }
        AutoTableProperties autoTableProperties = (AutoTableProperties)context.beanMake(AutoTableProperties.class).get();
        AutoTableGlobalConfig.setAutoTableProperties((PropertyConfig)autoTableProperties.toConfig());
        context.lifecycle(-100, () -> this.resourceLoadFinish(context));
    }

    private void resourceLoadFinish(AppContext context) {
        AutoTableAnnotationFinder annotationFinder = (AutoTableAnnotationFinder)context.getBean(AutoTableAnnotationFinder.class);
        AutoTableGlobalConfig.setAutoTableAnnotationFinder((AutoTableAnnotationFinder)((AutoTableAnnotationFinder)ObjUtil.defaultIfNull((Object)annotationFinder, (Object)new CustomAnnotationFinder())));
        DataSource dataSource = (DataSource)context.getWrap(DataSource.class).get();
        DataSourceManager.setDataSource((DataSource)dataSource);
        if (context.getBean(IDataSourceHandler.class) == null) {
            context.beanMake(SolonDataSourceHandler.class);
        }
        this.getAndSetBean(context, IStrategy.class, AutoTableGlobalConfig::addStrategy);
        this.getAndSetBean(context, AutoTableClassScanner.class, AutoTableGlobalConfig::setAutoTableClassScanner);
        this.getAndSetBean(context, AutoTableMetadataAdapter.class, AutoTableGlobalConfig::setAutoTableMetadataAdapter);
        this.getAndSetBean(context, JavaTypeToDatabaseTypeConverter.class, AutoTableGlobalConfig::setJavaTypeToDatabaseTypeConverter);
        this.getAndSetBean(context, RecordSqlHandler.class, AutoTableGlobalConfig::setCustomRecordSqlHandler);
        this.getAndSetBean(context, IDataSourceHandler.class, AutoTableGlobalConfig::setDatasourceHandler);
        this.getAndSetBeans(context, AutoTableAnnotationInterceptor.class, AutoTableGlobalConfig::setAutoTableAnnotationInterceptors);
        this.getAndSetBeans(context, BuildTableMetadataInterceptor.class, AutoTableGlobalConfig::setBuildTableMetadataInterceptors);
        this.getAndSetBeans(context, CreateTableInterceptor.class, AutoTableGlobalConfig::setCreateTableInterceptors);
        this.getAndSetBeans(context, ModifyTableInterceptor.class, AutoTableGlobalConfig::setModifyTableInterceptors);
        this.getAndSetBeans(context, CreateTableFinishCallback.class, AutoTableGlobalConfig::setCreateTableFinishCallbacks);
        this.getAndSetBeans(context, ModifyTableFinishCallback.class, AutoTableGlobalConfig::setModifyTableFinishCallbacks);
        this.getAndSetBeans(context, RunBeforeCallback.class, AutoTableGlobalConfig::setRunBeforeCallbacks);
        this.getAndSetBeans(context, RunAfterCallback.class, AutoTableGlobalConfig::setRunAfterCallbacks);
        this.getAndSetBeans(context, AutoTableReadyCallback.class, AutoTableGlobalConfig::setAutoTableReadyCallbacks);
        this.getAndSetBeans(context, ValidateFinishCallback.class, AutoTableGlobalConfig::setValidateFinishCallbacks);
        this.getAndSetBeans(context, AutoTableFinishCallback.class, AutoTableGlobalConfig::setAutoTableFinishCallbacks);
        AutoTableBootstrap.start();
    }

    private <C> void getAndSetBean(AppContext context, Class<C> clazz, Consumer<C> consumer) {
        Object bean = context.getBean(clazz);
        if (bean != null) {
            consumer.accept(bean);
        }
    }

    private <C> void getAndSetBeans(AppContext context, Class<C> clazz, Consumer<List<C>> consumer) {
        List beans = context.getBeansOfType(clazz);
        if (!beans.isEmpty()) {
            consumer.accept(beans);
        }
    }
}

