/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.solon.adapter;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.solon.exception.DataSourceNotFoundException;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.data.dynamicds.DynamicDataSource;
import org.noear.solon.data.dynamicds.DynamicDs;
import org.noear.solon.data.dynamicds.DynamicDsKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SolonDataSourceHandler
implements IDataSourceHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolonDataSourceHandler.class);

    public void useDataSource(String dataSourceName) {
        Map dataSourceMap = Solon.context().getBeansMapOfType(DataSource.class);
        DataSource getDataSource = (DataSource)dataSourceMap.get(dataSourceName);
        if (getDataSource != null) {
            if (getDataSource instanceof DynamicDataSource) {
                DataSource defaultTargetDataSource = ((DynamicDataSource)getDataSource).getDefaultTargetDataSource();
                DataSourceManager.setDataSource((DataSource)defaultTargetDataSource);
            } else {
                DataSourceManager.setDataSource((DataSource)getDataSource);
            }
            return;
        }
        List dynamicDataSourceList = dataSourceMap.values().stream().filter(ds -> ds instanceof DynamicDataSource).collect(Collectors.toList());
        Assert.notEmpty(dynamicDataSourceList, () -> new DataSourceNotFoundException("\u672a\u627e\u5230\u6570\u636e\u6e90"));
        if (dynamicDataSourceList.size() != 1) {
            log.warn("\u9879\u76ee\u4e2d\u5b58\u5728\u591a\u4e2a\u52a8\u6001\u6570\u636e\u6e90\uff0c\u4ec5\u4f7f\u7528\u7b2c\u4e00\u4e2a\u52a8\u6001\u6570\u636e\u6e90\u3002");
        }
        DynamicDataSource dynamicDataSource = (DynamicDataSource)dynamicDataSourceList.get(0);
        DataSource dataSource = dynamicDataSource.getDefaultTargetDataSource();
        if (StrUtil.isNotBlank((CharSequence)dataSourceName)) {
            dataSource = dynamicDataSource.getTargetDataSource(dataSourceName);
        }
        DataSourceManager.setDataSource((DataSource)dataSource);
    }

    public void clearDataSource(String dataSourceName) {
        DynamicDsKey.remove();
        DataSourceManager.cleanDataSource();
    }

    @NonNull
    public String getDataSourceName(Class<?> clazz) {
        DynamicDs annotation = clazz.getAnnotation(DynamicDs.class);
        if (annotation != null) {
            return annotation.value();
        }
        String current = DynamicDsKey.current();
        if (StrUtil.isNotBlank((CharSequence)current)) {
            return current;
        }
        BeanWrap beanWrap = Solon.context().getWrap(DataSource.class);
        return beanWrap.name();
    }

    @Generated
    public SolonDataSourceHandler() {
    }
}

