/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.solon.integration;

import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableBootstrap;
import org.dromara.autotable.core.AutoTableClassScanner;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.AutoTableMetadataAdapter;
import org.dromara.autotable.core.callback.AutoTableFinishCallback;
import org.dromara.autotable.core.callback.AutoTableReadyCallback;
import org.dromara.autotable.core.callback.CompareTableFinishCallback;
import org.dromara.autotable.core.callback.CreateDatabaseFinishCallback;
import org.dromara.autotable.core.callback.CreateTableFinishCallback;
import org.dromara.autotable.core.callback.DeleteTableFinishCallback;
import org.dromara.autotable.core.callback.ModifyTableFinishCallback;
import org.dromara.autotable.core.callback.RunAfterCallback;
import org.dromara.autotable.core.callback.RunBeforeCallback;
import org.dromara.autotable.core.callback.ValidateFinishCallback;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.JavaTypeToDatabaseTypeConverter;
import org.dromara.autotable.core.dynamicds.DataSourceInfoExtractor;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.interceptor.AutoTableAnnotationInterceptor;
import org.dromara.autotable.core.interceptor.BuildTableMetadataInterceptor;
import org.dromara.autotable.core.interceptor.CreateTableInterceptor;
import org.dromara.autotable.core.interceptor.ModifyTableInterceptor;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.solon.adapter.CustomAnnotationFinder;
import org.dromara.autotable.solon.adapter.SolonDataSourceHandler;
import org.dromara.autotable.solon.annotation.EnableAutoTable;
import org.dromara.autotable.solon.properties.AutoTablePropertiesRegister;
import org.dromara.autotable.solon.util.AutoTableUtils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;

public class AutoTablePlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        if (context.app().source().getAnnotation(EnableAutoTable.class) == null) {
            return;
        }
        context.beanMake(AutoTablePropertiesRegister.class);
        PropertyConfig autoTableProperties = (PropertyConfig)context.getBean(PropertyConfig.class);
        AutoTableGlobalConfig.instance().setAutoTableProperties(autoTableProperties);
        context.lifecycle(-100, () -> this.resourceLoadFinish(context));
    }

    private void resourceLoadFinish(AppContext context) {
        AutoTableAnnotationFinder annotationFinder = (AutoTableAnnotationFinder)context.getBean(AutoTableAnnotationFinder.class);
        AutoTableGlobalConfig.instance().setAutoTableAnnotationFinder((AutoTableAnnotationFinder)AutoTableUtils.defaultIfNull(annotationFinder, new CustomAnnotationFinder()));
        DataSource dataSource = (DataSource)context.getWrap(DataSource.class).get();
        DataSourceManager.setDataSource((DataSource)dataSource);
        if (context.getBean(IDataSourceHandler.class) == null) {
            context.beanMake(SolonDataSourceHandler.class);
        }
        this.getAndSetBean(context, IStrategy.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).addStrategy(arg_0));
        this.getAndSetBean(context, AutoTableClassScanner.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setAutoTableClassScanner(arg_0));
        this.getAndSetBean(context, AutoTableMetadataAdapter.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setAutoTableMetadataAdapter(arg_0));
        this.getAndSetBean(context, JavaTypeToDatabaseTypeConverter.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setJavaTypeToDatabaseTypeConverter(arg_0));
        this.getAndSetBean(context, RecordSqlHandler.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setCustomRecordSqlHandler(arg_0));
        this.getAndSetBean(context, IDataSourceHandler.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setDatasourceHandler(arg_0));
        this.getAndSetBean(context, DataSourceInfoExtractor.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setDataSourceInfoExtractor(arg_0));
        this.getAndSetBeans(context, AutoTableAnnotationInterceptor.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setAutoTableAnnotationInterceptors(arg_0));
        this.getAndSetBeans(context, BuildTableMetadataInterceptor.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setBuildTableMetadataInterceptors(arg_0));
        this.getAndSetBeans(context, CreateTableInterceptor.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setCreateTableInterceptors(arg_0));
        this.getAndSetBeans(context, ModifyTableInterceptor.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setModifyTableInterceptors(arg_0));
        this.getAndSetBeans(context, CreateDatabaseFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setCreateDatabaseFinishCallbacks(arg_0));
        this.getAndSetBeans(context, CreateTableFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setCreateTableFinishCallbacks(arg_0));
        this.getAndSetBeans(context, ModifyTableFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setModifyTableFinishCallbacks(arg_0));
        this.getAndSetBeans(context, CompareTableFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setCompareTableFinishCallbacks(arg_0));
        this.getAndSetBeans(context, DeleteTableFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setDeleteTableFinishCallbacks(arg_0));
        this.getAndSetBeans(context, RunBeforeCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setRunBeforeCallbacks(arg_0));
        this.getAndSetBeans(context, RunAfterCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setRunAfterCallbacks(arg_0));
        this.getAndSetBeans(context, AutoTableReadyCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setAutoTableReadyCallbacks(arg_0));
        this.getAndSetBeans(context, ValidateFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setValidateFinishCallbacks(arg_0));
        this.getAndSetBeans(context, AutoTableFinishCallback.class, arg_0 -> ((AutoTableGlobalConfig)AutoTableGlobalConfig.instance()).setAutoTableFinishCallbacks(arg_0));
        AutoTableBootstrap.start();
    }

    private <C> void getAndSetBean(AppContext context, Class<C> clazz, Consumer<C> consumer) {
        Object bean = context.getBean(clazz);
        if (bean != null) {
            consumer.accept(bean);
        }
    }

    private <C> void getAndSetBeans(AppContext context, Class<C> clazz, Consumer<List<C>> consumer) {
        List beans = context.getBeansOfType(clazz);
        if (!beans.isEmpty()) {
            consumer.accept(beans);
        }
    }
}

