/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.solon.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.dromara.autotable.core.utils.AnnotationMergeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedElementUtilsPlus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotatedElementUtilsPlus.class);

    public static <ANNO extends Annotation> ANNO getDeepMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass) {
        List<ANNO> allMergedAnnotations = AnnotatedElementUtilsPlus.getAllSynthesizedAnnotations(element, annoClass);
        return (ANNO)AnnotationMergeUtils.merge(annoClass, new HashSet<ANNO>(allMergedAnnotations));
    }

    public static <ANNO extends Annotation> ANNO findDeepMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass) {
        List<ANNO> allMergedAnnotations = AnnotatedElementUtilsPlus.getAllSynthesizedAnnotations(element, annoClass);
        return (ANNO)AnnotationMergeUtils.merge(annoClass, new HashSet<ANNO>(allMergedAnnotations));
    }

    private static <ANNO extends Annotation> List<ANNO> getAllSynthesizedAnnotations(AnnotatedElement element, Class<ANNO> annotationClass) {
        Class<? extends Annotation> containerClass;
        Annotation containerAnnotation;
        Repeatable repeatable;
        if (element == null || annotationClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        ANNO directAnnotation = element.getAnnotation(annotationClass);
        if (directAnnotation != null) {
            annotations.add(directAnnotation);
        }
        if ((repeatable = annotationClass.getAnnotation(Repeatable.class)) != null && (containerAnnotation = element.getAnnotation(containerClass = repeatable.value())) != null) {
            try {
                Object value = containerClass.getMethod("value", new Class[0]).invoke((Object)containerAnnotation, new Object[0]);
                if (value instanceof Annotation[]) {
                    for (Annotation anno : (Annotation[])value) {
                        if (!annotationClass.isInstance(anno)) continue;
                        annotations.add((Annotation)annotationClass.cast(anno));
                    }
                }
            }
            catch (Exception e) {
                log.warn("\u5904\u7406\u91cd\u590d\u6ce8\u89e3\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return annotations;
    }
}

