/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.solon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class AutoTableUtils {
    private AutoTableUtils() {
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, RuntimeException exception) {
        if (collection == null || collection.isEmpty()) {
            throw exception;
        }
        return collection;
    }

    public static boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public static List<Object> arrayToList(Object array) {
        if (array == null) {
            return Collections.emptyList();
        }
        if (array.getClass().isArray()) {
            if (array instanceof Object[]) {
                return Arrays.asList((Object[])array);
            }
            if (array instanceof int[]) {
                return Arrays.stream((int[])array).boxed().collect(Collectors.toList());
            }
            if (array instanceof long[]) {
                return Arrays.stream((long[])array).boxed().collect(Collectors.toList());
            }
            if (array instanceof double[]) {
                return Arrays.stream((double[])array).boxed().collect(Collectors.toList());
            }
            if (array instanceof float[]) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (float f : (float[])array) {
                    result.add(Float.valueOf(f));
                }
                return result;
            }
            if (array instanceof boolean[]) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (boolean b : (boolean[])array) {
                    result.add(b);
                }
                return result;
            }
            if (array instanceof short[]) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (short s : (short[])array) {
                    result.add(s);
                }
                return result;
            }
            if (array instanceof byte[]) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (byte b : (byte[])array) {
                    result.add(b);
                }
                return result;
            }
            if (array instanceof char[]) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (char c : (char[])array) {
                    result.add(Character.valueOf(c));
                }
                return result;
            }
        }
        return Collections.singletonList(array);
    }
}

