/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.springboot;

import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.AutoTableOrmFrameAdapter;
import org.dromara.autotable.core.callback.AutoTableFinishCallback;
import org.dromara.autotable.core.callback.CreateTableFinishCallback;
import org.dromara.autotable.core.callback.ModifyTableFinishCallback;
import org.dromara.autotable.core.callback.RunStateCallback;
import org.dromara.autotable.core.callback.ValidateFinishCallback;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.JavaTypeToDatabaseTypeConverter;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.dynamicds.SqlSessionFactoryManager;
import org.dromara.autotable.core.interceptor.AutoTableAnnotationInterceptor;
import org.dromara.autotable.core.interceptor.BuildTableMetadataInterceptor;
import org.dromara.autotable.core.interceptor.CreateTableInterceptor;
import org.dromara.autotable.core.interceptor.ModifyTableInterceptor;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.springboot.AutoTableImportRegister;
import org.dromara.autotable.springboot.CustomAnnotationFinder;
import org.dromara.autotable.springboot.properties.AutoTableProperties;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;

@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class AutoTableAutoConfig {
    public AutoTableAutoConfig(SqlSessionTemplate sqlSessionTemplate, AutoTableProperties autoTableProperties, ObjectProvider<IStrategy<? extends TableMetadata, ? extends CompareTableInfo, ?>> strategies, ObjectProvider<AutoTableAnnotationFinder> autoTableAnnotationFinder, ObjectProvider<AutoTableOrmFrameAdapter> autoTableOrmFrameAdapter, ObjectProvider<IDataSourceHandler> dynamicDataSourceHandler, ObjectProvider<RecordSqlHandler> recordSqlHandler, ObjectProvider<AutoTableAnnotationInterceptor> autoTableAnnotationInterceptor, ObjectProvider<BuildTableMetadataInterceptor> buildTableMetadataInterceptor, ObjectProvider<CreateTableInterceptor> createTableInterceptor, ObjectProvider<ModifyTableInterceptor> modifyTableInterceptor, ObjectProvider<CreateTableFinishCallback> createTableFinishCallback, ObjectProvider<ModifyTableFinishCallback> modifyTableFinishCallback, ObjectProvider<RunStateCallback> runStateCallback, ObjectProvider<ValidateFinishCallback> validateFinishCallback, ObjectProvider<AutoTableFinishCallback> autoTableFinishCallbacks, ObjectProvider<JavaTypeToDatabaseTypeConverter> javaTypeToDatabaseTypeConverter) {
        SqlSessionFactoryManager.setSqlSessionFactory((SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory());
        PropertyConfig propertiesConfig = autoTableProperties.toConfig();
        if (AutoTableImportRegister.basePackagesFromAnno != null) {
            propertiesConfig.setModelPackage(AutoTableImportRegister.basePackagesFromAnno);
        }
        if (AutoTableImportRegister.classesFromAnno != null) {
            propertiesConfig.setModelClass((Class[])AutoTableImportRegister.classesFromAnno);
        }
        AutoTableGlobalConfig.setAutoTableProperties((PropertyConfig)propertiesConfig);
        AutoTableGlobalConfig.setAutoTableAnnotationFinder((AutoTableAnnotationFinder)((AutoTableAnnotationFinder)autoTableAnnotationFinder.getIfAvailable(CustomAnnotationFinder::new)));
        strategies.stream().forEach(AutoTableGlobalConfig::addStrategy);
        autoTableOrmFrameAdapter.ifAvailable(AutoTableGlobalConfig::setAutoTableOrmFrameAdapter);
        dynamicDataSourceHandler.ifAvailable(AutoTableGlobalConfig::setDatasourceHandler);
        recordSqlHandler.ifAvailable(AutoTableGlobalConfig::setCustomRecordSqlHandler);
        autoTableAnnotationInterceptor.ifAvailable(AutoTableGlobalConfig::setAutoTableAnnotationInterceptor);
        buildTableMetadataInterceptor.ifAvailable(AutoTableGlobalConfig::setBuildTableMetadataInterceptor);
        createTableInterceptor.ifAvailable(AutoTableGlobalConfig::setCreateTableInterceptor);
        modifyTableInterceptor.ifAvailable(AutoTableGlobalConfig::setModifyTableInterceptor);
        createTableFinishCallback.ifAvailable(AutoTableGlobalConfig::setCreateTableFinishCallback);
        modifyTableFinishCallback.ifAvailable(AutoTableGlobalConfig::setModifyTableFinishCallback);
        runStateCallback.ifAvailable(AutoTableGlobalConfig::setRunStateCallback);
        validateFinishCallback.ifAvailable(AutoTableGlobalConfig::setValidateFinishCallback);
        autoTableFinishCallbacks.ifAvailable(AutoTableGlobalConfig::setAutoTableFinishCallback);
        javaTypeToDatabaseTypeConverter.ifAvailable(AutoTableGlobalConfig::setJavaTypeToDatabaseTypeConverter);
    }
}

