/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl != null && jdbcUrl.startsWith("jdbc:dm:") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "DM DBMS"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseBuilder.BuildResult build(String jdbcUrl, String targetUser, String targetPwd, Consumer<Boolean> dbStatusCallback) {
        PropertyConfig.DMConfig dmConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getDm();
        String execUser = StringUtils.hasText((String)dmConfig.getAdminUser()) ? dmConfig.getAdminUser() : targetUser;
        String execPwd = StringUtils.hasText((String)dmConfig.getAdminPassword()) ? dmConfig.getAdminPassword() : targetPwd;
        log.info("\u8fbe\u68a6\u5efa\u5e93\u4f7f\u7528\u8d26\u53f7\uff1a{}", (Object)execUser);
        try (Connection conn = DriverManager.getConnection(jdbcUrl, execUser, execPwd);){
            if (!this.hasCreateUserPrivilege(conn)) {
                log.warn("\u7528\u6237 [{}] \u65e0\u6743\u9650\u521b\u5efa\u7528\u6237\uff0c\u8df3\u8fc7\u8fbe\u68a6\u5efa\u5e93", (Object)execUser);
                DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
                return buildResult;
            }
            boolean userExists = this.userExists(conn, targetUser);
            dbStatusCallback.accept(userExists);
            if (!userExists) {
                DatabaseBuilder.BuildResult buildResult = this.createUser(conn, targetUser, targetPwd);
                return buildResult;
            }
            log.info("\u8fbe\u68a6\u7528\u6237\u5df2\u5b58\u5728\uff1a{}", (Object)targetUser);
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
        }
        catch (SQLException e) {
            log.error("\u8fbe\u68a6\u5efa\u5e93\u5931\u8d25", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
    }

    private boolean hasCreateUserPrivilege(Connection conn) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM USER_SYS_PRIVS WHERE PRIVILEGE = 'CREATE USER'");
            try {
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u5177\u5907 CREATE USER \u6743\u9650", (Throwable)e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    private boolean userExists(Connection conn, String username) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM SYSUSERS WHERE NAME = ?");
            try {
                ps.setString(1, username.toUpperCase());
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error("\u67e5\u8be2\u7528\u6237\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    private DatabaseBuilder.BuildResult createUser(Connection conn, String username, String password) {
        DatabaseBuilder.BuildResult buildResult;
        block8: {
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE USER " + username + " IDENTIFIED BY \"" + password + "\"");
                stmt.executeUpdate("GRANT RESOURCE, PUBLIC TO " + username);
                log.info("\u8fbe\u68a6\u7528\u6237\u521b\u5efa\u6210\u529f\uff1a{}", (Object)username);
                buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)username);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u521b\u5efa\u8fbe\u68a6\u7528\u6237\u5931\u8d25", (Throwable)e);
                    return DatabaseBuilder.BuildResult.of((boolean)false, (String)username);
                }
            }
            stmt.close();
        }
        return buildResult;
    }
}

