/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.Utils;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.strategy.dm.builder.DmCreateTableSqlBuilder;
import org.dromara.autotable.strategy.dm.builder.DmModifyTableSqlBuilder;
import org.dromara.autotable.strategy.dm.builder.DmTableMetadataBuilder;
import org.dromara.autotable.strategy.dm.data.DmCompareTableInfo;
import org.dromara.autotable.strategy.dm.data.DmDefaultTypeEnum;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbColumn;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbIndex;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbPrimary;
import org.dromara.autotable.strategy.dm.mapper.DmTablesMapper;

public class DmStrategy
implements IStrategy<DefaultTableMetadata, DmCompareTableInfo> {
    private final DmTablesMapper mapper = new DmTablesMapper();

    public String databaseDialect() {
        return "DM DBMS";
    }

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, DmDefaultTypeEnum.VARCHAR);
                this.put(Character.class, DmDefaultTypeEnum.CHAR);
                this.put(Character.TYPE, DmDefaultTypeEnum.CHAR);
                this.put(Short.class, DmDefaultTypeEnum.SMALLINT);
                this.put(Short.TYPE, DmDefaultTypeEnum.SMALLINT);
                this.put(Integer.TYPE, DmDefaultTypeEnum.INTEGER);
                this.put(Integer.class, DmDefaultTypeEnum.INTEGER);
                this.put(Long.class, DmDefaultTypeEnum.BIGINT);
                this.put(Long.TYPE, DmDefaultTypeEnum.BIGINT);
                this.put(BigInteger.class, DmDefaultTypeEnum.BIGINT);
                this.put(Boolean.class, DmDefaultTypeEnum.BIT);
                this.put(Boolean.TYPE, DmDefaultTypeEnum.BIT);
                this.put(Float.class, DmDefaultTypeEnum.FLOAT);
                this.put(Float.TYPE, DmDefaultTypeEnum.FLOAT);
                this.put(Double.class, DmDefaultTypeEnum.DOUBLE);
                this.put(Double.TYPE, DmDefaultTypeEnum.DOUBLE);
                this.put(BigDecimal.class, DmDefaultTypeEnum.DECIMAL);
                this.put(java.util.Date.class, DmDefaultTypeEnum.TIMESTAMP);
                this.put(Date.class, DmDefaultTypeEnum.DATE);
                this.put(Timestamp.class, DmDefaultTypeEnum.TIMESTAMP);
                this.put(LocalDateTime.class, DmDefaultTypeEnum.TIMESTAMP);
                this.put(LocalDate.class, DmDefaultTypeEnum.DATE);
                this.put(LocalTime.class, DmDefaultTypeEnum.TIME);
                this.put(Time.class, DmDefaultTypeEnum.TIME);
            }
        };
    }

    public String dropTable(String schema, String tableName) {
        return String.format("DROP TABLE IF EXISTS %s", this.concatWrapName(new String[]{schema, tableName}));
    }

    @NonNull
    public DefaultTableMetadata analyseClass(Class<?> beanClass) {
        return new DmTableMetadataBuilder().build(beanClass);
    }

    public List<String> createTable(DefaultTableMetadata tableMetadata) {
        return DmCreateTableSqlBuilder.buildSql(tableMetadata);
    }

    @NonNull
    public DmCompareTableInfo compareTable(DefaultTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        DmCompareTableInfo compareInfo = new DmCompareTableInfo(tableName, schema);
        this.compareTableInfo(tableMetadata, compareInfo);
        this.compareColumnInfo(tableMetadata, compareInfo);
        this.compareIndexInfo(tableMetadata, compareInfo);
        return compareInfo;
    }

    public boolean checkTableNotExist(String schema, String tableName) {
        return (Boolean)DataSourceManager.useConnection(connection -> {
            try {
                boolean exist = Utils.tableIsExists((Connection)connection, (String)schema, (String)tableName, (String[])new String[]{"TABLE", "PARTITIONED TABLE"}, (boolean)true);
                return !exist;
            }
            catch (SQLException e) {
                throw new RuntimeException("\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\u51fa\u9519", e);
            }
        });
    }

    private void compareTableInfo(DefaultTableMetadata metadata, DmCompareTableInfo compareInfo) {
        String tableComment = this.mapper.selectTableDescription(metadata.getSchema(), metadata.getTableName());
        if (!Objects.equals(tableComment, metadata.getComment())) {
            compareInfo.setComment(metadata.getComment());
        }
    }

    private void compareColumnInfo(DefaultTableMetadata metadata, DmCompareTableInfo compareInfo) {
        String schema = metadata.getSchema();
        String tableName = metadata.getTableName();
        List<DmDbColumn> dbColumns = this.mapper.selectTableColumns(schema, tableName);
        Map columnMap = dbColumns.stream().collect(Collectors.toMap(DmDbColumn::getName, Function.identity()));
        for (ColumnMetadata column : metadata.getColumnMetadataList()) {
            String colName = column.getName();
            DmDbColumn dbColumn = (DmDbColumn)columnMap.remove(colName);
            if (dbColumn == null) {
                compareInfo.addNewColumn(column);
                compareInfo.addColumnComment(colName, column.getComment());
                continue;
            }
            if (!Objects.equals(dbColumn.getComment(), column.getComment())) {
                compareInfo.addColumnComment(colName, column.getComment());
            }
            if (!this.isColumnDefinitionChanged(column, dbColumn)) continue;
            compareInfo.addModifyColumn(column);
        }
        if (AutoTableGlobalConfig.instance().getAutoTableProperties().getAutoDropColumn().booleanValue()) {
            compareInfo.addDropColumns(columnMap.keySet());
        }
        this.handlePrimaryKeyChange(metadata, compareInfo, schema, tableName);
    }

    private boolean isColumnDefinitionChanged(ColumnMetadata newCol, DmDbColumn oldCol) {
        String oldDefault;
        boolean oldNotNull;
        String oldType;
        DatabaseTypeAndLength databaseTypeAndLength = newCol.getType();
        String newType = databaseTypeAndLength.getDefaultFullType().toUpperCase();
        if (!newType.equals(oldType = databaseTypeAndLength.getLength() == null ? oldCol.getType().toUpperCase() : oldCol.getDefaultFullType().toUpperCase())) {
            return true;
        }
        boolean newNotNull = newCol.isNotNull();
        if (newNotNull != (oldNotNull = "N".equals(oldCol.getNullable()))) {
            return true;
        }
        String newDefault = this.getProcessedDefault(newCol);
        return !Objects.equals(newDefault, oldDefault = this.processDbDefault(oldCol.getDefaultValue()));
    }

    private String getProcessedDefault(ColumnMetadata column) {
        if (column.isAutoIncrement()) {
            return null;
        }
        return column.getDefaultValue();
    }

    private String processDbDefault(String dbDefault) {
        if (dbDefault == null) {
            return null;
        }
        if (dbDefault.startsWith("NEXTVAL(")) {
            return dbDefault;
        }
        return dbDefault.replace("'", "");
    }

    private void handlePrimaryKeyChange(DefaultTableMetadata metadata, DmCompareTableInfo compareInfo, String schema, String tableName) {
        Set newPkColumns;
        DmDbPrimary dbPrimary = this.mapper.selectPrimaryKey(schema, tableName);
        HashSet<String> dbPkColumns = dbPrimary != null ? new HashSet<String>(Arrays.asList(dbPrimary.getColumns().split(","))) : Collections.emptySet();
        if (!dbPkColumns.equals(newPkColumns = metadata.getColumnMetadataList().stream().filter(ColumnMetadata::isPrimary).map(ColumnMetadata::getName).collect(Collectors.toSet()))) {
            if (dbPrimary != null) {
                compareInfo.setDropPrimaryKeyName(dbPrimary.getPrimaryName());
            }
            if (!newPkColumns.isEmpty()) {
                compareInfo.addNewPrimary(metadata.getColumnMetadataList().stream().filter(ColumnMetadata::isPrimary).collect(Collectors.toList()));
            }
        }
    }

    private void compareIndexInfo(DefaultTableMetadata metadata, DmCompareTableInfo compareInfo) {
        String schema = metadata.getSchema();
        String tableName = metadata.getTableName();
        List<DmDbIndex> dbIndexes = this.mapper.selectTableIndexes(schema, tableName);
        Map indexMap = dbIndexes.stream().collect(Collectors.toMap(DmDbIndex::getIndexName, Function.identity()));
        for (IndexMetadata newIndex : metadata.getIndexMetadataList()) {
            String indexName = newIndex.getName();
            DmDbIndex dbIndex = (DmDbIndex)indexMap.remove(indexName);
            if (dbIndex == null) {
                compareInfo.addNewIndex(newIndex);
                continue;
            }
            if (!this.isIndexChanged(newIndex, dbIndex)) continue;
            compareInfo.addModifyIndex(newIndex);
        }
        if (AutoTableGlobalConfig.instance().getAutoTableProperties().getAutoDropIndex().booleanValue()) {
            compareInfo.addDropIndexes(indexMap.keySet());
        }
    }

    private boolean isIndexChanged(IndexMetadata newIndex, DmDbIndex oldIndex) {
        if (!newIndex.getType().name().equals(oldIndex.getIndexType())) {
            return true;
        }
        String newColumns = newIndex.getColumns().stream().map(c -> c.getColumn() + (c.getSort() != null ? " " + c.getSort() : "")).collect(Collectors.joining(", "));
        return !newColumns.equals(oldIndex.getColumns());
    }

    public List<String> modifyTable(DmCompareTableInfo compareInfo) {
        return DmModifyTableSqlBuilder.buildSql(compareInfo);
    }
}

