/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.data.DmTypeHelper;

public class DmColumnMetadataBuilder
extends ColumnMetadataBuilder {
    private static final Map<String, String> BOOLEAN_MAPPING = new HashMap<String, String>(){
        {
            this.put("TRUE", "1");
            this.put("FALSE", "0");
            this.put("1", "1");
            this.put("0", "0");
        }
    };
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^(SYSDATE|CURRENT_(DATE|TIMESTAMP)|NEXTVAL\\s*\\(|USER|UID)", 2);

    public DmColumnMetadataBuilder() {
        super("DM DBMS");
    }

    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        if (typeAndLength == null) {
            throw new IllegalArgumentException("typeAndLength\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String defaultValue = super.getDefaultValue(typeAndLength, columnDefault);
        if (!StringUtils.hasText((String)defaultValue)) {
            return defaultValue;
        }
        if (this.isFunctionDefault(defaultValue)) {
            return defaultValue;
        }
        if (DmTypeHelper.isBoolean(typeAndLength)) {
            return this.handleBooleanDefault(defaultValue);
        }
        return this.wrapQuotesIfNeeded(defaultValue, typeAndLength);
    }

    private String handleBooleanDefault(String value) {
        String upperValue = value.toUpperCase();
        return BOOLEAN_MAPPING.getOrDefault(upperValue, value);
    }

    private boolean isFunctionDefault(String value) {
        return FUNCTION_PATTERN.matcher(value.toUpperCase()).find();
    }

    private String wrapQuotesIfNeeded(String value, DatabaseTypeAndLength type) {
        if (DmTypeHelper.isTime(type) && !value.startsWith("'")) {
            return "'" + value.replace("'", "''") + "'";
        }
        return value;
    }
}

