/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.DmStrategy;
import org.dromara.autotable.strategy.dm.builder.ColumnSqlBuilder;

public class DmCreateTableSqlBuilder {
    public static List<String> buildSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String createTableSql = DmCreateTableSqlBuilder.buildCreateTableStatement(tableMetadata);
        List<String> indexSql = DmCreateTableSqlBuilder.buildIndexStatements(schema, tableName, tableMetadata.getIndexMetadataList());
        indexSql.add(0, createTableSql);
        return indexSql;
    }

    private static String buildCreateTableStatement(DefaultTableMetadata metadata) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        for (ColumnMetadata column : metadata.getColumnMetadataList()) {
            String columnSql = ColumnSqlBuilder.buildSql(column);
            columns.add(columnSql);
            if (!column.isPrimary()) continue;
            primaries.add(column.getName());
        }
        if (!primaries.isEmpty()) {
            columns.add("PRIMARY KEY (\"" + String.join((CharSequence)", ", primaries) + "\")");
        }
        return String.format("CREATE TABLE %s (\n  %s\n)", DmStrategy.withSchemaName(metadata.getSchema(), metadata.getTableName()), String.join((CharSequence)",\n  ", columns));
    }

    static List<String> buildIndexStatements(String schema, String tableName, List<IndexMetadata> indexes) {
        return indexes.stream().map(index -> DmCreateTableSqlBuilder.buildIndexStatement(schema, tableName, index)).collect(Collectors.toList());
    }

    private static String buildIndexStatement(String schema, String tableName, IndexMetadata index) {
        return StringConnectHelper.newInstance((String)"CREATE {unique}INDEX {indexName} ON {schemaTable} ({columns})").replace("{unique}", index.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE " : "").replace("{indexName}", index.getName()).replace("{schemaTable}", DmCreateTableSqlBuilder.buildSchemaTableName(schema, tableName)).replace("{columns}", index.getColumns().stream().map(col -> ColumnSqlBuilder.wrapColumnName(col.getColumn()) + (col.getSort() != null ? " " + col.getSort() : "")).collect(Collectors.joining(", "))).toString() + ";";
    }

    private static String buildSchemaTableName(String schema, String tableName) {
        String wrappedTable = ColumnSqlBuilder.wrapColumnName(tableName);
        return StringUtils.hasText((String)schema) ? schema + "." + wrappedTable : wrappedTable;
    }
}

