/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.builder.ColumnSqlBuilder;

public class DmCreateTableSqlBuilder {
    public static List<String> buildSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String createTableSql = DmCreateTableSqlBuilder.buildCreateTableStatement(tableMetadata);
        List<String> indexSql = DmCreateTableSqlBuilder.buildIndexStatements(schema, tableName, tableMetadata.getIndexMetadataList());
        indexSql.add(0, createTableSql);
        List<String> commentSql = DmCreateTableSqlBuilder.buildCommentStatements(tableMetadata);
        indexSql.addAll(commentSql);
        return indexSql;
    }

    private static String buildCreateTableStatement(DefaultTableMetadata metadata) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        for (ColumnMetadata column : metadata.getColumnMetadataList()) {
            String columnSql = ColumnSqlBuilder.buildSql(column);
            columns.add(columnSql);
            if (!column.isPrimary()) continue;
            primaries.add(column.getName());
        }
        if (!primaries.isEmpty()) {
            columns.add("PRIMARY KEY (" + IStrategy.customConcatWrapIdentifiers((String)", ", primaries) + ")");
        }
        return String.format("CREATE TABLE %s (\n  %s\n)", IStrategy.concatWrapIdentifiers((String[])new String[]{metadata.getSchema(), metadata.getTableName()}), String.join((CharSequence)",\n  ", columns));
    }

    static List<String> buildIndexStatements(String schema, String tableName, List<IndexMetadata> indexes) {
        return indexes.stream().map(index -> DmCreateTableSqlBuilder.buildIndexStatement(schema, tableName, index)).collect(Collectors.toList());
    }

    private static String buildIndexStatement(String schema, String tableName, IndexMetadata index) {
        return StringConnectHelper.newInstance((String)"CREATE {unique}INDEX {indexName} ON {schemaTable} ({columns})").replace("{unique}", index.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE " : "").replace("{indexName}", index.getName()).replace("{schemaTable}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, tableName})).replace("{columns}", index.getColumns().stream().map(col -> IStrategy.wrapIdentifiers((String)col.getColumn()) + (col.getSort() != null ? " " + col.getSort() : "")).collect(Collectors.joining(", "))).toString() + ";";
    }

    private static List<String> buildCommentStatements(DefaultTableMetadata metadata) {
        ArrayList<String> comments = new ArrayList<String>();
        String qualifiedTableName = IStrategy.concatWrapIdentifiers((String[])new String[]{metadata.getSchema(), metadata.getTableName()});
        if (StringUtils.hasText((String)metadata.getComment())) {
            comments.add("COMMENT ON TABLE " + qualifiedTableName + " IS '" + metadata.getComment().replace("'", "''") + "';");
        }
        for (ColumnMetadata column : metadata.getColumnMetadataList()) {
            if (!StringUtils.hasText((String)column.getComment())) continue;
            comments.add("COMMENT ON COLUMN " + qualifiedTableName + "." + IStrategy.wrapIdentifiers((String)column.getName()) + " IS '" + column.getComment().replace("'", "''") + "';");
        }
        return comments;
    }
}

