/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.mapper;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.utils.DBHelper;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbColumn;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbIndex;
import org.dromara.autotable.strategy.dm.data.dbdata.DmDbPrimary;

public class DmTablesMapper {
    public String selectTableDescription(final String schema, final String tableName) {
        String sql = "SELECT COMMENTS FROM USER_TAB_COMMENTS WHERE TABLE_NAME = ':tableName';";
        return (String)DataSourceManager.useConnection(connection -> (String)DBHelper.queryValue((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }));
    }

    public List<DmDbColumn> selectTableColumns(final String schema, final String tableName) {
        String sql = "SELECT DISTINCT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_LENGTH, c.DATA_PRECISION, c.DATA_SCALE,  \n       c.NULLABLE, c.DATA_DEFAULT, com.COMMENTS  \nFROM ALL_TAB_COLUMNS c  \nLEFT JOIN USER_COL_COMMENTS com ON c.TABLE_NAME = com.TABLE_NAME AND c.COLUMN_NAME = com.COLUMN_NAME  \nWHERE c.TABLE_NAME = ':tableName' \nAND c.OWNER = ':schema';";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, DmDbColumn.class));
    }

    public DmDbPrimary selectPrimaryKey(final String schema, final String tableName) {
        String sql = "SELECT cons.CONSTRAINT_NAME,  \n       LISTAGG(cols.COLUMN_NAME, ',') WITHIN GROUP (ORDER BY cols.POSITION) AS COLUMNS  \nFROM USER_CONSTRAINTS cons  \nJOIN USER_CONS_COLUMNS cols ON cons.CONSTRAINT_NAME = cols.CONSTRAINT_NAME  \nWHERE cons.TABLE_NAME =':tableName'  \n  AND cons.CONSTRAINT_TYPE = 'P'  \nGROUP BY cons.CONSTRAINT_NAME;";
        return (DmDbPrimary)DataSourceManager.useConnection(connection -> (DmDbPrimary)DBHelper.queryObject((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, DmDbPrimary.class));
    }

    public List<DmDbIndex> selectTableIndexes(final String schema, final String tableName) {
        String sql = "SELECT ind.INDEX_NAME,  \n       ind.UNIQUENESS,  \n       LISTAGG(cols.COLUMN_NAME, ',') WITHIN GROUP (ORDER BY cols.COLUMN_POSITION) AS COLUMNS,  \n       ind.INDEX_TYPE  \nFROM USER_INDEXES ind  \nJOIN USER_IND_COLUMNS cols ON ind.INDEX_NAME = cols.INDEX_NAME  \nWHERE ind.TABLE_NAME =':tableName'  \n  AND ind.INDEX_TYPE != 'LOB'  \n  AND ind.INDEX_NAME NOT LIKE 'INDEX%'  \nGROUP BY ind.INDEX_NAME, ind.UNIQUENESS, ind.INDEX_TYPE;";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, DmDbIndex.class));
    }
}

