/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.annotation.doris.DorisDynamicPartition;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisHelper.class);
    private static final MessageDigest md5;
    public static final String ADDED = "added";
    public static final String REMOVED = "removed";

    public static String generateMD5(String text) {
        byte[] hashBytes = md5.digest(text.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static <T, K, V> Map<K, V> toMap(List<T> list, Function<T, K> keyMapping, Function<T, V> valueMapping) {
        return list.stream().collect(Collectors.toMap(keyMapping, valueMapping));
    }

    public static String getIndexName(String indexName, String column, String type) {
        String indexPrefix = AutoTableGlobalConfig.getAutoTableProperties().getIndexPrefix();
        if (StringUtils.hasText((String)indexName)) {
            return indexPrefix + indexName;
        }
        return indexPrefix + column + "_" + type;
    }

    public static String getRollupName(String name, List<String> columns) {
        String rollupPrefix = AutoTableGlobalConfig.getAutoTableProperties().getDoris().getRollupPrefix();
        int maxLength = AutoTableGlobalConfig.getAutoTableProperties().getDoris().getRollupAutoNameMaxLength();
        if (StringUtils.hasText((String)name)) {
            return rollupPrefix + name;
        }
        String joined = String.join((CharSequence)"_", columns);
        String rollupName = rollupPrefix + joined;
        if (rollupName.length() <= maxLength) {
            return rollupName;
        }
        String md5Str = DorisHelper.generateMD5(joined);
        String onePart = rollupName.substring(0, maxLength - md5Str.length());
        return onePart + md5;
    }

    public static Map<String, String> parseProperties(String[] properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : properties) {
            String[] array = line.split("=");
            if (array.length < 2) continue;
            String key = array[0].trim();
            String value = array[1].trim();
            if (key.isEmpty() || value.isEmpty()) continue;
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, String> getDynamicPartitionProperties(DorisDynamicPartition dynamicPartition) {
        if (!dynamicPartition.enable()) {
            return new HashMap<String, String>();
        }
        Function<Method, String> keyMapping = method -> "dynamic_partition." + method.getName();
        Function<Method, String> valueMapping = method -> {
            try {
                return method.invoke((Object)dynamicPartition, new Object[0]).toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
        Map<String, String> properties = Arrays.stream(DorisDynamicPartition.class.getMethods()).filter(it -> it.toString().contains(DorisDynamicPartition.class.getName())).filter(it -> !((String)valueMapping.apply((Method)it)).isEmpty()).collect(Collectors.toMap(keyMapping, valueMapping));
        properties.put("dynamic_partition.time_unit", dynamicPartition.time_unit().getValue());
        return properties;
    }

    public static String toPropertiesSql(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        String joinProperties = properties.keySet().stream().sorted().map(key -> "\"" + key + "\" = \"" + (String)properties.get(key) + "\"").collect(Collectors.joining(", "));
        return "properties(" + joinProperties + ")";
    }

    public static String joinColumns(List<String> columns) {
        return columns.stream().map(it -> "`" + it + "`").collect(Collectors.joining(", "));
    }

    public static String joinValues(List<String> values) {
        return values.stream().map(it -> {
            if ("maxvalue".equalsIgnoreCase((String)it)) {
                return it;
            }
            if ("null".equalsIgnoreCase((String)it)) {
                return it;
            }
            return "\"" + it + "\"";
        }).collect(Collectors.joining(", "));
    }

    public static List<List<String>> subList(List<String> originalList, int subSize) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (int i = 0; i < originalList.size(); i += subSize) {
            int end = Math.min(i + subSize, originalList.size());
            List<String> subList = originalList.subList(i, end);
            result.add(new ArrayList<String>(subList));
        }
        return result;
    }

    public static Map<String, List<String>> compareSqlStatements(String sql1, String sql2) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put(ADDED, new ArrayList());
        result.put(REMOVED, new ArrayList());
        List<String> lines1 = DorisHelper.preprocessSql(sql1);
        List<String> lines2 = DorisHelper.preprocessSql(sql2);
        LinkedHashSet<String> set1 = new LinkedHashSet<String>(lines1);
        LinkedHashSet<String> set2 = new LinkedHashSet<String>(lines2);
        for (String line : set2) {
            if (set1.contains(line)) continue;
            ((List)result.get(ADDED)).add(line);
        }
        for (String line : set1) {
            if (set2.contains(line)) continue;
            ((List)result.get(REMOVED)).add(line);
        }
        return result;
    }

    private static List<String> preprocessSql(String sql) {
        if (sql == null || sql.isEmpty()) {
            return Collections.emptyList();
        }
        sql = sql.replaceAll("/\\*[\\s\\S]*?\\*/", "");
        sql = sql.replaceAll("(--|#)[^\\n]*", "");
        sql = sql.replace("\r\n", "\n").replace("\r", "\n");
        String[] lines = sql.split("\\R");
        return Arrays.stream(lines).map(line -> {
            String processedLine = line.trim();
            processedLine = processedLine.replaceAll("\\s+", " ");
            processedLine = processedLine.toLowerCase();
            return processedLine;
        }).filter(line -> !line.isEmpty()).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        String sqlOld = "-- \u7528\u6237\u8868 Version 1\nCREATE TABLE users (\n  id INT PRIMARY KEY AUTO_INCREMENT, -- \u7528\u6237ID\n  username VARCHAR(50) NOT NULL UNIQUE, /* \u7528\u6237\u540d */\n  password VARCHAR(100) NOT NULL, # \u5bc6\u7801\n  email VARCHAR(100),\n  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n);\n\nINSERT INTO config (key, value) VALUES ('timeout', '30'); -- Set timeout";
        String sqlNew = "-- \u7528\u6237\u8868 Version 2\nCREATE TABLE users (\n  id INT PRIMARY KEY AUTO_INCREMENT, -- \u7528\u6237\u552f\u4e00\u6807\u8bc6\n  username VARCHAR( 50 ) NOT NULL UNIQUE, -- \u7528\u6237\u540d,\u4e0d\u5141\u8bb8\u91cd\u590d\n  password VARCHAR(255) NOT NULL, -- \u5bc6\u7801 (\u589e\u5f3a)\n  phone    VARCHAR(20), -- \u65b0\u589e\u624b\u673a\u53f7\n  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n  updated_at TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP -- \u66f4\u65b0\u65f6\u95f4\n);\nINSERT INTO config (key, value) VALUES ('timeout', '60'); -- Increase timeout\n-- New index\nCREATE INDEX idx_phone ON users(phone);";
        Map<String, List<String>> diff = DorisHelper.compareSqlStatements(sqlOld, sqlNew);
        System.out.println("--- SQL \u5dee\u5f02\u5bf9\u6bd4 ---");
        System.out.println("\n\u3010\u65b0\u589e\u7684\u884c\u3011:");
        if (diff.get(ADDED).isEmpty()) {
            System.out.println("(\u65e0)");
        } else {
            diff.get(ADDED).forEach(line -> System.out.println("+ " + line));
        }
        System.out.println("\n\u3010\u5220\u9664\u7684\u884c\u3011:");
        if (diff.get(REMOVED).isEmpty()) {
            System.out.println("(\u65e0)");
        } else {
            diff.get(REMOVED).forEach(line -> System.out.println("- " + line));
        }
        System.out.println("\n--- \u5bf9\u6bd4\u8bf4\u660e ---");
        System.out.println("* \u5bf9\u6bd4\u57fa\u4e8e\u6587\u672c\u884c\uff0c\u5df2\u8fdb\u884c\u6807\u51c6\u5316\u5904\u7406\uff08\u53bb\u6ce8\u91ca\u3001\u53bb\u591a\u4f59\u7a7a\u683c\u3001\u8f6c\u5c0f\u5199\uff09\u3002");
        System.out.println("* '\u4fee\u6539'\u7684\u884c\u4f1a\u8868\u73b0\u4e3a\u5bf9\u5e94\u884c\u7684\u5220\u9664\u548c\u6dfb\u52a0\u3002\u4f8b\u5982\uff0c`password varchar(100)` \u5220\u9664\uff0c`password varchar(255)` \u6dfb\u52a0\u3002");
        System.out.println("* \u7531\u4e8e\u8f6c\u6362\u4e3a\u5c0f\u5199\uff0c\u5bf9\u6bd4\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff0c\u4f46\u8fd9\u53ef\u80fd\u5f71\u54cdSQL\u4e2d\u7684\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u6bd4\u8f83\u3002");
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

