/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.data;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.doris.data.dbdata.InformationSchemaColumn;

public class DorisCompareTableInfo
extends CompareTableInfo {
    private Long tableDataLength;
    private String createTableSql;
    private List<InformationSchemaColumn> columns;
    private TempTableInfo tempTableInfo;
    private List<String> added;
    private List<String> modified;
    private List<String> removed;

    public DorisCompareTableInfo(@NonNull String name, @NonNull String schema) {
        super(name, schema);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
    }

    public boolean needModify() {
        return !this.createTableSql.equals(this.tempTableInfo.getCreateTableSql());
    }

    public String validateFailedMessage() {
        StringBuilder errorMsg = new StringBuilder();
        for (String line : this.added) {
            errorMsg.append("\u8868\u914d\u7f6e\u65b0\u589e\uff1a").append(line).append("\n");
        }
        for (String line : this.modified) {
            errorMsg.append("\u8868\u914d\u7f6e\u4fee\u6539\uff1a").append(line).append("\n");
        }
        for (String line : this.removed) {
            errorMsg.append("\u8868\u914d\u7f6e\u5220\u9664\uff1a").append(line).append("\n");
        }
        return errorMsg.toString();
    }

    @Generated
    public Long getTableDataLength() {
        return this.tableDataLength;
    }

    @Generated
    public String getCreateTableSql() {
        return this.createTableSql;
    }

    @Generated
    public List<InformationSchemaColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public TempTableInfo getTempTableInfo() {
        return this.tempTableInfo;
    }

    @Generated
    public List<String> getAdded() {
        return this.added;
    }

    @Generated
    public List<String> getModified() {
        return this.modified;
    }

    @Generated
    public List<String> getRemoved() {
        return this.removed;
    }

    @Generated
    public void setTableDataLength(Long tableDataLength) {
        this.tableDataLength = tableDataLength;
    }

    @Generated
    public void setCreateTableSql(String createTableSql) {
        this.createTableSql = createTableSql;
    }

    @Generated
    public void setColumns(List<InformationSchemaColumn> columns) {
        this.columns = columns;
    }

    @Generated
    public void setTempTableInfo(TempTableInfo tempTableInfo) {
        this.tempTableInfo = tempTableInfo;
    }

    @Generated
    public void setAdded(List<String> added) {
        this.added = added;
    }

    @Generated
    public void setModified(List<String> modified) {
        this.modified = modified;
    }

    @Generated
    public void setRemoved(List<String> removed) {
        this.removed = removed;
    }

    public static class TempTableInfo {
        private String createTableSql;
        private List<InformationSchemaColumn> columns;

        @Generated
        public String getCreateTableSql() {
            return this.createTableSql;
        }

        @Generated
        public List<InformationSchemaColumn> getColumns() {
            return this.columns;
        }

        @Generated
        public void setCreateTableSql(String createTableSql) {
            this.createTableSql = createTableSql;
        }

        @Generated
        public void setColumns(List<InformationSchemaColumn> columns) {
            this.columns = columns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TempTableInfo)) {
                return false;
            }
            TempTableInfo other = (TempTableInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$createTableSql = this.getCreateTableSql();
            String other$createTableSql = other.getCreateTableSql();
            if (this$createTableSql == null ? other$createTableSql != null : !this$createTableSql.equals(other$createTableSql)) {
                return false;
            }
            List<InformationSchemaColumn> this$columns = this.getColumns();
            List<InformationSchemaColumn> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TempTableInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $createTableSql = this.getCreateTableSql();
            result = result * 59 + ($createTableSql == null ? 43 : $createTableSql.hashCode());
            List<InformationSchemaColumn> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DorisCompareTableInfo.TempTableInfo(createTableSql=" + this.getCreateTableSql() + ", columns=" + this.getColumns() + ")";
        }

        @Generated
        public TempTableInfo(String createTableSql, List<InformationSchemaColumn> columns) {
            this.createTableSql = createTableSql;
            this.columns = columns;
        }
    }
}

