/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.builder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.dromara.autotable.annotation.doris.DorisColumn;
import org.dromara.autotable.annotation.doris.DorisTable;
import org.dromara.autotable.annotation.doris.emuns.AggregateFun;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.doris.DorisHelper;
import org.dromara.autotable.core.strategy.doris.data.DorisColumnMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisIndexMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisPartitionMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisRollupMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisTableMetadata;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisMetadataBuilder.class);
    private static final ColumnMetadataBuilder defaultColumnMetadataBuilder = new ColumnMetadataBuilder("Doris");

    public static DorisTableMetadata buildTableMetadata(Class<?> clazz) {
        String tableName = TableMetadataHandler.getTableName(clazz);
        String tableComment = TableMetadataHandler.getTableComment(clazz);
        DorisTable dorisTable = (DorisTable)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(clazz, DorisTable.class);
        if (dorisTable == null) {
            throw new IllegalStateException(clazz.getSimpleName() + "\u7f3a\u5c11@" + DorisTable.class.getSimpleName());
        }
        List fields = BeanClassUtil.sortAllFieldForColumn(clazz);
        AtomicInteger fieldIndex = new AtomicInteger(1);
        List<DorisColumnMetadata> columnMetadataList = fields.stream().filter(field -> TableMetadataHandler.isIncludeField((Field)field, (Class)clazz)).map(field -> {
            int position = fieldIndex.getAndIncrement();
            ColumnMetadata delegation = defaultColumnMetadataBuilder.build(clazz, field, position);
            DorisColumnMetadata columnMetadata = new DorisColumnMetadata(delegation);
            columnMetadata.setFieldName(field.getName());
            columnMetadata.setPosition(position);
            DorisColumn dorisColumn = (DorisColumn)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, DorisColumn.class);
            if (dorisColumn == null) {
                return columnMetadata;
            }
            AggregateFun aggregateFun = dorisColumn.aggregateFun();
            if (!aggregateFun.equals((Object)AggregateFun.none)) {
                columnMetadata.setAggregateFun(aggregateFun.name());
            }
            if (dorisColumn.autoIncrementStartValue() > 0L) {
                columnMetadata.setAutoIncrement(true);
                columnMetadata.setAutoIncrementStartValue(dorisColumn.autoIncrementStartValue());
            }
            columnMetadata.setOnUpdateCurrentTimestamp(dorisColumn.onUpdateCurrentTimestamp());
            return columnMetadata;
        }).sorted(Comparator.comparingInt(DorisColumnMetadata::getPosition)).collect(Collectors.toList());
        if (columnMetadataList.isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u6ce8\u610f\uff01", (Object)clazz.getName());
        }
        Map<String, String> field2Column = DorisHelper.toMap(columnMetadataList, DorisColumnMetadata::getFieldName, ColumnMetadata::getName);
        List<DorisIndexMetadata> indexMetadataList = Arrays.stream(dorisTable.indexes()).map(dorisIndex -> {
            String column = field2Column.getOrDefault(dorisIndex.column(), dorisIndex.column());
            String type = dorisIndex.using().name();
            String name = DorisHelper.getIndexName(dorisIndex.name(), column, type);
            Map<String, String> properties = DorisHelper.parseProperties(dorisIndex.properties());
            DorisIndexMetadata indexMetadata = new DorisIndexMetadata();
            indexMetadata.setName(name);
            indexMetadata.setColumn(column);
            indexMetadata.setType(type);
            indexMetadata.setProperties(properties);
            indexMetadata.setComment(dorisIndex.comment());
            return indexMetadata;
        }).collect(Collectors.toList());
        long keysCount = Stream.of(dorisTable.duplicate_key(), dorisTable.unique_key(), dorisTable.aggregate_key()).filter(it -> ((String[])it).length > 0).count();
        if (keysCount > 1L) {
            throw new IllegalStateException("@" + DorisTable.class.getSimpleName() + "\u53ea\u80fd\u914d\u7f6eduplicate_key/unique_key/aggregate_key\u5176\u4e2d\u4e00\u4e2a");
        }
        String keysType = null;
        List<Object> keys = new ArrayList();
        if (dorisTable.duplicate_key().length > 0) {
            keysType = "duplicate key";
            keys = Arrays.stream(dorisTable.duplicate_key()).map(key -> field2Column.getOrDefault(key, (String)key)).collect(Collectors.toList());
        }
        if (dorisTable.unique_key().length > 0) {
            keysType = "unique key";
            keys = Arrays.stream(dorisTable.unique_key()).map(key -> field2Column.getOrDefault(key, (String)key)).collect(Collectors.toList());
        }
        if (dorisTable.aggregate_key().length > 0) {
            keysType = "aggregate key";
            keys = Arrays.stream(dorisTable.aggregate_key()).map(key -> field2Column.getOrDefault(key, (String)key)).collect(Collectors.toList());
        }
        if (keys.isEmpty()) {
            keysType = "unique key";
            keys = columnMetadataList.stream().filter(ColumnMetadata::isPrimary).map(ColumnMetadata::getName).collect(Collectors.toList());
        }
        if (keys.isEmpty()) {
            throw new IllegalStateException("@" + DorisTable.class.getSimpleName() + "\u5fc5\u987b\u914d\u7f6eduplicate_key/unique_key/aggregate_key\u5176\u4e2d\u4e00\u4e2a,\u6216\u8005\u914d\u7f6e\u81f3\u5c11\u4e00\u4e2a\u4e3b\u952e");
        }
        for (DorisColumnMetadata columnMetadata : columnMetadataList) {
            columnMetadata.setKey(keys.contains(columnMetadata.getName()));
        }
        if (dorisTable.partition_by_range().length > 0 && dorisTable.partition_by_list().length > 0) {
            throw new IllegalStateException("@" + DorisTable.class.getSimpleName() + "\u53ea\u80fd\u914d\u7f6epartition_by_range/partition_by_list\u5176\u4e2d\u4e00\u4e2a");
        }
        String partitionBy = "";
        ArrayList<String> partitionColumns = new ArrayList();
        if (dorisTable.partition_by_range().length > 0) {
            partitionBy = "range";
            partitionColumns = Arrays.stream(dorisTable.partition_by_range()).map(it -> field2Column.getOrDefault(it, (String)it)).collect(Collectors.toList());
        }
        if (dorisTable.partition_by_list().length > 0) {
            partitionBy = "list";
            partitionColumns = Arrays.stream(dorisTable.partition_by_list()).map(it -> field2Column.getOrDefault(it, (String)it)).collect(Collectors.toList());
        }
        int partitionColumnsSize = partitionColumns.size();
        AtomicInteger partitionIndex = new AtomicInteger(1);
        List<DorisPartitionMetadata.Partition> partitions = Arrays.stream(dorisTable.partitions()).map(dorisPartition -> {
            int position = partitionIndex.getAndIncrement();
            DorisPartitionMetadata.Partition partition = DorisPartitionMetadata.Partition.builder().position(position).columnSize(partitionColumnsSize).name(dorisPartition.partition()).valuesLeftInclude(Arrays.asList(dorisPartition.values_left_include())).valuesRightExclude(Arrays.asList(dorisPartition.values_right_exclude())).valuesLessThan(Arrays.asList(dorisPartition.values_less_than())).from(dorisPartition.from()).to(dorisPartition.to()).interval(dorisPartition.interval()).unit(dorisPartition.unit().getValue()).valuesIn(Arrays.asList(dorisPartition.values_in())).build();
            if (partition.getFrom().isEmpty() && partition.getName().isEmpty()) {
                partition.setName("p" + position);
            }
            return partition;
        }).collect(Collectors.toList());
        Map<String, String> dynamicPartitionProperties = DorisHelper.getDynamicPartitionProperties(dorisTable.dynamic_partition());
        DorisPartitionMetadata partitionMetadata = DorisPartitionMetadata.builder().autoPartition(dorisTable.auto_partition()).autoPartitionTimeUnit(dorisTable.auto_partition_time_unit().name()).partitionBy(partitionBy).partitionColumns(partitionColumns).partitions(partitions).dynamicPartitionProperties(dynamicPartitionProperties).build();
        String distributedBy = dorisTable.distributed_by_hash().length > 0 ? "hash" : "random";
        List<String> distributedColumns = Arrays.stream(dorisTable.distributed_by_hash()).map(it -> field2Column.getOrDefault(it, (String)it)).collect(Collectors.toList());
        String distributedBuckets = dorisTable.distributed_buckets() > 0 ? String.valueOf(dorisTable.distributed_buckets()) : "auto";
        List<DorisRollupMetadata> rollupMetadataList = Arrays.stream(dorisTable.rollup()).map(dorisRollup -> {
            List<String> columns = Arrays.stream(dorisRollup.columns()).map(it -> field2Column.getOrDefault(it, (String)it)).collect(Collectors.toList());
            String rollupName = DorisHelper.getRollupName(dorisRollup.name(), columns);
            return DorisRollupMetadata.builder().name(rollupName).columns(columns).properties(DorisHelper.parseProperties(dorisRollup.properties())).build();
        }).collect(Collectors.toList());
        Map<String, String> properties = DorisHelper.parseProperties(dorisTable.properties());
        properties.putAll(dynamicPartitionProperties);
        DorisTableMetadata tableMetadata = new DorisTableMetadata(clazz, tableName, tableComment);
        tableMetadata.setColumnMetadataList(columnMetadataList);
        tableMetadata.setIndexMetadataList(indexMetadataList);
        tableMetadata.setEngine(dorisTable.engine());
        tableMetadata.setKeysType(keysType);
        tableMetadata.setKeys(keys);
        tableMetadata.setPartitionMetadata(partitionMetadata);
        tableMetadata.setDistributedBy(distributedBy);
        tableMetadata.setDistributedColumns(distributedColumns);
        tableMetadata.setDistributedBuckets(distributedBuckets);
        tableMetadata.setRollupMetadataList(rollupMetadataList);
        tableMetadata.setProperties(properties);
        return tableMetadata;
    }
}

