/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.data;

import lombok.Generated;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.doris.DorisTypeHelper;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisColumnMetadata
extends ColumnMetadata {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisColumnMetadata.class);
    private String fieldName;
    private boolean key;
    private Long autoIncrementStartValue;
    private String aggregateFun = "";
    private boolean onUpdateCurrentTimestamp;
    private int position;
    private String newPreColumn;

    public DorisColumnMetadata(ColumnMetadata delegation) {
        this.setName(delegation.getName()).setComment(delegation.getComment()).setType(delegation.getType()).setNotNull(delegation.isNotNull()).setPrimary(delegation.isPrimary()).setAutoIncrement(delegation.isAutoIncrement()).setDefaultValueType(delegation.getDefaultValueType()).setDefaultValue(delegation.getDefaultValue());
    }

    public String toSql() {
        return StringConnectHelper.newInstance((String)"`{column_name}` {column_type} {aggregate_fun} {null} {auto_increment(auto_auto_increment_start_value)} {default_value} {on update current_timestamp} {column_comment}").replace("{column_name}", this.name).replace("{column_type}", DorisTypeHelper.getFullType(this.type)).replace("{aggregate_fun}", this.aggregateFun).replace("{null}", this.notNull ? "not null" : "null").replace("{auto_increment(auto_auto_increment_start_value)}", () -> {
            if (!this.autoIncrement) {
                return "";
            }
            if (this.autoIncrementStartValue == null || this.autoIncrementStartValue <= 0L) {
                return "auto_increment";
            }
            return "auto_increment(" + this.autoIncrementStartValue + ")";
        }).replace("{default_value}", () -> {
            if (DefaultValueEnum.NULL.equals((Object)this.defaultValueType)) {
                return "default null";
            }
            if (DefaultValueEnum.EMPTY_STRING.equals((Object)this.defaultValueType)) {
                return "default \"\"";
            }
            if (DefaultValueEnum.isCustom((DefaultValueEnum)this.defaultValueType) && StringUtils.hasText((String)this.defaultValue)) {
                if ("current_timestamp".equalsIgnoreCase(this.defaultValue)) {
                    return "default current_timestamp";
                }
                return "default \"" + this.defaultValue + "\"";
            }
            return "";
        }).replace("{on update current_timestamp}", () -> {
            if (!this.onUpdateCurrentTimestamp) {
                return "";
            }
            Integer length = this.type.getLength();
            if (length == null) {
                return "on update current_timestamp";
            }
            return "on update current_timestamp(" + length + ")";
        }).replace("{column_comment}", StringUtils.hasText((String)this.comment) ? "comment \"" + this.comment + "\"" : "").replace("{position}", () -> {
            if (StringUtils.hasText((String)this.newPreColumn)) {
                return "after `" + this.newPreColumn + "`";
            }
            if ("".equals(this.newPreColumn)) {
                return "first";
            }
            return "";
        }).toString().trim();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisColumnMetadata)) {
            return false;
        }
        DorisColumnMetadata other = (DorisColumnMetadata)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isKey() != other.isKey()) {
            return false;
        }
        if (this.isOnUpdateCurrentTimestamp() != other.isOnUpdateCurrentTimestamp()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        Long this$autoIncrementStartValue = this.getAutoIncrementStartValue();
        Long other$autoIncrementStartValue = other.getAutoIncrementStartValue();
        if (this$autoIncrementStartValue == null ? other$autoIncrementStartValue != null : !((Object)this$autoIncrementStartValue).equals(other$autoIncrementStartValue)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$aggregateFun = this.getAggregateFun();
        String other$aggregateFun = other.getAggregateFun();
        if (this$aggregateFun == null ? other$aggregateFun != null : !this$aggregateFun.equals(other$aggregateFun)) {
            return false;
        }
        String this$newPreColumn = this.getNewPreColumn();
        String other$newPreColumn = other.getNewPreColumn();
        return !(this$newPreColumn == null ? other$newPreColumn != null : !this$newPreColumn.equals(other$newPreColumn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DorisColumnMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isKey() ? 79 : 97);
        result = result * 59 + (this.isOnUpdateCurrentTimestamp() ? 79 : 97);
        result = result * 59 + this.getPosition();
        Long $autoIncrementStartValue = this.getAutoIncrementStartValue();
        result = result * 59 + ($autoIncrementStartValue == null ? 43 : ((Object)$autoIncrementStartValue).hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $aggregateFun = this.getAggregateFun();
        result = result * 59 + ($aggregateFun == null ? 43 : $aggregateFun.hashCode());
        String $newPreColumn = this.getNewPreColumn();
        result = result * 59 + ($newPreColumn == null ? 43 : $newPreColumn.hashCode());
        return result;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public boolean isKey() {
        return this.key;
    }

    @Generated
    public Long getAutoIncrementStartValue() {
        return this.autoIncrementStartValue;
    }

    @Generated
    public String getAggregateFun() {
        return this.aggregateFun;
    }

    @Generated
    public boolean isOnUpdateCurrentTimestamp() {
        return this.onUpdateCurrentTimestamp;
    }

    @Generated
    public int getPosition() {
        return this.position;
    }

    @Generated
    public String getNewPreColumn() {
        return this.newPreColumn;
    }

    @Generated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Generated
    public void setKey(boolean key) {
        this.key = key;
    }

    @Generated
    public void setAutoIncrementStartValue(Long autoIncrementStartValue) {
        this.autoIncrementStartValue = autoIncrementStartValue;
    }

    @Generated
    public void setAggregateFun(String aggregateFun) {
        this.aggregateFun = aggregateFun;
    }

    @Generated
    public void setOnUpdateCurrentTimestamp(boolean onUpdateCurrentTimestamp) {
        this.onUpdateCurrentTimestamp = onUpdateCurrentTimestamp;
    }

    @Generated
    public void setPosition(int position) {
        this.position = position;
    }

    @Generated
    public void setNewPreColumn(String newPreColumn) {
        this.newPreColumn = newPreColumn;
    }

    @Generated
    public String toString() {
        return "DorisColumnMetadata(fieldName=" + this.getFieldName() + ", key=" + this.isKey() + ", autoIncrementStartValue=" + this.getAutoIncrementStartValue() + ", aggregateFun=" + this.getAggregateFun() + ", onUpdateCurrentTimestamp=" + this.isOnUpdateCurrentTimestamp() + ", position=" + this.getPosition() + ", newPreColumn=" + this.getNewPreColumn() + ")";
    }
}

