/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.data;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.doris.DorisHelper;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisPartitionMetadata {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisPartitionMetadata.class);
    private boolean autoPartition;
    private String autoPartitionTimeUnit;
    private String partitionBy;
    private List<String> partitionColumns;
    private List<Partition> partitions;
    private Map<String, String> dynamicPartitionProperties;

    public CharSequence toSql() {
        if (this.partitionColumns.isEmpty()) {
            return "";
        }
        String columns = DorisHelper.joinColumns(this.partitionColumns);
        if (this.autoPartition) {
            columns = "date_trunc(" + columns + ", '" + this.autoPartitionTimeUnit + "')";
        }
        String partition_definition_list = this.partitions.stream().map(Partition::toSql).collect(Collectors.joining(", "));
        return StringConnectHelper.newInstance((String)"{auto} partition by {partition_By}({columns}) ({partition_definition_list})").replace("{auto}", this.autoPartition ? "auto" : "").replace("{partition_By}", this.partitionBy).replace("{columns}", columns).replace("{partition_definition_list}", partition_definition_list).toString();
    }

    @Generated
    public static DorisPartitionMetadataBuilder builder() {
        return new DorisPartitionMetadataBuilder();
    }

    @Generated
    public boolean isAutoPartition() {
        return this.autoPartition;
    }

    @Generated
    public String getAutoPartitionTimeUnit() {
        return this.autoPartitionTimeUnit;
    }

    @Generated
    public String getPartitionBy() {
        return this.partitionBy;
    }

    @Generated
    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    @Generated
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    @Generated
    public Map<String, String> getDynamicPartitionProperties() {
        return this.dynamicPartitionProperties;
    }

    @Generated
    public void setAutoPartition(boolean autoPartition) {
        this.autoPartition = autoPartition;
    }

    @Generated
    public void setAutoPartitionTimeUnit(String autoPartitionTimeUnit) {
        this.autoPartitionTimeUnit = autoPartitionTimeUnit;
    }

    @Generated
    public void setPartitionBy(String partitionBy) {
        this.partitionBy = partitionBy;
    }

    @Generated
    public void setPartitionColumns(List<String> partitionColumns) {
        this.partitionColumns = partitionColumns;
    }

    @Generated
    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
    }

    @Generated
    public void setDynamicPartitionProperties(Map<String, String> dynamicPartitionProperties) {
        this.dynamicPartitionProperties = dynamicPartitionProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisPartitionMetadata)) {
            return false;
        }
        DorisPartitionMetadata other = (DorisPartitionMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoPartition() != other.isAutoPartition()) {
            return false;
        }
        String this$autoPartitionTimeUnit = this.getAutoPartitionTimeUnit();
        String other$autoPartitionTimeUnit = other.getAutoPartitionTimeUnit();
        if (this$autoPartitionTimeUnit == null ? other$autoPartitionTimeUnit != null : !this$autoPartitionTimeUnit.equals(other$autoPartitionTimeUnit)) {
            return false;
        }
        String this$partitionBy = this.getPartitionBy();
        String other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !this$partitionBy.equals(other$partitionBy)) {
            return false;
        }
        List<String> this$partitionColumns = this.getPartitionColumns();
        List<String> other$partitionColumns = other.getPartitionColumns();
        if (this$partitionColumns == null ? other$partitionColumns != null : !((Object)this$partitionColumns).equals(other$partitionColumns)) {
            return false;
        }
        List<Partition> this$partitions = this.getPartitions();
        List<Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Map<String, String> this$dynamicPartitionProperties = this.getDynamicPartitionProperties();
        Map<String, String> other$dynamicPartitionProperties = other.getDynamicPartitionProperties();
        return !(this$dynamicPartitionProperties == null ? other$dynamicPartitionProperties != null : !((Object)this$dynamicPartitionProperties).equals(other$dynamicPartitionProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DorisPartitionMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoPartition() ? 79 : 97);
        String $autoPartitionTimeUnit = this.getAutoPartitionTimeUnit();
        result = result * 59 + ($autoPartitionTimeUnit == null ? 43 : $autoPartitionTimeUnit.hashCode());
        String $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : $partitionBy.hashCode());
        List<String> $partitionColumns = this.getPartitionColumns();
        result = result * 59 + ($partitionColumns == null ? 43 : ((Object)$partitionColumns).hashCode());
        List<Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Map<String, String> $dynamicPartitionProperties = this.getDynamicPartitionProperties();
        result = result * 59 + ($dynamicPartitionProperties == null ? 43 : ((Object)$dynamicPartitionProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DorisPartitionMetadata(autoPartition=" + this.isAutoPartition() + ", autoPartitionTimeUnit=" + this.getAutoPartitionTimeUnit() + ", partitionBy=" + this.getPartitionBy() + ", partitionColumns=" + this.getPartitionColumns() + ", partitions=" + this.getPartitions() + ", dynamicPartitionProperties=" + this.getDynamicPartitionProperties() + ")";
    }

    @Generated
    public DorisPartitionMetadata() {
    }

    @Generated
    public DorisPartitionMetadata(boolean autoPartition, String autoPartitionTimeUnit, String partitionBy, List<String> partitionColumns, List<Partition> partitions, Map<String, String> dynamicPartitionProperties) {
        this.autoPartition = autoPartition;
        this.autoPartitionTimeUnit = autoPartitionTimeUnit;
        this.partitionBy = partitionBy;
        this.partitionColumns = partitionColumns;
        this.partitions = partitions;
        this.dynamicPartitionProperties = dynamicPartitionProperties;
    }

    @Generated
    public static class DorisPartitionMetadataBuilder {
        @Generated
        private boolean autoPartition;
        @Generated
        private String autoPartitionTimeUnit;
        @Generated
        private String partitionBy;
        @Generated
        private List<String> partitionColumns;
        @Generated
        private List<Partition> partitions;
        @Generated
        private Map<String, String> dynamicPartitionProperties;

        @Generated
        DorisPartitionMetadataBuilder() {
        }

        @Generated
        public DorisPartitionMetadataBuilder autoPartition(boolean autoPartition) {
            this.autoPartition = autoPartition;
            return this;
        }

        @Generated
        public DorisPartitionMetadataBuilder autoPartitionTimeUnit(String autoPartitionTimeUnit) {
            this.autoPartitionTimeUnit = autoPartitionTimeUnit;
            return this;
        }

        @Generated
        public DorisPartitionMetadataBuilder partitionBy(String partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        @Generated
        public DorisPartitionMetadataBuilder partitionColumns(List<String> partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        @Generated
        public DorisPartitionMetadataBuilder partitions(List<Partition> partitions) {
            this.partitions = partitions;
            return this;
        }

        @Generated
        public DorisPartitionMetadataBuilder dynamicPartitionProperties(Map<String, String> dynamicPartitionProperties) {
            this.dynamicPartitionProperties = dynamicPartitionProperties;
            return this;
        }

        @Generated
        public DorisPartitionMetadata build() {
            return new DorisPartitionMetadata(this.autoPartition, this.autoPartitionTimeUnit, this.partitionBy, this.partitionColumns, this.partitions, this.dynamicPartitionProperties);
        }

        @Generated
        public String toString() {
            return "DorisPartitionMetadata.DorisPartitionMetadataBuilder(autoPartition=" + this.autoPartition + ", autoPartitionTimeUnit=" + this.autoPartitionTimeUnit + ", partitionBy=" + this.partitionBy + ", partitionColumns=" + this.partitionColumns + ", partitions=" + this.partitions + ", dynamicPartitionProperties=" + this.dynamicPartitionProperties + ")";
        }
    }

    public static class Partition {
        private int position;
        private int columnSize;
        private String name;
        private List<String> valuesLeftInclude;
        private List<String> valuesRightExclude;
        private List<String> valuesLessThan;
        private String from;
        private String to;
        private int interval;
        private String unit;
        private List<String> valuesIn;

        public String toSql() {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.hasText((String)this.name)) {
                builder.append("partition `").append(this.name).append("` ");
            }
            if (!this.valuesLeftInclude.isEmpty() && !this.valuesRightExclude.isEmpty()) {
                builder.append("values [(").append(DorisHelper.joinValues(this.valuesLeftInclude)).append("), (").append(DorisHelper.joinValues(this.valuesRightExclude)).append("))");
            }
            if (!this.valuesLessThan.isEmpty()) {
                builder.append("values less than (").append(DorisHelper.joinValues(this.valuesLessThan)).append(")");
            }
            if (StringUtils.hasText((String)this.from)) {
                builder.append("from (").append(StringUtils.hasText((String)this.unit) ? "\"" : "").append(this.from).append(StringUtils.hasText((String)this.unit) ? "\"" : "").append(") ");
            }
            if (StringUtils.hasText((String)this.to)) {
                builder.append("to (").append(StringUtils.hasText((String)this.unit) ? "\"" : "").append(this.to).append(StringUtils.hasText((String)this.unit) ? "\"" : "").append(") ");
            }
            if (this.interval > 0) {
                builder.append("interval ").append(this.interval).append(" ");
            }
            if (StringUtils.hasText((String)this.unit)) {
                builder.append(this.unit);
            }
            if (!this.valuesIn.isEmpty()) {
                if (this.columnSize == 1) {
                    builder.append("values in (").append(DorisHelper.joinValues(this.valuesIn)).append(")");
                }
                if (this.columnSize > 1) {
                    String values = DorisHelper.subList(this.valuesIn, this.columnSize).stream().filter(it -> it.size() == this.columnSize).map(it -> "(" + DorisHelper.joinValues(it) + ")").collect(Collectors.joining(", "));
                    builder.append("values in (").append(values).append(")");
                }
            }
            return builder.toString();
        }

        @Generated
        public static PartitionBuilder builder() {
            return new PartitionBuilder();
        }

        @Generated
        public int getPosition() {
            return this.position;
        }

        @Generated
        public int getColumnSize() {
            return this.columnSize;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getValuesLeftInclude() {
            return this.valuesLeftInclude;
        }

        @Generated
        public List<String> getValuesRightExclude() {
            return this.valuesRightExclude;
        }

        @Generated
        public List<String> getValuesLessThan() {
            return this.valuesLessThan;
        }

        @Generated
        public String getFrom() {
            return this.from;
        }

        @Generated
        public String getTo() {
            return this.to;
        }

        @Generated
        public int getInterval() {
            return this.interval;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public List<String> getValuesIn() {
            return this.valuesIn;
        }

        @Generated
        public void setPosition(int position) {
            this.position = position;
        }

        @Generated
        public void setColumnSize(int columnSize) {
            this.columnSize = columnSize;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValuesLeftInclude(List<String> valuesLeftInclude) {
            this.valuesLeftInclude = valuesLeftInclude;
        }

        @Generated
        public void setValuesRightExclude(List<String> valuesRightExclude) {
            this.valuesRightExclude = valuesRightExclude;
        }

        @Generated
        public void setValuesLessThan(List<String> valuesLessThan) {
            this.valuesLessThan = valuesLessThan;
        }

        @Generated
        public void setFrom(String from) {
            this.from = from;
        }

        @Generated
        public void setTo(String to) {
            this.to = to;
        }

        @Generated
        public void setInterval(int interval) {
            this.interval = interval;
        }

        @Generated
        public void setUnit(String unit) {
            this.unit = unit;
        }

        @Generated
        public void setValuesIn(List<String> valuesIn) {
            this.valuesIn = valuesIn;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition other = (Partition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPosition() != other.getPosition()) {
                return false;
            }
            if (this.getColumnSize() != other.getColumnSize()) {
                return false;
            }
            if (this.getInterval() != other.getInterval()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$valuesLeftInclude = this.getValuesLeftInclude();
            List<String> other$valuesLeftInclude = other.getValuesLeftInclude();
            if (this$valuesLeftInclude == null ? other$valuesLeftInclude != null : !((Object)this$valuesLeftInclude).equals(other$valuesLeftInclude)) {
                return false;
            }
            List<String> this$valuesRightExclude = this.getValuesRightExclude();
            List<String> other$valuesRightExclude = other.getValuesRightExclude();
            if (this$valuesRightExclude == null ? other$valuesRightExclude != null : !((Object)this$valuesRightExclude).equals(other$valuesRightExclude)) {
                return false;
            }
            List<String> this$valuesLessThan = this.getValuesLessThan();
            List<String> other$valuesLessThan = other.getValuesLessThan();
            if (this$valuesLessThan == null ? other$valuesLessThan != null : !((Object)this$valuesLessThan).equals(other$valuesLessThan)) {
                return false;
            }
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            List<String> this$valuesIn = this.getValuesIn();
            List<String> other$valuesIn = other.getValuesIn();
            return !(this$valuesIn == null ? other$valuesIn != null : !((Object)this$valuesIn).equals(other$valuesIn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Partition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPosition();
            result = result * 59 + this.getColumnSize();
            result = result * 59 + this.getInterval();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $valuesLeftInclude = this.getValuesLeftInclude();
            result = result * 59 + ($valuesLeftInclude == null ? 43 : ((Object)$valuesLeftInclude).hashCode());
            List<String> $valuesRightExclude = this.getValuesRightExclude();
            result = result * 59 + ($valuesRightExclude == null ? 43 : ((Object)$valuesRightExclude).hashCode());
            List<String> $valuesLessThan = this.getValuesLessThan();
            result = result * 59 + ($valuesLessThan == null ? 43 : ((Object)$valuesLessThan).hashCode());
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            List<String> $valuesIn = this.getValuesIn();
            result = result * 59 + ($valuesIn == null ? 43 : ((Object)$valuesIn).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DorisPartitionMetadata.Partition(position=" + this.getPosition() + ", columnSize=" + this.getColumnSize() + ", name=" + this.getName() + ", valuesLeftInclude=" + this.getValuesLeftInclude() + ", valuesRightExclude=" + this.getValuesRightExclude() + ", valuesLessThan=" + this.getValuesLessThan() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", interval=" + this.getInterval() + ", unit=" + this.getUnit() + ", valuesIn=" + this.getValuesIn() + ")";
        }

        @Generated
        public Partition() {
        }

        @Generated
        public Partition(int position, int columnSize, String name, List<String> valuesLeftInclude, List<String> valuesRightExclude, List<String> valuesLessThan, String from, String to, int interval, String unit, List<String> valuesIn) {
            this.position = position;
            this.columnSize = columnSize;
            this.name = name;
            this.valuesLeftInclude = valuesLeftInclude;
            this.valuesRightExclude = valuesRightExclude;
            this.valuesLessThan = valuesLessThan;
            this.from = from;
            this.to = to;
            this.interval = interval;
            this.unit = unit;
            this.valuesIn = valuesIn;
        }

        @Generated
        public static class PartitionBuilder {
            @Generated
            private int position;
            @Generated
            private int columnSize;
            @Generated
            private String name;
            @Generated
            private List<String> valuesLeftInclude;
            @Generated
            private List<String> valuesRightExclude;
            @Generated
            private List<String> valuesLessThan;
            @Generated
            private String from;
            @Generated
            private String to;
            @Generated
            private int interval;
            @Generated
            private String unit;
            @Generated
            private List<String> valuesIn;

            @Generated
            PartitionBuilder() {
            }

            @Generated
            public PartitionBuilder position(int position) {
                this.position = position;
                return this;
            }

            @Generated
            public PartitionBuilder columnSize(int columnSize) {
                this.columnSize = columnSize;
                return this;
            }

            @Generated
            public PartitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public PartitionBuilder valuesLeftInclude(List<String> valuesLeftInclude) {
                this.valuesLeftInclude = valuesLeftInclude;
                return this;
            }

            @Generated
            public PartitionBuilder valuesRightExclude(List<String> valuesRightExclude) {
                this.valuesRightExclude = valuesRightExclude;
                return this;
            }

            @Generated
            public PartitionBuilder valuesLessThan(List<String> valuesLessThan) {
                this.valuesLessThan = valuesLessThan;
                return this;
            }

            @Generated
            public PartitionBuilder from(String from) {
                this.from = from;
                return this;
            }

            @Generated
            public PartitionBuilder to(String to) {
                this.to = to;
                return this;
            }

            @Generated
            public PartitionBuilder interval(int interval) {
                this.interval = interval;
                return this;
            }

            @Generated
            public PartitionBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            @Generated
            public PartitionBuilder valuesIn(List<String> valuesIn) {
                this.valuesIn = valuesIn;
                return this;
            }

            @Generated
            public Partition build() {
                return new Partition(this.position, this.columnSize, this.name, this.valuesLeftInclude, this.valuesRightExclude, this.valuesLessThan, this.from, this.to, this.interval, this.unit, this.valuesIn);
            }

            @Generated
            public String toString() {
                return "DorisPartitionMetadata.Partition.PartitionBuilder(position=" + this.position + ", columnSize=" + this.columnSize + ", name=" + this.name + ", valuesLeftInclude=" + this.valuesLeftInclude + ", valuesRightExclude=" + this.valuesRightExclude + ", valuesLessThan=" + this.valuesLessThan + ", from=" + this.from + ", to=" + this.to + ", interval=" + this.interval + ", unit=" + this.unit + ", valuesIn=" + this.valuesIn + ")";
            }
        }
    }
}

