/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisColumnMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisIndexMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisPartitionMetadata;
import org.dromara.autotable.core.strategy.doris.data.DorisRollupMetadata;

public class DorisTableMetadata
extends TableMetadata {
    private List<DorisColumnMetadata> columnMetadataList = new ArrayList<DorisColumnMetadata>();
    private List<DorisIndexMetadata> indexMetadataList = new ArrayList<DorisIndexMetadata>();
    private String engine;
    private String keysType;
    private List<String> keys;
    private DorisPartitionMetadata partitionMetadata;
    private String distributedBy;
    private List<String> distributedColumns;
    private String distributedBuckets;
    private List<DorisRollupMetadata> rollupMetadataList;
    private Map<String, String> properties = new HashMap<String, String>();

    public DorisTableMetadata(Class<?> entityClass, String tableName, String comment) {
        super(entityClass, tableName, "", comment);
    }

    public String toColumnDefinitionSql() {
        return this.columnMetadataList.stream().map(DorisColumnMetadata::toSql).collect(Collectors.joining(", "));
    }

    public CharSequence toIndexDefinitionSql() {
        if (this.indexMetadataList.isEmpty()) {
            return "";
        }
        return ", " + this.indexMetadataList.stream().map(DorisIndexMetadata::toSql).collect(Collectors.joining(", "));
    }

    public String toRollupDefinitionSql() {
        if (this.rollupMetadataList == null || this.rollupMetadataList.isEmpty()) {
            return "";
        }
        return "rollup (" + this.rollupMetadataList.stream().map(DorisRollupMetadata::toSql).collect(Collectors.joining(", ")) + ")";
    }

    @Generated
    public List<DorisColumnMetadata> getColumnMetadataList() {
        return this.columnMetadataList;
    }

    @Generated
    public List<DorisIndexMetadata> getIndexMetadataList() {
        return this.indexMetadataList;
    }

    @Generated
    public String getEngine() {
        return this.engine;
    }

    @Generated
    public String getKeysType() {
        return this.keysType;
    }

    @Generated
    public List<String> getKeys() {
        return this.keys;
    }

    @Generated
    public DorisPartitionMetadata getPartitionMetadata() {
        return this.partitionMetadata;
    }

    @Generated
    public String getDistributedBy() {
        return this.distributedBy;
    }

    @Generated
    public List<String> getDistributedColumns() {
        return this.distributedColumns;
    }

    @Generated
    public String getDistributedBuckets() {
        return this.distributedBuckets;
    }

    @Generated
    public List<DorisRollupMetadata> getRollupMetadataList() {
        return this.rollupMetadataList;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public DorisTableMetadata setColumnMetadataList(List<DorisColumnMetadata> columnMetadataList) {
        this.columnMetadataList = columnMetadataList;
        return this;
    }

    @Generated
    public DorisTableMetadata setIndexMetadataList(List<DorisIndexMetadata> indexMetadataList) {
        this.indexMetadataList = indexMetadataList;
        return this;
    }

    @Generated
    public DorisTableMetadata setEngine(String engine) {
        this.engine = engine;
        return this;
    }

    @Generated
    public DorisTableMetadata setKeysType(String keysType) {
        this.keysType = keysType;
        return this;
    }

    @Generated
    public DorisTableMetadata setKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    @Generated
    public DorisTableMetadata setPartitionMetadata(DorisPartitionMetadata partitionMetadata) {
        this.partitionMetadata = partitionMetadata;
        return this;
    }

    @Generated
    public DorisTableMetadata setDistributedBy(String distributedBy) {
        this.distributedBy = distributedBy;
        return this;
    }

    @Generated
    public DorisTableMetadata setDistributedColumns(List<String> distributedColumns) {
        this.distributedColumns = distributedColumns;
        return this;
    }

    @Generated
    public DorisTableMetadata setDistributedBuckets(String distributedBuckets) {
        this.distributedBuckets = distributedBuckets;
        return this;
    }

    @Generated
    public DorisTableMetadata setRollupMetadataList(List<DorisRollupMetadata> rollupMetadataList) {
        this.rollupMetadataList = rollupMetadataList;
        return this;
    }

    @Generated
    public DorisTableMetadata setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }
}

