/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.doris.DorisHelper;
import org.dromara.autotable.core.strategy.doris.builder.DorisMetadataBuilder;
import org.dromara.autotable.core.strategy.doris.builder.DorisSqlBuilder;
import org.dromara.autotable.core.strategy.doris.data.DorisCompareTableInfo;
import org.dromara.autotable.core.strategy.doris.data.DorisDefaultTypeEnum;
import org.dromara.autotable.core.strategy.doris.data.DorisTableMetadata;
import org.dromara.autotable.core.strategy.doris.data.dbdata.InformationSchemaColumn;
import org.dromara.autotable.core.strategy.doris.mapper.DorisTablesMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisStrategy
implements IStrategy<DorisTableMetadata, DorisCompareTableInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisStrategy.class);
    public static final String databaseDialect = "Doris";
    private final DorisTablesMapper mapper = new DorisTablesMapper();

    public String databaseDialect() {
        return databaseDialect;
    }

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, DorisDefaultTypeEnum.VARCHAR);
                this.put(Character.class, DorisDefaultTypeEnum.CHAR);
                this.put(Character.TYPE, DorisDefaultTypeEnum.CHAR);
                this.put(BigInteger.class, DorisDefaultTypeEnum.BIGINT);
                this.put(Long.class, DorisDefaultTypeEnum.BIGINT);
                this.put(Long.TYPE, DorisDefaultTypeEnum.BIGINT);
                this.put(Integer.class, DorisDefaultTypeEnum.INT);
                this.put(Integer.TYPE, DorisDefaultTypeEnum.INT);
                this.put(Boolean.class, DorisDefaultTypeEnum.BOOLEAN);
                this.put(Boolean.TYPE, DorisDefaultTypeEnum.BOOLEAN);
                this.put(Float.class, DorisDefaultTypeEnum.FLOAT);
                this.put(Float.TYPE, DorisDefaultTypeEnum.FLOAT);
                this.put(Double.class, DorisDefaultTypeEnum.DOUBLE);
                this.put(Double.TYPE, DorisDefaultTypeEnum.DOUBLE);
                this.put(BigDecimal.class, DorisDefaultTypeEnum.DECIMAL);
                this.put(java.util.Date.class, DorisDefaultTypeEnum.DATETIME);
                this.put(Date.class, DorisDefaultTypeEnum.DATE);
                this.put(Timestamp.class, DorisDefaultTypeEnum.DATETIME);
                this.put(Time.class, DorisDefaultTypeEnum.VARCHAR);
                this.put(LocalDateTime.class, DorisDefaultTypeEnum.DATETIME);
                this.put(LocalDate.class, DorisDefaultTypeEnum.DATE);
                this.put(LocalTime.class, DorisDefaultTypeEnum.VARCHAR);
                this.put(Short.class, DorisDefaultTypeEnum.SMALLINT);
                this.put(Short.TYPE, DorisDefaultTypeEnum.SMALLINT);
            }
        };
    }

    public String dropTable(String schema, String tableName) {
        return String.format("drop table if exists `%s`", tableName);
    }

    @NonNull
    public DorisTableMetadata analyseClass(Class<?> beanClass) {
        return DorisMetadataBuilder.buildTableMetadata(beanClass);
    }

    public List<String> createTable(DorisTableMetadata tableMetadata) {
        String sql = DorisSqlBuilder.buildSql(tableMetadata);
        return Collections.singletonList(sql);
    }

    @NonNull
    public DorisCompareTableInfo compareTable(DorisTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        Long tableDataLength = this.mapper.findTableDataLength(tableName);
        String createTableSql = this.mapper.findTableCreateSql(tableName);
        List<InformationSchemaColumn> columns = this.mapper.findTableEnsembleByTableName(tableName);
        DorisCompareTableInfo.TempTableInfo tempTableInfo = this.loadTempTableInfo(tableMetadata);
        Map<String, List<String>> compareSqlStatements = DorisHelper.compareSqlStatements(createTableSql, tempTableInfo.getCreateTableSql());
        List<String> added = compareSqlStatements.get("added");
        List<String> removed = compareSqlStatements.get("removed");
        ArrayList<String> removed_matched = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        for (String addedLine : added) {
            String matched;
            String regex = "`([^`]+)`";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(addedLine);
            String columnName = matcher.find() ? matcher.group(1) : "";
            if (columnName.isEmpty() || !addedLine.startsWith("`" + columnName + "`") || (matched = removed.stream().filter(line -> line.startsWith("`" + columnName + "`")).findFirst().orElse("")).isEmpty()) continue;
            modified.add(addedLine);
            removed_matched.add(matched);
        }
        added = added.stream().filter(it -> !modified.contains(it)).collect(Collectors.toList());
        removed = removed.stream().filter(it -> !removed_matched.contains(it)).collect(Collectors.toList());
        DorisCompareTableInfo compareTableInfo = new DorisCompareTableInfo(tableName, tableMetadata.getSchema());
        compareTableInfo.setTableDataLength(tableDataLength);
        compareTableInfo.setCreateTableSql(createTableSql);
        compareTableInfo.setColumns(columns);
        compareTableInfo.setTempTableInfo(tempTableInfo);
        compareTableInfo.setAdded(added);
        compareTableInfo.setModified(modified);
        compareTableInfo.setRemoved(removed);
        return compareTableInfo;
    }

    public List<String> modifyTable(DorisCompareTableInfo compareTableInfo) {
        long updateLimitTableDataLength = AutoTableGlobalConfig.instance().getAutoTableProperties().getDoris().getUpdateLimitTableDataLength();
        boolean updateBackupOldTable = AutoTableGlobalConfig.instance().getAutoTableProperties().getDoris().isUpdateBackupOldTable();
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String tableName = compareTableInfo.getName();
        String tempTableName = String.format("%s_temp_%s", tableName, now);
        if (compareTableInfo.getTableDataLength() > updateLimitTableDataLength) {
            log.warn("\u8868{}\u6570\u636e\u91cf{}\u5927\u4e8e\u914d\u7f6e\u7684\u66f4\u65b0\u9608\u503c{}\uff0c\u5c06\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c", new Object[]{tableName, compareTableInfo.getTableDataLength(), updateLimitTableDataLength});
            return new ArrayList<String>();
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String createTempTable = compareTableInfo.getTempTableInfo().getCreateTableSql().replace("`" + tableName + "`", "`" + tempTableName + "`");
        sqlList.add(createTempTable);
        Set newColumns = compareTableInfo.getTempTableInfo().getColumns().stream().map(InformationSchemaColumn::getColumnName).collect(Collectors.toSet());
        List<String> insertColumns = compareTableInfo.getColumns().stream().map(InformationSchemaColumn::getColumnName).filter(newColumns::contains).collect(Collectors.toList());
        String insertSelectSql = String.format("insert into `%s` (%s) select %s from `%s`", tempTableName, DorisHelper.joinColumns(insertColumns), DorisHelper.joinColumns(insertColumns), tableName);
        sqlList.add(insertSelectSql);
        if (updateBackupOldTable) {
            sqlList.add(String.format("alter table `%s` rename `%s_bak_%s` ", tableName, tableName, now));
        } else {
            sqlList.add(String.format("drop table if exists `%s`", tableName));
        }
        sqlList.add(String.format("alter table `%s` rename `%s`", tempTableName, tableName));
        return sqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DorisCompareTableInfo.TempTableInfo loadTempTableInfo(DorisTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        String tempTableName = String.format("%s_temp_%s", tableName, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        String createTempTable = DorisSqlBuilder.buildSql(tableMetadata).replace("`" + tableName + "`", "`" + tempTableName + "`");
        try {
            this.mapper.executeRawSql(createTempTable);
            String showCreateTable = this.mapper.findTableCreateSql(tempTableName);
            String createTempTableSql = showCreateTable.replace("`" + tempTableName + "`", "`" + tableName + "`");
            List<InformationSchemaColumn> columns = this.mapper.findTableEnsembleByTableName(tempTableName);
            DorisCompareTableInfo.TempTableInfo tempTableInfo = new DorisCompareTableInfo.TempTableInfo(createTempTableSql, columns);
            return tempTableInfo;
        }
        finally {
            String dropTable = this.dropTable(schema, tempTableName);
            this.mapper.executeRawSql(dropTable);
        }
    }
}

