/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.doris.builder;

import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.doris.DorisHelper;
import org.dromara.autotable.core.strategy.doris.data.DorisTableMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisSqlBuilder.class);

    public static String buildSql(DorisTableMetadata tableMetadata) {
        String distributedColumns = tableMetadata.getDistributedColumns().stream().map(column -> "`" + column + "`").collect(Collectors.joining(", ", "(", ")")).replace("()", "");
        String distributionDesc = "distributed by " + tableMetadata.getDistributedBy() + distributedColumns + " buckets " + tableMetadata.getDistributedBuckets();
        return "create table `{table_name}` ({column_definition_list}{index_definition_list}) engine={engine_type} {keys_type}({keys}) {table_comment} {partition_info} {distribution_desc} {rollup_list} {properties};".replace("{table_name}", tableMetadata.getTableName()).replace("{column_definition_list}", tableMetadata.toColumnDefinitionSql()).replace("{index_definition_list}", tableMetadata.toIndexDefinitionSql()).replace("{engine_type}", tableMetadata.getEngine()).replace("{keys_type}", tableMetadata.getKeysType()).replace("{keys}", DorisHelper.joinColumns(tableMetadata.getKeys())).replace("{table_comment}", StringUtils.hasText((String)tableMetadata.getComment()) ? "comment \"" + tableMetadata.getComment() + "\"" : "").replace("{partition_info}", tableMetadata.getPartitionMetadata().toSql()).replace("{distribution_desc}", distributionDesc).replace("{rollup_list}", tableMetadata.toRollupDefinitionSql()).replace("{properties}", DorisHelper.toPropertiesSql(tableMetadata.getProperties())).replaceAll(" {5}", " ").replaceAll(" {4}", " ").replaceAll(" {3}", " ").replaceAll(" {2}", " ");
    }
}

