/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.doris;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DorisDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl.contains(":mysql://") && StringUtils.noText((String)dialectOnEntity) && Objects.equals(dialectOnEntity, "Doris");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseBuilder.BuildResult build(String jdbcUrl, String username, String password, Set<Class<?>> entityClasses, Consumer<Boolean> dbStatusCallback) {
        String dbName = this.extractDbName(jdbcUrl);
        String baseUrl = this.removeDbFromUrl(jdbcUrl);
        if (dbName == null || baseUrl == null) {
            log.warn("\u65e0\u6cd5\u89e3\u6790 Doris JDBC URL\uff1a{}", (Object)jdbcUrl);
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
        }
        PropertyConfig.DorisConfig dorisConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getDoris();
        String execUser = StringUtils.hasText((String)dorisConfig.getAdminUser()) ? dorisConfig.getAdminUser() : username;
        String execPwd = StringUtils.hasText((String)dorisConfig.getAdminPassword()) ? dorisConfig.getAdminPassword() : password;
        try (Connection conn = DriverManager.getConnection(baseUrl, execUser, execPwd);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT SCHEMA_NAME FROM information_schema.schemata WHERE SCHEMA_NAME = '" + dbName + "'");){
            boolean exists = rs.next();
            dbStatusCallback.accept(exists);
            if (exists) return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
            String sql = "CREATE DATABASE `" + dbName + "`";
            stmt.executeUpdate(sql);
            log.info("\u6210\u529f\u521b\u5efa Doris \u6570\u636e\u5e93\uff1a{}", (Object)dbName);
            DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)dbName);
            return buildResult;
        }
        catch (SQLException e) {
            log.error("\u521b\u5efa Doris \u6570\u636e\u5e93\u5931\u8d25\uff0c\u8fde\u63a5\u6216\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
    }

    private String extractDbName(String jdbcUrl) {
        Matcher matcher = Pattern.compile("jdbc:mysql://[^/]+/([^?]+)").matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String removeDbFromUrl(String jdbcUrl) {
        int index = jdbcUrl.indexOf("/", "jdbc:mysql://".length());
        if (index != -1) {
            return jdbcUrl.substring(0, index);
        }
        return null;
    }
}

