/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.doris.mapper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.dbutils.QueryRunner;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.utils.DBHelper;
import org.dromara.autotable.strategy.doris.data.dbdata.InformationSchemaColumn;

public class DorisTablesMapper {
    private final QueryRunner queryRunner = new QueryRunner();

    public Long findTableDataLength(String tableName) {
        String sql = "select data_length from information_schema.tables where table_name = ':tableName' and table_schema = (select database())";
        Map<String, String> params = Collections.singletonMap("tableName", tableName);
        FindTableDataLengthDTO dto = (FindTableDataLengthDTO)DataSourceManager.useConnection(connection -> (FindTableDataLengthDTO)DBHelper.queryObject((Connection)connection, (String)sql, (Map)params, FindTableDataLengthDTO.class));
        return dto.getDataLength();
    }

    public String findTableCreateSql(String tableName) {
        String sql = "show create table `:tableName`";
        Map<String, String> params = Collections.singletonMap("tableName", tableName);
        FindTableCreateSqlDTO dto = (FindTableCreateSqlDTO)DataSourceManager.useConnection(connection -> (FindTableCreateSqlDTO)DBHelper.queryObject((Connection)connection, (String)sql, (Map)params, FindTableCreateSqlDTO.class));
        String createTable = dto.getCreateTable();
        if (createTable.contains("AUTO PARTITION BY RANGE date_trunc(")) {
            createTable = createTable.replace("AUTO PARTITION BY RANGE date_trunc(", "AUTO PARTITION BY RANGE (date_trunc(");
            createTable = createTable.replace("')\n()", "'))\n()");
        }
        return createTable;
    }

    public void executeRawSql(String sql) {
        DataSourceManager.useConnection(connection -> {
            try {
                DBHelper.setParameters((String)sql, Collections.emptyMap());
                return this.queryRunner.execute(connection, sql, new Object[0]);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<InformationSchemaColumn> findTableEnsembleByTableName(String tableName) {
        String sql = "select * from information_schema.columns where table_name = ':tableName' and table_schema = (select database()) order by ordinal_position asc";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, Collections.singletonMap("tableName", tableName), InformationSchemaColumn.class));
    }

    public static class FindTableDataLengthDTO {
        @DBHelper.ColumnName(value="DATA_LENGTH")
        private Long dataLength;

        @Generated
        public FindTableDataLengthDTO() {
        }

        @Generated
        public Long getDataLength() {
            return this.dataLength;
        }

        @Generated
        public void setDataLength(Long dataLength) {
            this.dataLength = dataLength;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindTableDataLengthDTO)) {
                return false;
            }
            FindTableDataLengthDTO other = (FindTableDataLengthDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$dataLength = this.getDataLength();
            Long other$dataLength = other.getDataLength();
            return !(this$dataLength == null ? other$dataLength != null : !((Object)this$dataLength).equals(other$dataLength));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FindTableDataLengthDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $dataLength = this.getDataLength();
            result = result * 59 + ($dataLength == null ? 43 : ((Object)$dataLength).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DorisTablesMapper.FindTableDataLengthDTO(dataLength=" + this.getDataLength() + ")";
        }
    }

    public static class FindTableCreateSqlDTO {
        @DBHelper.ColumnName(value="Create Table")
        private String createTable;

        @Generated
        public FindTableCreateSqlDTO() {
        }

        @Generated
        public String getCreateTable() {
            return this.createTable;
        }

        @Generated
        public void setCreateTable(String createTable) {
            this.createTable = createTable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindTableCreateSqlDTO)) {
                return false;
            }
            FindTableCreateSqlDTO other = (FindTableCreateSqlDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$createTable = this.getCreateTable();
            String other$createTable = other.getCreateTable();
            return !(this$createTable == null ? other$createTable != null : !this$createTable.equals(other$createTable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FindTableCreateSqlDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $createTable = this.getCreateTable();
            result = result * 59 + ($createTable == null ? 43 : $createTable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DorisTablesMapper.FindTableCreateSqlDTO(createTable=" + this.getCreateTable() + ")";
        }
    }
}

