/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.h2.mapper;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaColumns;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaIndexes;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaTables;
import org.dromara.autotable.core.utils.DBHelper;

public class H2TablesMapper {
    public InformationSchemaTables findTableInformation(final String tableSchema, final String tableName) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = UPPER(':tableSchema') and TABLE_NAME = UPPER(':tableName');";
        return (InformationSchemaTables)DataSourceManager.useConnection(connection -> (InformationSchemaTables)DBHelper.queryObject((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("tableSchema", tableSchema);
            }
        }, InformationSchemaTables.class));
    }

    public List<InformationSchemaColumns> findColumnInformation(final String tableSchema, final String tableName) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = UPPER(':tableSchema') and TABLE_NAME = UPPER(':tableName');";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("tableSchema", tableSchema);
            }
        }, InformationSchemaColumns.class));
    }

    public List<InformationSchemaIndexes> findIndexInformation(final String tableSchema, final String tableName) {
        String sql = "SELECT IC.*, I.REMARKS FROM INFORMATION_SCHEMA.INDEX_COLUMNS IC LEFT JOIN INFORMATION_SCHEMA.INDEXES I ON I.INDEX_NAME = IC.INDEX_NAME AND IC.TABLE_SCHEMA = I.TABLE_SCHEMA AND IC.TABLE_NAME = I.TABLE_NAME WHERE IC.TABLE_SCHEMA = UPPER(':tableSchema') AND IC.TABLE_NAME = UPPER(':tableName') AND I.INDEX_TYPE_NAME != 'PRIMARY KEY';";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("tableSchema", tableSchema);
            }
        }, InformationSchemaIndexes.class));
    }
}

