/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.kingbase;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KingbaseDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KingbaseDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl != null && jdbcUrl.startsWith("jdbc:kingbase8:") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "KingbaseES"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseBuilder.BuildResult build(String jdbcUrl, String targetUser, String targetPassword, Set<Class<?>> entityClasses, Consumer<Boolean> dbStatusCallback) {
        PropertyConfig.KingbaseConfig kingbaseConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getKingbase();
        String execUser = StringUtils.hasText((String)kingbaseConfig.getAdminUser()) ? kingbaseConfig.getAdminUser() : targetUser;
        String execPwd = StringUtils.hasText((String)kingbaseConfig.getAdminPassword()) ? kingbaseConfig.getAdminPassword() : targetPassword;
        boolean createUser = false;
        try (Connection conn = DriverManager.getConnection(jdbcUrl, execUser, execPwd);){
            if (!this.hasCreateUserPrivilege(conn)) {
                log.warn("\u7528\u6237 [{}] \u65e0\u6743\u9650\u521b\u5efa\u7528\u6237\uff0c\u8df3\u8fc7 Kingbase \u5efa\u5e93", (Object)execUser);
                DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
                return buildResult;
            }
            boolean userExists = this.userExists(conn, targetUser);
            dbStatusCallback.accept(userExists);
            if (!userExists) {
                createUser = this.createUser(conn, targetUser, targetPassword);
            } else {
                log.info("Kingbase \u7528\u6237\u5df2\u5b58\u5728\uff1a{}", (Object)targetUser);
            }
            Set<String> allSchemaNames = KingbaseDatabaseBuilder.findAllSchemaNames(entityClasses, conn);
            if (allSchemaNames.isEmpty()) return DatabaseBuilder.BuildResult.of((boolean)createUser, (String)targetUser);
            this.createSchemasIfAbsent(conn, allSchemaNames);
            return DatabaseBuilder.BuildResult.of((boolean)createUser, (String)targetUser);
        }
        catch (SQLException e) {
            log.error("Kingbase \u5efa\u5e93\u5931\u8d25", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)createUser, (String)targetUser);
    }

    private static Set<String> findAllSchemaNames(Set<Class<?>> entityClasses, Connection conn) {
        Set<String> schemas = entityClasses.stream().map(TableMetadataHandler::getTableName).filter(StringUtils::hasText).collect(Collectors.toSet());
        try {
            String schema = conn.getSchema();
            if (StringUtils.hasText((String)schema)) {
                schemas.add(schema);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return schemas;
    }

    private boolean hasCreateUserPrivilege(Connection conn) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM information_schema.role_table_grants WHERE grantee = CURRENT_USER");
            try {
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u5224\u65ad CREATE USER \u6743\u9650\u5931\u8d25\uff0c\u8df3\u8fc7\u6743\u9650\u6821\u9a8c", (Throwable)e);
                    return true;
                }
            }
            ps.close();
        }
        return bl;
    }

    private boolean userExists(Connection conn, String username) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM pg_roles WHERE rolname = ?");
            try {
                ps.setString(1, username.toLowerCase());
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u5224\u65ad Kingbase \u7528\u6237\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    private boolean createUser(Connection conn, String username, String password) {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE USER \"" + username + "\" WITH PASSWORD '" + password + "'");
            stmt.executeUpdate("GRANT CONNECT ON DATABASE CURRENT_DATABASE() TO \"" + username + "\"");
            stmt.executeUpdate("GRANT ALL PRIVILEGES ON SCHEMA public TO \"" + username + "\"");
            log.info("Kingbase \u7528\u6237\u521b\u5efa\u6210\u529f\uff1a{}", (Object)username);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa Kingbase \u7528\u6237\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    private void createSchemasIfAbsent(Connection conn, Set<String> schemas) {
        for (String schemaName : schemas) {
            try {
                PreparedStatement ps = conn.prepareStatement("SELECT schema_name FROM information_schema.schemata WHERE schema_name = ?");
                try {
                    ps.setString(1, schemaName);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        log.info("PostgreSQL schema [{}] \u5df2\u5b58\u5728\uff0c\u65e0\u9700\u521b\u5efa\u3002", (Object)schemaName);
                        continue;
                    }
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.executeUpdate("CREATE SCHEMA \"" + schemaName + "\"");
                        log.info("\u5df2\u6210\u529f\u521b\u5efa PostgreSQL schema [{}]", (Object)schemaName);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException e) {
                log.error("\u68c0\u67e5\u6216\u521b\u5efa schema [{}] \u65f6\u51fa\u9519", (Object)schemaName, (Object)e);
            }
        }
    }
}

