/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.kingbase;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KingbaseDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KingbaseDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl != null && jdbcUrl.startsWith("jdbc:kingbase8:") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "KingbaseES"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseBuilder.BuildResult build(String jdbcUrl, String targetUser, String targetPassword, Consumer<Boolean> dbStatusCallback) {
        PropertyConfig.KingbaseConfig kingbaseConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getKingbase();
        String execUser = StringUtils.hasText((String)kingbaseConfig.getAdminUser()) ? kingbaseConfig.getAdminUser() : targetUser;
        String execPwd = StringUtils.hasText((String)kingbaseConfig.getAdminPassword()) ? kingbaseConfig.getAdminPassword() : targetPassword;
        try (Connection conn = DriverManager.getConnection(jdbcUrl, execUser, execPwd);){
            if (!this.hasCreateUserPrivilege(conn)) {
                log.warn("\u7528\u6237 [{}] \u65e0\u6743\u9650\u521b\u5efa\u7528\u6237\uff0c\u8df3\u8fc7 Kingbase \u5efa\u5e93", (Object)execUser);
                DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
                return buildResult;
            }
            boolean userExists = this.userExists(conn, targetUser);
            dbStatusCallback.accept(userExists);
            if (!userExists) {
                DatabaseBuilder.BuildResult buildResult = this.createUser(conn, targetUser, targetPassword);
                return buildResult;
            }
            log.info("Kingbase \u7528\u6237\u5df2\u5b58\u5728\uff1a{}", (Object)targetUser);
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
        }
        catch (SQLException e) {
            log.error("Kingbase \u5efa\u5e93\u5931\u8d25", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUser);
    }

    private boolean hasCreateUserPrivilege(Connection conn) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM information_schema.role_table_grants WHERE grantee = CURRENT_USER");
            try {
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u5224\u65ad CREATE USER \u6743\u9650\u5931\u8d25\uff0c\u8df3\u8fc7\u6743\u9650\u6821\u9a8c", (Throwable)e);
                    return true;
                }
            }
            ps.close();
        }
        return bl;
    }

    private boolean userExists(Connection conn, String username) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM pg_roles WHERE rolname = ?");
            try {
                ps.setString(1, username.toLowerCase());
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u5224\u65ad Kingbase \u7528\u6237\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    private DatabaseBuilder.BuildResult createUser(Connection conn, String username, String password) {
        DatabaseBuilder.BuildResult buildResult;
        block8: {
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE USER \"" + username + "\" WITH PASSWORD '" + password + "'");
                stmt.executeUpdate("GRANT CONNECT ON DATABASE CURRENT_DATABASE() TO \"" + username + "\"");
                stmt.executeUpdate("GRANT ALL PRIVILEGES ON SCHEMA public TO \"" + username + "\"");
                log.info("Kingbase \u7528\u6237\u521b\u5efa\u6210\u529f\uff1a{}", (Object)username);
                buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)username);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u521b\u5efa Kingbase \u7528\u6237\u5931\u8d25", (Throwable)e);
                    return DatabaseBuilder.BuildResult.of((boolean)false, (String)username);
                }
            }
            stmt.close();
        }
        return buildResult;
    }
}

