/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.mysql.mapper;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.mysql.data.dbdata.InformationSchemaColumn;
import org.dromara.autotable.core.strategy.mysql.data.dbdata.InformationSchemaStatistics;
import org.dromara.autotable.core.strategy.mysql.data.dbdata.InformationSchemaTable;
import org.dromara.autotable.core.utils.DBHelper;

public class MysqlTablesMapper {
    public InformationSchemaTable findTableByTableName(String tableName) {
        return (InformationSchemaTable)DataSourceManager.useConnection(connection -> {
            String sql = "select * from information_schema.tables where table_name = ':tableName' and table_schema = (select database())";
            return (InformationSchemaTable)DBHelper.queryObject((Connection)connection, (String)sql, Collections.singletonMap("tableName", tableName), InformationSchemaTable.class);
        });
    }

    public List<InformationSchemaColumn> findTableEnsembleByTableName(String tableName) {
        String sql = "select * from information_schema.columns where table_name = ':tableName' and table_schema = (select database()) order by ordinal_position asc";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, Collections.singletonMap("tableName", tableName), InformationSchemaColumn.class));
    }

    public List<InformationSchemaStatistics> queryTablePrimaryAndIndex(String tableName) {
        String sql = "SELECT * FROM information_schema.statistics WHERE table_name = ':tableName' and table_schema = (select database())";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, Collections.singletonMap("tableName", tableName), InformationSchemaStatistics.class));
    }
}

