/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.core.strategy.mysql.data.dbdata.InformationSchemaColumn;

public class ColumnPositionHelper {
    public static void generateChangePosition(List<InformationSchemaColumn> dbColumns, List<MysqlColumnMetadata> expectPositions) {
        List realPositions = dbColumns.stream().map(col -> new InformationSchemaColumnPosition(col.getColumnName(), col.getOrdinalPosition())).collect(Collectors.toList());
        Set entityColumnsSet = expectPositions.stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        ArrayList<InformationSchemaColumnPosition> removeColumns = new ArrayList<InformationSchemaColumnPosition>(realPositions.size());
        for (Object realPosition : realPositions) {
            if (!entityColumnsSet.contains(((InformationSchemaColumnPosition)realPosition).getColumnName())) {
                removeColumns.add((InformationSchemaColumnPosition)realPosition);
                continue;
            }
            if (removeColumns.isEmpty()) continue;
            ((InformationSchemaColumnPosition)realPosition).setOrdinalPosition(((InformationSchemaColumnPosition)realPosition).getOrdinalPosition() - removeColumns.size());
        }
        realPositions.removeAll(removeColumns);
        Set dbColumnsSet = realPositions.stream().map(InformationSchemaColumnPosition::getColumnName).collect(Collectors.toSet());
        for (MysqlColumnMetadata expectPosition : expectPositions) {
            if (dbColumnsSet.contains(expectPosition.getName())) continue;
            realPositions.add(new InformationSchemaColumnPosition(expectPosition.getName(), realPositions.size() + 1));
        }
        Map dbColumnPositionMap = realPositions.stream().collect(Collectors.toMap(InformationSchemaColumnPosition::getColumnName, Function.identity()));
        Map columnMetadataMap = expectPositions.stream().collect(Collectors.toMap(ColumnMetadata::getName, Function.identity()));
        for (int index = 0; index < expectPositions.size(); ++index) {
            String realColumnName;
            String expectColumnName = expectPositions.get(index).getName();
            if (Objects.equals(expectColumnName, realColumnName = ((InformationSchemaColumnPosition)realPositions.get(index)).getColumnName())) continue;
            Integer expectColumnNameRealPosition = ((InformationSchemaColumnPosition)dbColumnPositionMap.get(expectColumnName)).getOrdinalPosition();
            realPositions.remove(expectColumnNameRealPosition - 1);
            realPositions.add(index, new InformationSchemaColumnPosition(expectColumnName, index + 1));
            for (int i = index + 1; i < expectColumnNameRealPosition; ++i) {
                InformationSchemaColumnPosition columnPosition = (InformationSchemaColumnPosition)realPositions.get(i);
                columnPosition.setOrdinalPosition(columnPosition.getOrdinalPosition() + 1);
            }
            if (index == 0) {
                ((MysqlColumnMetadata)((Object)columnMetadataMap.get(expectColumnName))).setNewPreColumn("");
                continue;
            }
            ((MysqlColumnMetadata)((Object)columnMetadataMap.get(expectColumnName))).setNewPreColumn(((InformationSchemaColumnPosition)realPositions.get(index - 1)).getColumnName());
        }
    }

    public static void main(String[] args) {
        List<InformationSchemaColumn> dbColumns = Arrays.asList(ColumnPositionHelper.db(1, "A"), ColumnPositionHelper.db(2, "B"), ColumnPositionHelper.db(3, "C"), ColumnPositionHelper.db(4, "D"), ColumnPositionHelper.db(5, "E"), ColumnPositionHelper.db(6, "H"));
        List<MysqlColumnMetadata> expectPositions = Arrays.asList(ColumnPositionHelper.app(1, "B"), ColumnPositionHelper.app(2, "G"), ColumnPositionHelper.app(3, "F"), ColumnPositionHelper.app(4, "C"), ColumnPositionHelper.app(5, "A"), ColumnPositionHelper.app(6, "E"), ColumnPositionHelper.app(7, "D"));
        ColumnPositionHelper.generateChangePosition(dbColumns, expectPositions);
        for (MysqlColumnMetadata columnMetadata : expectPositions) {
            System.out.println((Object)((Object)columnMetadata) + " - " + columnMetadata.getName());
        }
    }

    private static InformationSchemaColumn db(int index, String name) {
        InformationSchemaColumn informationSchemaColumn = new InformationSchemaColumn();
        informationSchemaColumn.setColumnName(name);
        informationSchemaColumn.setOrdinalPosition(index);
        return informationSchemaColumn;
    }

    private static MysqlColumnMetadata app(int index, String org) {
        MysqlColumnMetadata informationSchemaColumn = new MysqlColumnMetadata();
        informationSchemaColumn.setName(org);
        informationSchemaColumn.setPosition(index);
        return informationSchemaColumn;
    }

    public static class InformationSchemaColumnPosition {
        private String columnName;
        private Integer ordinalPosition;

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public Integer getOrdinalPosition() {
            return this.ordinalPosition;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public void setOrdinalPosition(Integer ordinalPosition) {
            this.ordinalPosition = ordinalPosition;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InformationSchemaColumnPosition)) {
                return false;
            }
            InformationSchemaColumnPosition other = (InformationSchemaColumnPosition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$ordinalPosition = this.getOrdinalPosition();
            Integer other$ordinalPosition = other.getOrdinalPosition();
            if (this$ordinalPosition == null ? other$ordinalPosition != null : !((Object)this$ordinalPosition).equals(other$ordinalPosition)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InformationSchemaColumnPosition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $ordinalPosition = this.getOrdinalPosition();
            result = result * 59 + ($ordinalPosition == null ? 43 : ((Object)$ordinalPosition).hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ColumnPositionHelper.InformationSchemaColumnPosition(columnName=" + this.getColumnName() + ", ordinalPosition=" + this.getOrdinalPosition() + ")";
        }

        @Generated
        public InformationSchemaColumnPosition(String columnName, Integer ordinalPosition) {
            this.columnName = columnName;
            this.ordinalPosition = ordinalPosition;
        }
    }
}

