/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.mysql.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.mysql.data.MysqlColumnMetadata;

public class MysqlCompareTableInfo
extends CompareTableInfo {
    private String engine;
    private String characterSet;
    private String collate;
    private String comment;
    private List<MysqlColumnMetadata> newPrimaries = new ArrayList<MysqlColumnMetadata>();
    private boolean dropPrimary;
    private final List<String> dropColumnList = new ArrayList<String>();
    private final List<MysqlModifyColumnMetadata> modifyMysqlColumnMetadataList = new ArrayList<MysqlModifyColumnMetadata>();
    private final List<String> dropIndexList = new ArrayList<String>();
    private final List<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();

    public MysqlCompareTableInfo(@NonNull String name, @NonNull String schema) {
        super(name, schema);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
    }

    public boolean needModify() {
        return this.engine != null || this.characterSet != null || this.collate != null || this.comment != null || this.dropPrimary || !this.newPrimaries.isEmpty() || !this.dropColumnList.isEmpty() || !this.modifyMysqlColumnMetadataList.isEmpty() || !this.dropIndexList.isEmpty() || !this.indexMetadataList.isEmpty();
    }

    public String validateFailedMessage() {
        StringBuilder errorMsg = new StringBuilder();
        if (this.engine != null) {
            errorMsg.append("\u8868\u5f15\u64ce\u53d8\u66f4\uff1a").append(this.engine).append("\n");
        }
        if (this.characterSet != null) {
            errorMsg.append("\u8868\u5b57\u7b26\u96c6\u53d8\u66f4\uff1a").append(this.characterSet).append("\n");
        }
        if (this.collate != null) {
            errorMsg.append("\u8868\u6392\u5e8f\u89c4\u5219\u53d8\u66f4\uff1a").append(this.collate).append("\n");
        }
        if (this.comment != null) {
            errorMsg.append("\u8868\u6ce8\u91ca\u53d8\u66f4\uff1a").append(this.comment).append("\n");
        }
        if (this.dropPrimary) {
            errorMsg.append("\u5220\u9664\u5168\u90e8\u4e3b\u952e").append("\n");
        }
        if (!this.newPrimaries.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u4e3b\u952e\uff1a").append(this.newPrimaries.stream().map(ColumnMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.dropColumnList.isEmpty()) {
            errorMsg.append("\u5220\u9664\u5217\uff1a").append(String.join((CharSequence)",", this.dropColumnList)).append("\n");
        }
        if (!this.modifyMysqlColumnMetadataList.isEmpty()) {
            String modifyColumn;
            String addColumn = this.modifyMysqlColumnMetadataList.stream().filter(m -> m.getType() == ModifyType.ADD).map(MysqlModifyColumnMetadata::getMysqlColumnMetadata).map(ColumnMetadata::getName).collect(Collectors.joining(","));
            if (!addColumn.isEmpty()) {
                errorMsg.append("\u65b0\u589e\u5217\uff1a").append(addColumn).append("\n");
            }
            if (!(modifyColumn = this.modifyMysqlColumnMetadataList.stream().filter(m -> m.getType() == ModifyType.MODIFY).map(MysqlModifyColumnMetadata::getMysqlColumnMetadata).map(ColumnMetadata::getName).collect(Collectors.joining(","))).isEmpty()) {
                errorMsg.append("\u4fee\u6539\u5217\uff1a").append(modifyColumn).append("\n");
            }
        }
        if (!this.dropIndexList.isEmpty()) {
            errorMsg.append("\u5220\u9664\u7d22\u5f15\uff1a").append(String.join((CharSequence)",", this.dropIndexList)).append("\n");
        }
        if (!this.indexMetadataList.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u7d22\u5f15\uff1a").append(this.indexMetadataList.stream().map(IndexMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        return errorMsg.toString();
    }

    public void addNewColumnMetadata(MysqlColumnMetadata mysqlColumnMetadata) {
        this.modifyMysqlColumnMetadataList.add(new MysqlModifyColumnMetadata(ModifyType.ADD, mysqlColumnMetadata));
    }

    public void addEditColumnMetadata(MysqlColumnMetadata mysqlColumnMetadata) {
        this.modifyMysqlColumnMetadataList.add(new MysqlModifyColumnMetadata(ModifyType.MODIFY, mysqlColumnMetadata));
    }

    public void resetPrimary(List<MysqlColumnMetadata> primaries) {
        this.newPrimaries = primaries;
        this.dropPrimary = true;
    }

    @Generated
    public String getEngine() {
        return this.engine;
    }

    @Generated
    public String getCharacterSet() {
        return this.characterSet;
    }

    @Generated
    public String getCollate() {
        return this.collate;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<MysqlColumnMetadata> getNewPrimaries() {
        return this.newPrimaries;
    }

    @Generated
    public boolean isDropPrimary() {
        return this.dropPrimary;
    }

    @Generated
    public List<String> getDropColumnList() {
        return this.dropColumnList;
    }

    @Generated
    public List<MysqlModifyColumnMetadata> getModifyMysqlColumnMetadataList() {
        return this.modifyMysqlColumnMetadataList;
    }

    @Generated
    public List<String> getDropIndexList() {
        return this.dropIndexList;
    }

    @Generated
    public List<IndexMetadata> getIndexMetadataList() {
        return this.indexMetadataList;
    }

    @Generated
    public void setEngine(String engine) {
        this.engine = engine;
    }

    @Generated
    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    @Generated
    public void setCollate(String collate) {
        this.collate = collate;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setNewPrimaries(List<MysqlColumnMetadata> newPrimaries) {
        this.newPrimaries = newPrimaries;
    }

    @Generated
    public void setDropPrimary(boolean dropPrimary) {
        this.dropPrimary = dropPrimary;
    }

    public static class MysqlModifyColumnMetadata {
        private ModifyType type;
        private MysqlColumnMetadata mysqlColumnMetadata;

        @Generated
        public ModifyType getType() {
            return this.type;
        }

        @Generated
        public MysqlColumnMetadata getMysqlColumnMetadata() {
            return this.mysqlColumnMetadata;
        }

        @Generated
        public void setType(ModifyType type) {
            this.type = type;
        }

        @Generated
        public void setMysqlColumnMetadata(MysqlColumnMetadata mysqlColumnMetadata) {
            this.mysqlColumnMetadata = mysqlColumnMetadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MysqlModifyColumnMetadata)) {
                return false;
            }
            MysqlModifyColumnMetadata other = (MysqlModifyColumnMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ModifyType this$type = this.getType();
            ModifyType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            MysqlColumnMetadata this$mysqlColumnMetadata = this.getMysqlColumnMetadata();
            MysqlColumnMetadata other$mysqlColumnMetadata = other.getMysqlColumnMetadata();
            return !(this$mysqlColumnMetadata == null ? other$mysqlColumnMetadata != null : !((Object)((Object)this$mysqlColumnMetadata)).equals((Object)other$mysqlColumnMetadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MysqlModifyColumnMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModifyType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            MysqlColumnMetadata $mysqlColumnMetadata = this.getMysqlColumnMetadata();
            result = result * 59 + ($mysqlColumnMetadata == null ? 43 : ((Object)((Object)$mysqlColumnMetadata)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MysqlCompareTableInfo.MysqlModifyColumnMetadata(type=" + (Object)((Object)this.getType()) + ", mysqlColumnMetadata=" + (Object)((Object)this.getMysqlColumnMetadata()) + ")";
        }

        @Generated
        public MysqlModifyColumnMetadata(ModifyType type, MysqlColumnMetadata mysqlColumnMetadata) {
            this.type = type;
            this.mysqlColumnMetadata = mysqlColumnMetadata;
        }
    }

    public static enum ModifyType {
        ADD,
        MODIFY;

    }
}

