/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.mysql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.annotation.enums.IndexSortTypeEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.mysql.ColumnPositionHelper;
import org.dromara.autotable.strategy.mysql.builder.CreateTableSqlBuilder;
import org.dromara.autotable.strategy.mysql.builder.ModifyTableSqlBuilder;
import org.dromara.autotable.strategy.mysql.builder.MysqlTableMetadataBuilder;
import org.dromara.autotable.strategy.mysql.data.MySqlDefaultTypeEnum;
import org.dromara.autotable.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.strategy.mysql.data.MysqlCompareTableInfo;
import org.dromara.autotable.strategy.mysql.data.MysqlTableMetadata;
import org.dromara.autotable.strategy.mysql.data.MysqlTypeHelper;
import org.dromara.autotable.strategy.mysql.data.dbdata.InformationSchemaColumn;
import org.dromara.autotable.strategy.mysql.data.dbdata.InformationSchemaStatistics;
import org.dromara.autotable.strategy.mysql.data.dbdata.InformationSchemaTable;
import org.dromara.autotable.strategy.mysql.mapper.MysqlTablesMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlStrategy
implements IStrategy<MysqlTableMetadata, MysqlCompareTableInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlStrategy.class);
    private final MysqlTablesMapper mapper = new MysqlTablesMapper();

    public String databaseDialect() {
        return "MySQL";
    }

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, MySqlDefaultTypeEnum.VARCHAR);
                this.put(Character.class, MySqlDefaultTypeEnum.CHAR);
                this.put(Character.TYPE, MySqlDefaultTypeEnum.CHAR);
                this.put(BigInteger.class, MySqlDefaultTypeEnum.BIGINT);
                this.put(Long.class, MySqlDefaultTypeEnum.BIGINT);
                this.put(Long.TYPE, MySqlDefaultTypeEnum.BIGINT);
                this.put(Integer.class, MySqlDefaultTypeEnum.INT);
                this.put(Integer.TYPE, MySqlDefaultTypeEnum.INT);
                this.put(Boolean.class, MySqlDefaultTypeEnum.BIT);
                this.put(Boolean.TYPE, MySqlDefaultTypeEnum.BIT);
                this.put(Float.class, MySqlDefaultTypeEnum.FLOAT);
                this.put(Float.TYPE, MySqlDefaultTypeEnum.FLOAT);
                this.put(Double.class, MySqlDefaultTypeEnum.DOUBLE);
                this.put(Double.TYPE, MySqlDefaultTypeEnum.DOUBLE);
                this.put(BigDecimal.class, MySqlDefaultTypeEnum.DECIMAL);
                this.put(java.util.Date.class, MySqlDefaultTypeEnum.DATETIME);
                this.put(Date.class, MySqlDefaultTypeEnum.DATE);
                this.put(Timestamp.class, MySqlDefaultTypeEnum.DATETIME);
                this.put(Time.class, MySqlDefaultTypeEnum.TIME);
                this.put(LocalDateTime.class, MySqlDefaultTypeEnum.DATETIME);
                this.put(LocalDate.class, MySqlDefaultTypeEnum.DATE);
                this.put(LocalTime.class, MySqlDefaultTypeEnum.TIME);
                this.put(Short.class, MySqlDefaultTypeEnum.SMALLINT);
                this.put(Short.TYPE, MySqlDefaultTypeEnum.SMALLINT);
            }
        };
    }

    public String dropTable(String schema, String tableName) {
        return String.format("DROP TABLE IF EXISTS `%s`", tableName);
    }

    @NonNull
    public MysqlTableMetadata analyseClass(Class<?> beanClass) {
        return MysqlTableMetadataBuilder.build(beanClass);
    }

    public List<String> createTable(MysqlTableMetadata tableMetadata) {
        String sql = CreateTableSqlBuilder.buildSql(tableMetadata);
        return Collections.singletonList(sql);
    }

    @NonNull
    public MysqlCompareTableInfo compareTable(MysqlTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        MysqlCompareTableInfo mysqlCompareTableInfo = new MysqlCompareTableInfo(tableName, schema);
        InformationSchemaTable informationSchemaTable = this.mapper.findTableByTableName(tableName);
        MysqlStrategy.compareTableProperties(tableMetadata, informationSchemaTable, mysqlCompareTableInfo);
        this.compareColumns(tableMetadata, tableName, mysqlCompareTableInfo);
        List<InformationSchemaStatistics> informationSchemaStatistics = this.mapper.queryTablePrimaryAndIndex(tableName);
        Map<String, List<InformationSchemaStatistics>> keyColumnGroupByName = informationSchemaStatistics.stream().collect(Collectors.groupingBy(InformationSchemaStatistics::getIndexName));
        List<InformationSchemaStatistics> tablePrimaries = keyColumnGroupByName.remove("PRIMARY");
        MysqlStrategy.comparePrimary(tableMetadata, mysqlCompareTableInfo, tablePrimaries);
        Map<String, List<InformationSchemaStatistics>> tableIndexes = keyColumnGroupByName;
        this.compareIndexes(tableMetadata, mysqlCompareTableInfo, tableIndexes);
        return mysqlCompareTableInfo;
    }

    public List<String> modifyTable(MysqlCompareTableInfo mysqlCompareTableInfo) {
        String sql = ModifyTableSqlBuilder.buildSql(mysqlCompareTableInfo);
        return Collections.singletonList(sql);
    }

    private void compareIndexes(MysqlTableMetadata mysqlTableMetadata, MysqlCompareTableInfo mysqlCompareTableInfo, Map<String, List<InformationSchemaStatistics>> tableIndexes) {
        List<IndexMetadata> indexMetadataList = mysqlTableMetadata.getIndexMetadataList();
        block0: for (IndexMetadata indexMetadata : indexMetadataList) {
            String indexName2 = indexMetadata.getName();
            List<InformationSchemaStatistics> theIndexColumns = tableIndexes.remove(indexName2);
            if (theIndexColumns == null) {
                mysqlCompareTableInfo.getIndexMetadataList().add(indexMetadata);
                continue;
            }
            theIndexColumns = theIndexColumns.stream().sorted(Comparator.comparing(InformationSchemaStatistics::getSeqInIndex)).collect(Collectors.toList());
            List columns = indexMetadata.getColumns();
            if (theIndexColumns.size() != columns.size()) {
                mysqlCompareTableInfo.getDropIndexList().add(indexName2);
                mysqlCompareTableInfo.getIndexMetadataList().add(indexMetadata);
                continue;
            }
            for (int i = 0; i < theIndexColumns.size(); ++i) {
                boolean sortTypeIsDiff;
                InformationSchemaStatistics informationSchemaStatistics = theIndexColumns.get(i);
                IndexSortTypeEnum indexSort = IndexSortTypeEnum.parseFromMysql((String)informationSchemaStatistics.getCollation());
                IndexMetadata.IndexColumnParam indexColumnParam = (IndexMetadata.IndexColumnParam)columns.get(i);
                IndexSortTypeEnum indexColumnParamSort = indexColumnParam.getSort();
                boolean nameIsDiff = !informationSchemaStatistics.getColumnName().equals(indexColumnParam.getColumn());
                boolean bl = sortTypeIsDiff = indexColumnParamSort != null && indexColumnParamSort != indexSort;
                if (!nameIsDiff && !sortTypeIsDiff) continue;
                mysqlCompareTableInfo.getDropIndexList().add(indexName2);
                mysqlCompareTableInfo.getIndexMetadataList().add(indexMetadata);
                continue block0;
            }
        }
        Set<String> needDropIndexes = tableIndexes.keySet();
        if (!needDropIndexes.isEmpty()) {
            PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
            if (autoTableProperties.getAutoDropIndex().booleanValue()) {
                List autoTableCreateIndexes = needDropIndexes.stream().filter(indexName -> indexName.startsWith(autoTableProperties.getIndexPrefix())).collect(Collectors.toList());
                mysqlCompareTableInfo.getDropIndexList().addAll(autoTableCreateIndexes);
            }
            if (autoTableProperties.getAutoDropCustomIndex().booleanValue()) {
                List customCreateIndexes = needDropIndexes.stream().filter(indexName -> !indexName.startsWith(autoTableProperties.getIndexPrefix())).collect(Collectors.toList());
                mysqlCompareTableInfo.getDropIndexList().addAll(customCreateIndexes);
            }
        }
    }

    private static void comparePrimary(MysqlTableMetadata mysqlTableMetadata, MysqlCompareTableInfo mysqlCompareTableInfo, List<InformationSchemaStatistics> tablePrimaries) {
        boolean entityHasPrimary;
        List<MysqlColumnMetadata> primaries = mysqlTableMetadata.getColumnMetadataList().stream().filter(ColumnMetadata::isPrimary).collect(Collectors.toList());
        boolean tableNoPrimary = tablePrimaries == null || tablePrimaries.isEmpty();
        boolean bl = entityHasPrimary = !primaries.isEmpty();
        if (tableNoPrimary && entityHasPrimary) {
            mysqlCompareTableInfo.setNewPrimaries(primaries);
        }
        if (!tableNoPrimary && !entityHasPrimary) {
            mysqlCompareTableInfo.setDropPrimary(true);
        }
        if (!tableNoPrimary && entityHasPrimary) {
            boolean needResetPrimary;
            boolean sameSize = tablePrimaries.size() == primaries.size();
            boolean bl2 = needResetPrimary = !sameSize;
            if (sameSize) {
                tablePrimaries = tablePrimaries.stream().sorted(Comparator.comparing(InformationSchemaStatistics::getSeqInIndex)).collect(Collectors.toList());
                for (int i = 0; i < tablePrimaries.size(); ++i) {
                    InformationSchemaStatistics tablePrimary = tablePrimaries.get(i);
                    if (tablePrimary.getColumnName().equals(primaries.get(i).getName())) continue;
                    needResetPrimary = true;
                    break;
                }
            }
            if (needResetPrimary) {
                mysqlCompareTableInfo.resetPrimary(primaries);
            }
        }
    }

    private void compareColumns(MysqlTableMetadata mysqlTableMetadata, String tableName, MysqlCompareTableInfo mysqlCompareTableInfo) {
        List<MysqlColumnMetadata> mysqlColumnMetadataList = mysqlTableMetadata.getColumnMetadataList();
        Map columnParamMap = mysqlColumnMetadataList.stream().collect(Collectors.toMap(ColumnMetadata::getName, Function.identity()));
        List<InformationSchemaColumn> tableColumnList = this.mapper.findTableEnsembleByTableName(tableName);
        ColumnPositionHelper.generateChangePosition(tableColumnList, mysqlColumnMetadataList);
        for (InformationSchemaColumn informationSchemaColumn : tableColumnList) {
            String columnName = informationSchemaColumn.getColumnName();
            MysqlColumnMetadata mysqlColumnMetadata = (MysqlColumnMetadata)((Object)columnParamMap.remove(columnName));
            if (mysqlColumnMetadata != null) {
                boolean columnPositionChanged = mysqlColumnMetadata.getNewPreColumn() != null;
                boolean commentChanged = MysqlStrategy.isCommentChanged(informationSchemaColumn, mysqlColumnMetadata);
                boolean fieldTypeChanged = MysqlStrategy.isFieldTypeChanged(informationSchemaColumn, mysqlColumnMetadata);
                boolean notNullChanged = mysqlColumnMetadata.isNotNull() != informationSchemaColumn.isNotNull();
                boolean fieldIsAutoIncrementChanged = mysqlColumnMetadata.isAutoIncrement() != informationSchemaColumn.isAutoIncrement();
                boolean defaultValueChanged = MysqlStrategy.isDefaultValueChanged(informationSchemaColumn, mysqlColumnMetadata);
                boolean charsetChanged = MysqlStrategy.isCharsetChanged(informationSchemaColumn, mysqlColumnMetadata);
                if (!columnPositionChanged && !commentChanged && !fieldTypeChanged && !notNullChanged && !fieldIsAutoIncrementChanged && !defaultValueChanged && !charsetChanged) continue;
                mysqlCompareTableInfo.addEditColumnMetadata(mysqlColumnMetadata);
                continue;
            }
            if (!AutoTableGlobalConfig.instance().getAutoTableProperties().getAutoDropColumn().booleanValue()) continue;
            mysqlCompareTableInfo.getDropColumnList().add(columnName);
        }
        Collection needNewColumns = columnParamMap.values();
        for (MysqlColumnMetadata needNewColumn : needNewColumns) {
            mysqlCompareTableInfo.addNewColumnMetadata(needNewColumn);
        }
    }

    private static boolean isCharsetChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        boolean charsetDiff = StringUtils.hasText((String)mysqlColumnMetadata.getCharacterSet()) && !Objects.equals(mysqlColumnMetadata.getCharacterSet(), informationSchemaColumn.getCharacterSetName());
        boolean collateDiff = StringUtils.hasText((String)mysqlColumnMetadata.getCollate()) && !Objects.equals(mysqlColumnMetadata.getCollate(), informationSchemaColumn.getCollationName());
        return charsetDiff || collateDiff;
    }

    private static boolean isDefaultValueChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        String columnDefault = informationSchemaColumn.getColumnDefault();
        DefaultValueEnum defaultValueType = mysqlColumnMetadata.getDefaultValueType();
        if (DefaultValueEnum.isValid((DefaultValueEnum)defaultValueType)) {
            if (defaultValueType == DefaultValueEnum.NULL) {
                return columnDefault != null;
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return !"".equals(columnDefault);
            }
        } else {
            DatabaseTypeAndLength columnType = mysqlColumnMetadata.getType();
            if (MysqlTypeHelper.isBoolean(columnType) && columnDefault != null && columnDefault.startsWith("b'") && columnDefault.endsWith("'")) {
                columnDefault = columnDefault.substring(2, columnDefault.length() - 1);
            }
            String defaultValue = mysqlColumnMetadata.getDefaultValue();
            if (MysqlTypeHelper.isFloatNumber(columnType) && columnDefault != null && columnDefault.matches("[0-9]+(.[0-9]+)?")) {
                try {
                    columnDefault = String.valueOf(Double.parseDouble(columnDefault));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    defaultValue = String.valueOf(Double.parseDouble(defaultValue));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (MysqlTypeHelper.needStringCompatibility(columnType) && defaultValue != null && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            return !Objects.equals(defaultValue, columnDefault);
        }
        return false;
    }

    private static boolean isFieldTypeChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        boolean isTypeDiff;
        DatabaseTypeAndLength fieldType = mysqlColumnMetadata.getType();
        String fullType = MysqlTypeHelper.getFullType(fieldType);
        String dbColumnTypeStr = informationSchemaColumn.getColumnType();
        List<String> dbColumnTypeArr = Arrays.asList(dbColumnTypeStr.split(" "));
        String dbColumnType = dbColumnTypeArr.get(0);
        if (MysqlTypeHelper.isEnum(fieldType)) {
            isTypeDiff = !fullType.equals(dbColumnType);
        } else if (MysqlTypeHelper.isNoLengthNumber(fieldType)) {
            isTypeDiff = !fullType.equalsIgnoreCase(dbColumnType) && !fullType.equalsIgnoreCase(informationSchemaColumn.getDataType());
        } else {
            boolean bl = isTypeDiff = !fullType.equalsIgnoreCase(dbColumnType);
        }
        if (isTypeDiff) {
            return true;
        }
        boolean dbHasQualifier = dbColumnTypeArr.size() > 1;
        boolean isQualifierDiff = false;
        if (mysqlColumnMetadata.hasQualifier() || dbHasQualifier) {
            if (mysqlColumnMetadata.isUnsigned() != dbColumnTypeArr.stream().anyMatch("unsigned"::equalsIgnoreCase)) {
                isQualifierDiff = true;
            } else if (mysqlColumnMetadata.isZerofill() != dbColumnTypeArr.stream().anyMatch("zerofill"::equalsIgnoreCase)) {
                isQualifierDiff = true;
            }
        }
        return isQualifierDiff;
    }

    private static boolean isCommentChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        String fieldComment = mysqlColumnMetadata.getComment();
        String dbColumnComment = informationSchemaColumn.getColumnComment();
        return (StringUtils.hasText((String)fieldComment) || StringUtils.hasText((String)dbColumnComment)) && !fieldComment.equals(dbColumnComment);
    }

    private static void compareTableProperties(MysqlTableMetadata mysqlTableMetadata, InformationSchemaTable tableInformation, MysqlCompareTableInfo mysqlCompareTableInfo) {
        String charset;
        String collate;
        String tableComment = mysqlTableMetadata.getComment();
        String tableCharset = mysqlTableMetadata.getCharacterSet();
        String tableCollate = mysqlTableMetadata.getCollate();
        String tableEngine = mysqlTableMetadata.getEngine();
        if (StringUtils.hasText((String)tableComment) && !tableComment.equals(tableInformation.getTableComment())) {
            mysqlCompareTableInfo.setComment(tableComment);
        }
        if (StringUtils.hasText((String)tableCharset) && StringUtils.hasText((String)(collate = tableInformation.getTableCollation())) && (!tableCharset.equals(charset = collate.substring(0, collate.indexOf("_"))) || !tableCollate.equals(collate))) {
            mysqlCompareTableInfo.setCharacterSet(tableCharset);
            mysqlCompareTableInfo.setCollate(tableCollate);
        }
        if (StringUtils.hasText((String)tableEngine) && !tableEngine.equals(tableInformation.getEngine())) {
            mysqlCompareTableInfo.setEngine(tableEngine);
        }
    }
}

