/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.mysql.builder;

import java.util.List;
import lombok.Generated;
import org.dromara.autotable.annotation.mysql.MysqlCharset;
import org.dromara.autotable.annotation.mysql.MysqlEngine;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.builder.IndexMetadataBuilder;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.utils.BeanClassUtil;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.dromara.autotable.strategy.mysql.builder.MysqlColumnMetadataBuilder;
import org.dromara.autotable.strategy.mysql.data.MysqlTableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTableMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlTableMetadataBuilder.class);

    public static MysqlTableMetadata build(Class<?> clazz) {
        MysqlEngine mysqlEngine;
        String collate;
        String charset;
        String tableName = TableMetadataHandler.getTableName(clazz);
        String tableComment = TableMetadataHandler.getTableComment(clazz);
        MysqlTableMetadata mysqlTableMetadata = new MysqlTableMetadata(clazz, tableName, tableComment);
        MysqlCharset mysqlCharsetAnno = (MysqlCharset)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(clazz, MysqlCharset.class);
        if (mysqlCharsetAnno != null) {
            charset = mysqlCharsetAnno.charset();
            collate = mysqlCharsetAnno.collate();
        } else {
            PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
            charset = autoTableProperties.getMysql().getTableDefaultCharset();
            collate = autoTableProperties.getMysql().getTableDefaultCollation();
        }
        if (StringUtils.hasText((String)charset) && StringUtils.hasText((String)collate)) {
            mysqlTableMetadata.setCharacterSet(charset);
            mysqlTableMetadata.setCollate(collate);
        }
        if ((mysqlEngine = (MysqlEngine)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(clazz, MysqlEngine.class)) != null) {
            mysqlTableMetadata.setEngine(mysqlEngine.value());
        }
        List fields = BeanClassUtil.sortAllFieldForColumn(clazz);
        List columnMetadataList = new MysqlColumnMetadataBuilder().buildList(clazz, fields);
        mysqlTableMetadata.setColumnMetadataList(columnMetadataList);
        List indexMetadataList = new IndexMetadataBuilder().buildList(clazz, fields);
        mysqlTableMetadata.setIndexMetadataList(indexMetadataList);
        return mysqlTableMetadata;
    }
}

